/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.common.io.ByteStreams;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModItems;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VampireBookManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static VampireBookManager ourInstance = new VampireBookManager();
    private CompoundNBT[] bookTags = null;

    public static VampireBookManager getInstance() {
        return ourInstance;
    }

    private VampireBookManager() {
    }

    public void applyRandomBook(ItemStack stack, Random rnd) {
        CompoundNBT nbt = this.bookTags == null || this.bookTags.length == 0 ? new CompoundNBT() : this.bookTags[rnd.nextInt(this.bookTags.length)];
        stack.func_77982_d(nbt);
    }

    public ItemStack getRandomBook(Random rnd) {
        ItemStack book = new ItemStack((IItemProvider)ModItems.vampire_book, 1);
        this.applyRandomBook(book, rnd);
        return book;
    }

    public void init() {
        InputStream inputStream = null;
        try {
            inputStream = VampirismMod.class.getResourceAsStream("/vampireBooks.txt");
            if (inputStream == null) {
                throw new IOException("Could not find 'vampireBooks.txt' in resources");
            }
            String data = new String(ByteStreams.toByteArray((InputStream)inputStream));
            this.parseBooks(data);
        }
        catch (CommandSyntaxException e) {
            LOGGER.warn("----------------------------------------");
            LOGGER.error("Failed to convert vampire books to NBT", (Throwable)e);
            LOGGER.warn("----------------------------------------");
        }
        catch (IOException e) {
            LOGGER.error("Failed to read vampire books from resources", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to close InputStream", (Throwable)e);
                }
            }
        }
    }

    private void parseBooks(String data) throws CommandSyntaxException {
        String[] lines;
        ArrayList<CompoundNBT> books = new ArrayList<CompoundNBT>();
        for (String line : lines = data.split("\n")) {
            CompoundNBT nbt = JsonToNBT.func_180713_a((String)line);
            books.add(nbt);
        }
        this.bookTags = books.toArray(new CompoundNBT[books.size()]);
    }
}

