/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world;

import com.google.common.collect.Maps;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.world.IGarlicChunkHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GarlicChunkHandler
implements IGarlicChunkHandler {
    private static final Logger LOGGER = LogManager.getLogger(GarlicChunkHandler.class);
    private final HashMap<ChunkPos, EnumStrength> strengthHashMap = Maps.newHashMap();
    private final HashMap<Integer, Emitter> emitterHashMap = Maps.newHashMap();

    @Override
    public void clear() {
        this.strengthHashMap.clear();
        this.emitterHashMap.clear();
    }

    @Override
    @Nonnull
    public EnumStrength getStrengthAtChunk(ChunkPos pos) {
        EnumStrength s = this.strengthHashMap.get(pos);
        return s == null ? EnumStrength.NONE : s;
    }

    public void printDebug(CommandSource sender) {
        for (Emitter emitter : this.emitterHashMap.values()) {
            sender.func_197030_a((ITextComponent)new StringTextComponent("E: " + emitter.toString()), true);
        }
        for (Map.Entry entry : this.strengthHashMap.entrySet()) {
            sender.func_197030_a((ITextComponent)new StringTextComponent("S: " + entry.toString()), true);
        }
    }

    private static boolean isHostingClient() {
        return EffectiveSide.get().isClient() && ServerLifecycleHooks.getCurrentServer() != null;
    }

    @Override
    public int registerGarlicBlock(EnumStrength strength, ChunkPos ... pos) {
        for (ChunkPos p : pos) {
            if (p != null) continue;
            throw new IllegalArgumentException("Garlic emitter position should not be null");
        }
        Emitter e = new Emitter(strength, pos);
        int hash = e.hashCode();
        if (GarlicChunkHandler.isHostingClient()) {
            return hash;
        }
        this.emitterHashMap.put(hash, e);
        this.rebuildStrengthMap();
        return hash;
    }

    private void rebuildStrengthMap() {
        this.strengthHashMap.clear();
        for (Emitter e : this.emitterHashMap.values()) {
            for (ChunkPos pos : e.pos) {
                EnumStrength old = this.strengthHashMap.get(pos);
                if (old != null && !e.strength.isStrongerThan(old)) continue;
                this.strengthHashMap.put(pos, e.strength);
            }
        }
    }

    @Override
    public void removeGarlicBlock(int id) {
        if (GarlicChunkHandler.isHostingClient()) {
            return;
        }
        Emitter e = this.emitterHashMap.remove(id);
        if (e == null) {
            LOGGER.debug("Removed emitter did not exist");
        }
        this.rebuildStrengthMap();
    }

    private class Emitter {
        final EnumStrength strength;
        final ChunkPos[] pos;

        private Emitter(EnumStrength strength, ChunkPos[] pos) {
            this.strength = strength;
            this.pos = pos;
        }

        public String toString() {
            return "Emitter{pos=" + Arrays.toString(this.pos) + ", strength=" + (Object)((Object)this.strength) + '}';
        }
    }

    public static class Provider
    implements IGarlicChunkHandler.Provider {
        private final HashMap<DimensionType, IGarlicChunkHandler> handlers = Maps.newHashMap();

        @Override
        public void clear() {
            for (IGarlicChunkHandler handler : this.handlers.values()) {
                handler.clear();
            }
            this.handlers.clear();
        }

        @Override
        @Nonnull
        public IGarlicChunkHandler getHandler(IWorld world) {
            return this.handlers.computeIfAbsent(world.func_201675_m().func_186058_p(), k -> new GarlicChunkHandler());
        }
    }
}

