/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.functions.ILootFunction;

public class SetMetaBasedOnLevel
implements ILootFunction {
    private final int max;
    private final LootContext.EntityTarget target;

    protected SetMetaBasedOnLevel(int max, LootContext.EntityTarget targetIn) {
        this.max = max;
        this.target = targetIn;
    }

    public ItemStack apply(ItemStack stack, LootContext context) {
        if (context.func_216031_c(this.target.func_216029_a()) instanceof IAdjustableLevel) {
            int l = ((IAdjustableLevel)this.target.func_216029_a()).getLevel();
            if (this.max != -1) {
                l = Math.min(this.max, l);
            }
            stack.func_196085_b(l);
        }
        return stack;
    }

    public static class Serializer
    extends ILootFunction.Serializer<SetMetaBasedOnLevel> {
        public Serializer() {
            super(new ResourceLocation("vampirism", "set_meta_from_level"), SetMetaBasedOnLevel.class);
        }

        public SetMetaBasedOnLevel deserialize(JsonObject json, JsonDeserializationContext context) {
            return new SetMetaBasedOnLevel(json.has("max") ? JSONUtils.func_151203_m((JsonObject)json, (String)"max") : -1, (LootContext.EntityTarget)JSONUtils.func_188174_a((JsonObject)json, (String)"entity", (JsonDeserializationContext)context, LootContext.EntityTarget.class));
        }

        public void serialize(JsonObject json, SetMetaBasedOnLevel value, JsonSerializationContext context) {
            if (value.max != -1) {
                json.addProperty("max", (Number)value.max);
            }
            json.add("entity", context.serialize((Object)value.target));
        }
    }
}

