/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.inventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryHelper {
    public static ItemStack checkItems(IInventory inventory, Item[] items, int[] amounts) {
        if (inventory.func_70302_i_() < amounts.length || items.length != amounts.length) {
            throw new IllegalArgumentException("There has to be one itemstack and amount value for each item");
        }
        for (int i = 0; i < items.length; ++i) {
            int actual;
            ItemStack stack = inventory.func_70301_a(i);
            int n = actual = !stack.func_190926_b() && stack.func_77973_b().equals(items[i]) ? stack.func_190916_E() : 0;
            if (actual >= amounts[i]) continue;
            return new ItemStack((IItemProvider)items[i], amounts[i] - actual);
        }
        return ItemStack.field_190927_a;
    }

    public static void removeItems(IInventory inventory, int[] amounts) {
        if (inventory.func_70302_i_() < amounts.length) {
            throw new IllegalArgumentException("There has to be one itemstack value for each amount");
        }
        for (int i = 0; i < amounts.length; ++i) {
            inventory.func_70298_a(i, amounts[i]);
        }
    }

    @Nonnull
    public static LazyOptional<Pair<IItemHandler, TileEntity>> tryGetItemHandler(IBlockReader world, BlockPos pos, @Nullable Direction side) {
        TileEntity tile;
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().hasTileEntity(state) && (tile = world.func_175625_s(pos)) != null) {
            return tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(capability -> ImmutablePair.of((Object)capability, (Object)tile));
        }
        return LazyOptional.empty();
    }
}

