/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blocks.VampirismBlock;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class AltarPillarBlock
extends VampirismBlock {
    public static final EnumProperty<EnumPillarType> TYPE_PROPERTY = EnumProperty.func_177709_a((String)"type", EnumPillarType.class);
    protected static final VoxelShape pillarShape = AltarPillarBlock.makeShape();
    protected static final VoxelShape pillarShapeFilled = AltarPillarBlock.makeShapeFull();
    private static final String name = "altar_pillar";

    private static VoxelShape makeShape() {
        VoxelShape a = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
        VoxelShape b1 = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)4.0, (double)16.0, (double)4.0);
        VoxelShape b2 = Block.func_208617_a((double)12.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)4.0);
        VoxelShape b3 = Block.func_208617_a((double)3.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)13.0);
        VoxelShape b4 = Block.func_208617_a((double)12.0, (double)0.0, (double)12.0, (double)13.0, (double)16.0, (double)13.0);
        VoxelShape c = Block.func_208617_a((double)3.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        return VoxelShapes.func_216384_a((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b1, b2, b3, b4, c});
    }

    private static VoxelShape makeShapeFull() {
        VoxelShape a = pillarShape;
        VoxelShape b = Block.func_208617_a((double)4.0, (double)1.0, (double)2.0, (double)12.0, (double)15.0, (double)14.0);
        VoxelShape c = Block.func_208617_a((double)2.0, (double)1.0, (double)4.0, (double)14.0, (double)15.0, (double)12.0);
        return VoxelShapes.func_216384_a((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c});
    }

    public AltarPillarBlock() {
        super(name, Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(0.9f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(TYPE_PROPERTY, (Comparable)((Object)EnumPillarType.NONE)));
    }

    public int getHarvestLevel(BlockState p_getHarvestLevel_1_) {
        return 0;
    }

    @Nullable
    public ToolType getHarvestTool(BlockState p_getHarvestTool_1_) {
        return ToolType.PICKAXE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return state.func_177229_b(TYPE_PROPERTY) != EnumPillarType.NONE ? pillarShapeFilled : pillarShape;
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        EnumPillarType type = (EnumPillarType)((Object)state.func_177229_b(TYPE_PROPERTY));
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (type != EnumPillarType.NONE && heldItem.func_190926_b()) {
            if (!playerIn.field_71075_bZ.field_75098_d) {
                playerIn.func_184201_a(hand == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)Item.func_150898_a((Block)type.fillerBlock)));
            }
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a(TYPE_PROPERTY, (Comparable)((Object)EnumPillarType.NONE)));
            return ActionResultType.SUCCESS;
        }
        if (type == EnumPillarType.NONE && !heldItem.func_190926_b()) {
            for (EnumPillarType t : EnumPillarType.values()) {
                if (!heldItem.func_77973_b().equals(t.fillerBlock.func_199767_j())) continue;
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a(TYPE_PROPERTY, (Comparable)((Object)t)));
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new IProperty[]{TYPE_PROPERTY});
    }

    public static enum EnumPillarType implements IStringSerializable
    {
        NONE(0, "none", 0.0f, Blocks.field_150350_a),
        STONE(1, "stone", 1.0f, Blocks.field_196696_di),
        IRON(2, "iron", 2.0f, Blocks.field_150339_S),
        GOLD(3, "gold", 3.0f, Blocks.field_150340_R),
        BONE(4, "bone", 1.5f, Blocks.field_189880_di);

        public final String name;
        public final Block fillerBlock;
        public final int meta;
        private final float value;

        private EnumPillarType(int meta, String name, float value, Block fillerBlock) {
            this.meta = meta;
            this.name = name;
            this.fillerBlock = fillerBlock;
            this.value = value;
        }

        public String func_176610_l() {
            return this.name;
        }

        public float getValue() {
            return this.value;
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

