/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blocks.CastleStairsBlock;
import de.teamlapen.vampirism.blocks.VampirismBlock;
import de.teamlapen.vampirism.core.ModSounds;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CastleBricksBlock
extends VampirismBlock {
    private static final String name = "castle_block";
    private final EnumVariant variant;

    public CastleBricksBlock(EnumVariant variant) {
        super("castle_block_" + variant.func_176610_l(), Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 10.0f).func_200947_a(SoundType.field_185851_d));
        this.variant = variant;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, tooltip, advanced);
        tooltip.add(new TranslationTextComponent("block.vampirism.castle_block" + (this.variant == EnumVariant.DARK_STONE ? ".no_spawn" : ".vampire_spawn"), new Object[0]).func_211708_a(TextFormatting.ITALIC));
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (!CastleStairsBlock.func_185709_i((BlockState)state) && this.variant == EnumVariant.DARK_BRICK_BLOODY && rand.nextInt(180) == 0) {
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ModSounds.ambient_castle, SoundCategory.AMBIENT, 0.8f, 1.0f, false);
        }
    }

    public EnumVariant getVariant() {
        return this.variant;
    }

    public static enum EnumVariant implements IStringSerializable
    {
        DARK_BRICK,
        PURPLE_BRICK,
        DARK_BRICK_BLOODY,
        NORMAL_BRICK,
        DARK_STONE;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

