/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.inventory.container.BloodPotionTableContainer;
import de.teamlapen.vampirism.network.InputEventPacket;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BloodPotionTableScreen
extends ContainerScreen<BloodPotionTableContainer> {
    private final ResourceLocation TABLE_GUI_TEXTURES = new ResourceLocation("vampirism", "textures/gui/blood_potion_table.png");
    private Button craftBtn;
    private ISound sound;

    public BloodPotionTableScreen(BloodPotionTableContainer inventorySlotsIn, PlayerInventory playerInventory, ITextComponent name) {
        super((Container)inventorySlotsIn, playerInventory, name);
    }

    public void init() {
        super.init();
        this.craftBtn = new Button(this.width / 2 - 77, this.height / 2 - 78, this.font.func_78256_a(UtilLib.translate("gui.vampirism.blood_potion_table.create", new Object[0])) + 5, 20, UtilLib.translate("gui.vampirism.blood_potion_table.create", new Object[0]), context -> this.handleClicked());
        this.addButton((Widget)this.craftBtn);
        this.craftBtn.active = false;
    }

    public void onClose() {
        super.onClose();
        this.stopSound();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void tick() {
        super.tick();
        this.craftBtn.active = ((BloodPotionTableContainer)this.field_147002_h).canCurrentlyStartCrafting();
        if (((BloodPotionTableContainer)this.field_147002_h).getCraftingPercentage() == 0.0f || ((BloodPotionTableContainer)this.field_147002_h).getCraftingPercentage() == 1.0f) {
            this.stopSound();
        } else {
            this.startSound();
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int j1;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        this.minecraft.func_110434_K().func_110577_a(this.TABLE_GUI_TEXTURES);
        this.blit(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        if (((BloodPotionTableContainer)this.field_147002_h).getCraftingPercentage() > 0.0f && (j1 = (int)(28.0f * ((BloodPotionTableContainer)this.field_147002_h).getCraftingPercentage())) > 0) {
            this.blit(i + 145, j + 23, 176, 0, 9, j1);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        List<String> hints = ((BloodPotionTableContainer)this.field_147002_h).getLocalizedCraftingHint();
        if (hints != null) {
            int i = (this.width - this.field_146999_f) / 2;
            int j = (this.height - this.field_147000_g) / 2;
            for (String hint : hints) {
                this.font.func_78279_b(hint, i + 5, j + 28, 92, Color.WHITE.getRGB());
                j += this.font.func_78267_b(hint, 92);
            }
        }
    }

    private void handleClicked() {
        VampirismMod.dispatcher.sendToServer(new InputEventPacket("cb", ""));
    }

    private void startSound() {
        if (this.sound == null) {
            ((BloodPotionTableContainer)this.field_147002_h).getWorldPosCallable().func_221486_a((world, pos) -> {
                this.sound = new SimpleSound(ModSounds.boiling, SoundCategory.BLOCKS, 1.0f, 1.0f, pos);
                this.minecraft.func_147118_V().func_147682_a(this.sound);
            });
        }
    }

    private void stopSound() {
        if (this.sound != null) {
            this.minecraft.func_147118_V().func_147683_b(this.sound);
            this.sound = null;
        }
    }
}

