/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.teamlapen.lib.lib.client.gui.GuiPieMenu;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.network.InputEventPacket;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class SelectActionScreen
extends GuiPieMenu<IAction> {
    public static final List<IAction> ACTIONORDER = Lists.newArrayList();
    public static IAction SELECTEDACTION;
    private static IAction fakeAction;
    private IActionHandler actionHandler;
    private boolean editActions;

    private static void saveActionOrder() {
        StringBuilder s = new StringBuilder();
        Iterator<IAction> iterator = ACTIONORDER.iterator();
        while (iterator.hasNext()) {
            IAction action = iterator.next();
            if (action == fakeAction) continue;
            s.append(action.getRegistryName());
            if (!iterator.hasNext()) continue;
            s.append(",");
        }
        VampirismConfig.CLIENT.actionOrder.set((Object)s.toString());
    }

    public static void loadActionOrder() {
        String[] actionOrder;
        ArrayList actions = Lists.newArrayList((Iterable)ModRegistries.ACTIONS.getValues());
        for (String s : actionOrder = ((String)VampirismConfig.CLIENT.actionOrder.get()).split(",")) {
            IAction a;
            ResourceLocation name = ResourceLocation.func_208304_a((String)s);
            if (name == null || (a = (IAction)ModRegistries.ACTIONS.getValue(name)) == null) continue;
            ACTIONORDER.add(a);
            actions.remove(a);
        }
        if (!actions.isEmpty()) {
            ACTIONORDER.addAll(actions);
            SelectActionScreen.saveActionOrder();
        }
    }

    public SelectActionScreen(Color backgroundColor, boolean edit) {
        super(backgroundColor, (ITextComponent)new TranslationTextComponent("selectAction", new Object[0]));
        this.editActions = edit;
    }

    public boolean keyPressed(int key, int scancode, int modifiers) {
        if (this.editActions && key == 256) {
            this.onClose();
            return true;
        }
        if (this.getSelectedElement() >= 0) {
            if (this.elements.get(this.getSelectedElement()) == fakeAction) {
                return true;
            }
            if (ModKeys.getKeyBinding(ModKeys.KEY.ACTION1).func_197976_a(key, scancode)) {
                FactionPlayerHandler.get((PlayerEntity)Minecraft.func_71410_x().field_71439_g).setBoundAction1((IAction)this.elements.get(this.getSelectedElement()), true);
                if (!this.editActions) {
                    GLFW.glfwSetCursorPos((long)this.minecraft.func_228018_at_().func_198092_i(), (double)((float)this.minecraft.func_228018_at_().func_198105_m() / 2.0f), (double)((float)this.minecraft.func_228018_at_().func_198083_n() / 2.0f));
                    this.onClose();
                }
                return true;
            }
            if (ModKeys.getKeyBinding(ModKeys.KEY.ACTION2).func_197976_a(key, scancode)) {
                FactionPlayerHandler.get((PlayerEntity)Minecraft.func_71410_x().field_71439_g).setBoundAction2((IAction)this.elements.get(this.getSelectedElement()), true);
                if (!this.editActions) {
                    GLFW.glfwSetCursorPos((long)this.minecraft.func_228018_at_().func_198092_i(), (double)((float)this.minecraft.func_228018_at_().func_198105_m() / 2.0f), (double)((float)this.minecraft.func_228018_at_().func_198083_n() / 2.0f));
                    this.onClose();
                }
                return true;
            }
        }
        return super.keyPressed(key, scancode, modifiers);
    }

    @Override
    public boolean func_223281_a_(int key, int scancode, int modifiers) {
        if (this.editActions && this.getMenuKeyBinding().func_197976_a(key, scancode)) {
            return false;
        }
        return super.func_223281_a_(key, scancode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.editActions && mouseButton == 0 && this.getSelectedElement() >= 0) {
            if (this.elements.get(this.getSelectedElement()) != fakeAction) {
                SELECTEDACTION = (IAction)this.elements.get(this.getSelectedElement());
            } else {
                this.onClose();
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        super.mouseReleased(mouseX, mouseY, mouseButton);
        if (this.editActions && SELECTEDACTION != null) {
            if (mouseButton == 0 && this.getSelectedElement() >= 0 && this.elements.get(this.getSelectedElement()) != fakeAction) {
                this.switchActions(SELECTEDACTION, (IAction)this.elements.get(this.getSelectedElement()));
                this.updateElements();
            }
            SELECTEDACTION = null;
        }
        return true;
    }

    @Override
    public void onClose() {
        if (this.editActions) {
            SelectActionScreen.saveActionOrder();
            SELECTEDACTION = null;
        }
        super.onClose();
    }

    @Override
    protected void afterIconDraw(IAction p, int x, int y) {
        if (p == fakeAction || this.editActions) {
            return;
        }
        float active = this.actionHandler.getPercentageForAction(p);
        if (active > 0.0f) {
            float h = active * 16.0f;
            this.fillGradient(x, (int)((float)y + h), x + 16, y + 16, Color.YELLOW.getRGB() - -2013265920, Color.YELLOW.getRGB());
        } else if (active < 0.0f) {
            float h = (1.0f + active) * 16.0f;
            this.fillGradient(x, (int)((float)y + h), x + 16, y + 16, Color.BLACK.getRGB() - 0x55000000, Color.BLACK.getRGB());
        }
    }

    @Override
    @Nonnull
    protected Color getColor(IAction s) {
        if (s == fakeAction) {
            return super.getColor(s);
        }
        if (this.editActions) {
            if (SELECTEDACTION != null && (s == SELECTEDACTION || this.getSelectedElement() >= 0 && this.elements.get(this.getSelectedElement()) == s)) {
                return Color.GREEN;
            }
            return Color.WHITE;
        }
        if (!this.minecraft.field_71439_g.func_70089_S()) {
            return Color.RED;
        }
        IFactionPlayer factionPlayer = FactionPlayerHandler.get((PlayerEntity)this.minecraft.field_71439_g).getCurrentFactionPlayer().orElse(null);
        if (s.canUse(factionPlayer) != IAction.PERM.ALLOWED || this.actionHandler.getPercentageForAction(s) < 0.0f) {
            return Color.RED;
        }
        if (this.actionHandler.getPercentageForAction(s) > 0.0f) {
            return Color.YELLOW;
        }
        return super.getColor(s);
    }

    @Override
    protected ResourceLocation getIconLoc(IAction item) {
        if (item == fakeAction) {
            return new ResourceLocation("vampirism", "textures/actions/cancel.png");
        }
        return new ResourceLocation(item.getRegistryName().func_110624_b(), "textures/actions/" + item.getRegistryName().func_110623_a() + ".png");
    }

    @Override
    protected KeyBinding getMenuKeyBinding() {
        return ModKeys.getKeyBinding(ModKeys.KEY.ACTION);
    }

    @Override
    protected String getUnlocalizedName(IAction item) {
        return item.getTranslationKey();
    }

    @Override
    protected void onElementSelected(IAction action) {
        if (action != fakeAction && action.canUse(FactionPlayerHandler.get((PlayerEntity)this.minecraft.field_71439_g).getCurrentFactionPlayer().orElse(null)) == IAction.PERM.ALLOWED) {
            VampirismMod.dispatcher.sendToServer(new InputEventPacket("ta", "" + action.getRegistryName().toString()));
        }
    }

    @Override
    protected void onGuiInit() {
        IFactionPlayer player = FactionPlayerHandler.get((PlayerEntity)this.minecraft.field_71439_g).getCurrentFactionPlayer().orElse(null);
        this.actionHandler = player.getActionHandler();
        this.updateElements();
    }

    private ImmutableList<IAction> getActionOrdered(List<IAction> toSort) {
        ArrayList ordered = Lists.newArrayList();
        if (ACTIONORDER.isEmpty()) {
            ACTIONORDER.addAll(ModRegistries.ACTIONS.getValues());
        }
        for (IAction a : ACTIONORDER) {
            if (!toSort.contains(a)) continue;
            ordered.add(a);
            toSort.remove(a);
        }
        ordered.addAll(toSort);
        return ImmutableList.copyOf((Collection)ordered);
    }

    private void switchActions(IAction first, IAction second) {
        if (first == second) {
            return;
        }
        int a = ACTIONORDER.indexOf(first);
        int b = ACTIONORDER.indexOf(second);
        ACTIONORDER.set(a, second);
        ACTIONORDER.set(b, first);
    }

    private void updateElements() {
        this.elements.clear();
        this.elements.addAll(this.getActionOrdered(Lists.newArrayList(this.actionHandler.getUnlockedActions())));
        this.elements.add(fakeAction);
    }

    static {
        fakeAction = new DefaultVampireAction(){

            @Override
            public boolean activate(IVampirePlayer vampire) {
                return true;
            }

            @Override
            public int getCooldown() {
                return 0;
            }

            @Override
            public String getTranslationKey() {
                return "action.vampirism.cancel";
            }

            @Override
            public boolean isEnabled() {
                return true;
            }
        };
    }
}

