/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.lib.lib.client.gui.ExtendedGui;
import de.teamlapen.lib.lib.util.FluidLib;
import de.teamlapen.vampirism.api.entity.IBiteableEntity;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.vampire.IBloodStats;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.block.BlockState;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class VampirismHUDOverlay
extends ExtendedGui {
    private final Minecraft mc;
    private final ResourceLocation icons = new ResourceLocation("vampirism:textures/gui/icons.png");
    private int screenColor = 0;
    private int screenPercentage = 0;
    private boolean fullScreen = false;
    private int renderFullTick = 0;
    private int rederFullOn;
    private int renderFullOff;
    private int renderFullColor;
    private int screenBottomColor = 0;
    private int screenBottomPercentage = 0;
    private boolean addTempPoison;
    private EffectInstance addedTempPoison;

    public VampirismHUDOverlay(Minecraft mc) {
        this.mc = mc;
    }

    public void makeRenderFullColor(int on, int off, int color) {
        this.rederFullOn = on;
        this.renderFullOff = off;
        this.renderFullTick = on + off;
        if ((color >> 24 & 0xFF) == 0) {
            color |= 0xFF000000;
        }
        this.renderFullColor = color;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.field_71439_g == null || !this.mc.field_71439_g.func_70089_S()) {
            this.renderFullTick = 0;
            this.screenPercentage = 0;
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        IFactionPlayer player = FactionPlayerHandler.get((PlayerEntity)this.mc.field_71439_g).getCurrentFactionPlayer().orElse(null);
        if (player instanceof VampirePlayer) {
            this.handleScreenColorVampire((VampirePlayer)player);
        } else if (player instanceof HunterPlayer) {
            this.handleScreenColorHunter((HunterPlayer)player);
        } else {
            this.screenPercentage = 0;
            this.screenBottomPercentage = 0;
        }
        if (this.renderFullTick > 0) {
            this.screenColor = this.renderFullColor;
            this.fullScreen = true;
            this.screenPercentage = this.renderFullTick > this.renderFullOff ? (int)(100.0f * (1.0f - (float)(this.renderFullTick - this.renderFullOff) / (float)this.rederFullOn)) : (int)((float)(100 * this.renderFullTick) / (float)this.renderFullOff);
            --this.renderFullTick;
        }
    }

    @SubscribeEvent
    public void onRenderCrosshair(RenderGameOverlayEvent.Pre event) {
        float progress;
        TileEntity tile;
        VampirePlayer player;
        BlockState block;
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS || this.mc.field_71439_g == null || !this.mc.field_71439_g.func_70089_S()) {
            return;
        }
        RayTraceResult p = Minecraft.func_71410_x().field_71476_x;
        if (p != null && p.func_216346_c() == RayTraceResult.Type.ENTITY) {
            VampirePlayer player2 = VampirePlayer.get((PlayerEntity)this.mc.field_71439_g);
            if (player2.getLevel() > 0 && !this.mc.field_71439_g.func_175149_v() && !player2.getActionHandler().isActionActive(VampireActions.bat)) {
                Entity entity = ((EntityRayTraceResult)p).func_216348_a();
                Object biteableOpt = LazyOptional.empty();
                if (entity instanceof IBiteableEntity) {
                    biteableOpt = LazyOptional.of(() -> (IBiteableEntity)entity);
                } else if (entity instanceof CreatureEntity && entity.func_70089_S()) {
                    biteableOpt = ExtendedCreature.getSafe(entity);
                } else if (entity instanceof PlayerEntity) {
                    biteableOpt = VampirePlayer.getOpt((PlayerEntity)entity);
                }
                biteableOpt.filter(iBiteableEntity -> iBiteableEntity.canBeBitten(player2)).ifPresent(biteable -> {
                    int color = 0xFF0000;
                    if (entity instanceof HunterBaseEntity || ((Boolean)ExtendedCreature.getSafe(entity).map(IExtendedCreatureVampirism::hasPoisonousBlood).orElse((Object)false)).booleanValue()) {
                        color = 626722;
                    }
                    this.renderBloodFangs(this.mc.func_228018_at_().func_198107_o(), this.mc.func_228018_at_().func_198087_p(), MathHelper.func_76131_a((float)biteable.getBloodLevelRelative(), (float)0.2f, (float)1.0f), color);
                    event.setCanceled(true);
                });
            }
        } else if (p != null && p.func_216346_c() == RayTraceResult.Type.BLOCK && ((Object)((Object)ModBlocks.blood_container)).equals((block = Minecraft.func_71410_x().field_71441_e.func_180495_p(((BlockRayTraceResult)p).func_216350_a())).func_177230_c()) && (player = VampirePlayer.get((PlayerEntity)this.mc.field_71439_g)).wantsBlood() && (tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(((BlockRayTraceResult)p).func_216350_a())) != null) {
            tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(handler -> {
                if (FluidLib.getFluidAmount(handler, ModFluids.blood) > 0) {
                    this.renderBloodFangs(this.mc.func_228018_at_().func_198107_o(), this.mc.func_228018_at_().func_198087_p(), 1.0f, 0xFF0000);
                    event.setCanceled(true);
                }
            });
        }
        GameSettings gamesettings = this.mc.field_71474_y;
        if (gamesettings.field_74320_O == 0 && this.mc.field_71442_b.func_178889_l() != GameType.SPECTATOR && (progress = ((Float)VampirePlayer.getOpt((PlayerEntity)this.mc.field_71439_g).map(VampirePlayer::getFeedProgress).orElse((Object)Float.valueOf(0.0f))).floatValue()) > 0.0f) {
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            if (progress <= 1.0f) {
                int x = this.mc.func_228018_at_().func_198107_o() / 2 - 8;
                int y = this.mc.func_228018_at_().func_198087_p() / 2 - 7 + 16;
                this.mc.func_110434_K().func_110577_a(this.icons);
                int l = (int)(progress * 14.0f) + 2;
                this.blit(x, y, 0, 19, 16, 2);
                this.blit(x, y, 16, 19, l, 2);
            }
        }
    }

    @SubscribeEvent
    public void onRenderExperienceBar(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE || this.mc.field_71439_g == null || !this.mc.field_71439_g.func_70089_S()) {
            return;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        IPlayableFaction<? extends IFactionPlayer> faction = FactionPlayerHandler.get((PlayerEntity)this.mc.field_71439_g).getCurrentFaction();
        if (this.mc.field_71442_b.func_78763_f() && faction != null && faction.renderLevel()) {
            int color = faction.getColor().getRGB();
            String text = "" + FactionPlayerHandler.get((PlayerEntity)this.mc.field_71439_g).getCurrentLevel();
            int x = (this.mc.func_228018_at_().func_198107_o() - this.mc.field_71466_p.func_78256_a(text)) / 2 + (Integer)VampirismConfig.CLIENT.guiLevelOffsetX.get();
            int y = this.mc.func_228018_at_().func_198087_p() - (Integer)VampirismConfig.CLIENT.guiLevelOffsetY.get();
            this.mc.field_71466_p.func_211126_b(text, (float)(x + 1), (float)y, 0);
            this.mc.field_71466_p.func_211126_b(text, (float)(x - 1), (float)y, 0);
            this.mc.field_71466_p.func_211126_b(text, (float)x, (float)(y + 1), 0);
            this.mc.field_71466_p.func_211126_b(text, (float)x, (float)(y - 1), 0);
            this.mc.field_71466_p.func_211126_b(text, (float)x, (float)y, color);
        }
    }

    @SubscribeEvent
    public void onRenderHealthBarPost(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HEALTH) {
            return;
        }
        if (this.addTempPoison) {
            this.mc.field_71439_g.field_70713_bf.remove(Effects.field_76436_u);
        }
    }

    @SubscribeEvent
    public void onRenderHealthBarPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HEALTH) {
            return;
        }
        boolean bl = this.addTempPoison = this.mc.field_71439_g.func_70644_a(ModEffects.poison) && !this.mc.field_71439_g.field_70713_bf.containsKey(Effects.field_76436_u);
        if (this.addTempPoison) {
            if (this.addedTempPoison == null) {
                this.addedTempPoison = new EffectInstance(Effects.field_76436_u, 100);
            }
            this.mc.field_71439_g.field_70713_bf.put(Effects.field_76436_u, this.addedTempPoison);
        }
    }

    @SubscribeEvent
    public void onRenderFoodBar(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.FOOD) {
            return;
        }
        if (Helper.isVampire((PlayerEntity)this.mc.field_71439_g)) {
            event.setCanceled(true);
            if (this.mc.field_71442_b.func_78763_f()) {
                IBloodStats stats = VampirePlayer.get((PlayerEntity)this.mc.field_71439_g).getBloodStats();
                GlStateManager.func_227740_m_();
                this.mc.func_110434_K().func_110577_a(this.icons);
                int left = this.mc.func_228018_at_().func_198107_o() / 2 + 91;
                int top = this.mc.func_228018_at_().func_198087_p() - ForgeIngameGui.right_height;
                ForgeIngameGui.right_height += 10;
                int blood = stats.getBloodLevel();
                int maxBlood = stats.getMaxBlood();
                int blood2 = blood - 20;
                int maxBlood2 = maxBlood - 20;
                for (int i = 0; i < 10; ++i) {
                    int idx = i * 2 + 1;
                    int x = left - i * 8 - 9;
                    this.blit(x, top, 0, idx <= maxBlood2 ? 9 : 0, 9, 9);
                    if (idx < blood) {
                        this.blit(x, top, 9, idx < blood2 ? 9 : 0, 9, 9);
                        if (idx != blood2) continue;
                        this.blit(x, top, 18, 9, 9, 9);
                        continue;
                    }
                    if (idx != blood) continue;
                    this.blit(x, top, 18, 0, 9, 9);
                }
                this.mc.func_110434_K().func_110577_a(AbstractGui.GUI_ICONS_LOCATION);
                GlStateManager.func_227737_l_();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if ((this.screenPercentage > 0 || this.screenBottomPercentage > 0) && ((Boolean)VampirismConfig.CLIENT.renderScreenOverlay.get()).booleanValue()) {
            GlStateManager.func_227658_a_((int)256, (boolean)Minecraft.field_142025_a);
            GlStateManager.func_227768_x_((int)5889);
            GlStateManager.func_227625_M_();
            GlStateManager.func_227633_a_((double)0.0, (double)this.mc.func_228018_at_().func_198107_o(), (double)this.mc.func_228018_at_().func_198087_p(), (double)0.0, (double)1.0, (double)-1.0);
            GlStateManager.func_227768_x_((int)5888);
            GlStateManager.func_227625_M_();
            GlStateManager.func_227626_N_();
            GL11.glDisable((int)2929);
            int w = this.mc.func_228018_at_().func_198107_o();
            int h = this.mc.func_228018_at_().func_198087_p();
            if (this.fullScreen) {
                float r = (float)(this.screenColor >> 16 & 0xFF) / 255.0f;
                float g = (float)(this.screenColor >> 8 & 0xFF) / 255.0f;
                float b = (float)(this.screenColor & 0xFF) / 255.0f;
                float a = (float)this.screenPercentage / 100.0f * (float)(this.screenColor >> 24 & 0xFF) / 255.0f;
                GlStateManager.func_227621_I_();
                GlStateManager.func_227740_m_();
                GlStateManager.func_227700_d_();
                GlStateManager.func_227644_a_((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_227762_u_((int)7425);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder worldrenderer = tessellator.func_178180_c();
                worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                worldrenderer.func_225582_a_(0.0, (double)h, (double)this.getBlitOffset()).func_227885_a_(r, g, b, a).func_181675_d();
                worldrenderer.func_225582_a_((double)w, (double)h, (double)this.getBlitOffset()).func_227885_a_(r, g, b, a).func_181675_d();
                worldrenderer.func_225582_a_((double)w, 0.0, (double)this.getBlitOffset()).func_227885_a_(r, g, b, a).func_181675_d();
                worldrenderer.func_225582_a_(0.0, 0.0, (double)this.getBlitOffset()).func_227885_a_(r, g, b, a).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_227762_u_((int)7424);
                GlStateManager.func_227737_l_();
                GlStateManager.func_227709_e_();
                GlStateManager.func_227619_H_();
            } else if (this.screenPercentage > 0) {
                int bw = 0;
                int bh = 0;
                bh = Math.round((float)h / 4.0f * (float)this.screenPercentage / 100.0f);
                bw = Math.round((float)w / 8.0f * (float)this.screenPercentage / 100.0f);
                this.fillGradient(0, 0, w, bh, this.screenColor, 0);
                this.fillGradient(0, h - bh, w, h, 0, this.screenColor);
                this.fillGradient2(0, 0, bw, h, 0, this.screenColor);
                this.fillGradient2(w - bw, 0, w, h, this.screenColor, 0);
            } else {
                int hh = 0;
                hh = Math.round((float)h / 4.0f * (float)this.screenBottomPercentage / 100.0f);
                this.fillGradient(0, h - hh, w, h, 0, this.screenBottomColor);
            }
            GL11.glEnable((int)2929);
            GlStateManager.func_227627_O_();
        }
    }

    private void handleScreenColorHunter(HunterPlayer hunter) {
        if (hunter.getSpecialAttributes().isDisguised()) {
            this.screenPercentage = (int)(100.0f * hunter.getSpecialAttributes().getDisguiseProgress());
            this.screenColor = -15658735;
            this.fullScreen = false;
        } else if (hunter.getSpecialAttributes().isVampireNearby()) {
            this.screenPercentage = (int)(100.0f * hunter.getSpecialAttributes().getVampireNearbyProgress());
            this.screenColor = -2135287754;
            this.fullScreen = false;
        } else {
            this.screenPercentage = (int)Math.max(0.0f, (float)this.screenPercentage / 20.0f * 19.0f);
        }
    }

    private void handleScreenColorVampire(VampirePlayer vampire) {
        if (vampire.getActionHandler().isActionActive(VampireActions.vampire_rage)) {
            this.screenPercentage = 100;
            this.screenColor = -1048576;
            this.fullScreen = false;
        } else {
            this.screenPercentage = vampire.getTicksInSun() / 2;
            if (this.screenPercentage > 0) {
                EffectInstance effect = this.mc.field_71439_g.func_70660_b(ModEffects.sunscreen);
                if (effect == null || effect.func_76458_c() < 5) {
                    this.screenColor = -2219;
                    this.fullScreen = false;
                    if (vampire.getRepresentingPlayer().field_71075_bZ.field_75098_d || effect != null && effect.func_76458_c() >= 4) {
                        this.screenPercentage = Math.min(20, this.screenPercentage);
                    }
                } else {
                    this.screenPercentage = 0;
                }
            } else {
                this.screenPercentage = 0;
            }
        }
        if (vampire.getActionHandler().isActionActive(VampireActions.bat)) {
            float batPercentage = vampire.getActionHandler().getPercentageForAction(VampireActions.bat);
            if (batPercentage < 0.2f && batPercentage > 0.0f) {
                this.screenBottomColor = -865048583;
                this.screenBottomPercentage = (int)((0.2f - batPercentage) * 1000.0f);
                this.fullScreen = false;
            } else {
                this.screenBottomPercentage = 0;
            }
        } else {
            this.screenBottomPercentage = 0;
        }
    }

    private void renderBloodFangs(int width, int height, float perc, int color) {
        float r = (float)((color & 0xFF0000) >> 16) / 256.0f;
        float g = (float)((color & 0xFF00) >> 8) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        this.mc.func_110434_K().func_110577_a(this.icons);
        int left = width / 2 - 8;
        int top = height / 2 - 4;
        GL11.glEnable((int)3042);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
        this.blit(left, top, 27, 0, 16, 10);
        GlStateManager.func_227702_d_((float)r, (float)g, (float)b, (float)0.8f);
        int percHeight = (int)(10.0f * perc);
        this.blit(left, top + (10 - percHeight), 27, 10 - percHeight, 16, percHeight);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }
}

