/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.teamlapen.vampirism.client.render.tiles.VampirismTESR;
import de.teamlapen.vampirism.tileentity.AltarInfusionTileEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AltarInfusionTESR
extends VampirismTESR<AltarInfusionTileEntity> {
    private final ResourceLocation enderDragonCrystalBeamTextures = new ResourceLocation("vampirism", "textures/entity/infusion_beam.png");
    private final ResourceLocation beaconBeamTexture = new ResourceLocation("textures/entity/beacon_beam.png");

    public AltarInfusionTESR(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(AltarInfusionTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int combinedLight, int combinedOverlay) {
        AltarInfusionTileEntity.PHASE phase = te.getCurrentPhase();
        if (phase == AltarInfusionTileEntity.PHASE.BEAM1 || phase == AltarInfusionTileEntity.PHASE.BEAM2) {
            PlayerEntity p;
            BlockPos[] tips;
            float cX = (float)te.func_174877_v().func_177958_n() + 0.5f;
            float cY = (float)te.func_174877_v().func_177956_o() + 3.0f;
            float cZ = (float)te.func_174877_v().func_177952_p() + 0.5f;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 3.0, 0.5);
            for (BlockPos tip : tips = te.getTips()) {
                this.renderBeam(matrixStack, iRenderTypeBuffer, -((float)te.getRunningTick() + partialTicks), (float)tip.func_177958_n() + 0.5f - cX, (float)tip.func_177956_o() + 0.5f - cY, (float)tip.func_177952_p() + 0.5f - cZ, combinedLight, true);
            }
            if (phase == AltarInfusionTileEntity.PHASE.BEAM2 && (p = te.getPlayer()) != null) {
                this.renderBeam(matrixStack, iRenderTypeBuffer, -((float)te.getRunningTick() + partialTicks), (float)p.func_226277_ct_() - cX, (float)p.func_226278_cu_() + 1.2f - cY, (float)p.func_226281_cx_() - cZ, combinedLight, false);
            }
            matrixStack.func_227865_b_();
        }
    }

    private void renderBeam(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, float partialTicks, float dx, float dy, float dz, int packedLight, boolean beacon) {
        float distFlat = MathHelper.func_76129_c((float)(dx * dx + dz * dz));
        float dist = MathHelper.func_76129_c((float)(dx * dx + dy * dy + dz * dz));
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(-Math.atan2(dz, dx)) - 1.5707964f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_((float)(-Math.atan2(distFlat, dy)) - 1.5707964f));
        IVertexBuilder ivertexbuilder = renderTypeBuffer.getBuffer(RenderType.func_228646_f_((ResourceLocation)(beacon ? this.beaconBeamTexture : this.enderDragonCrystalBeamTextures)));
        float f2 = partialTicks * 0.05f;
        float f3 = dist / 32.0f + partialTicks * 0.05f;
        float f4 = 0.0f;
        float f5 = 0.2f;
        float f6 = 0.0f;
        MatrixStack.Entry matrixstack$entry = matrixStack.func_227866_c_();
        Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
        Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
        for (int j = 1; j <= 8; ++j) {
            float f7 = MathHelper.func_76126_a((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.2f;
            float f8 = MathHelper.func_76134_b((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.2f;
            float f9 = (float)j / 8.0f;
            ivertexbuilder.func_227888_a_(matrix4f, f4 * 1.0f, f5 * 1.0f, 0.0f).func_225586_a_(75, 0, 0, 255).func_225583_a_(f6, f2).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(matrix3f, 0.0f, -1.0f, 0.0f).func_181675_d();
            ivertexbuilder.func_227888_a_(matrix4f, f4 * 0.5f, f5 * 0.5f, dist).func_225586_a_(255, 0, 0, 255).func_225583_a_(f6, f3).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(matrix3f, 0.0f, -1.0f, 0.0f).func_181675_d();
            ivertexbuilder.func_227888_a_(matrix4f, f7 * 0.5f, f8 * 0.5f, dist).func_225586_a_(255, 0, 0, 255).func_225583_a_(f9, f3).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(matrix3f, 0.0f, -1.0f, 0.0f).func_181675_d();
            ivertexbuilder.func_227888_a_(matrix4f, f7 * 1.0f, f8 * 1.0f, 0.0f).func_225586_a_(75, 0, 0, 255).func_225583_a_(f9, f2).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(matrix3f, 0.0f, -1.0f, 0.0f).func_181675_d();
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        matrixStack.func_227865_b_();
    }
}

