/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.world.IFactionBiome;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModFeatures;
import de.teamlapen.vampirism.world.gen.biome.VampireForestBiome;
import de.teamlapen.vampirism.world.gen.features.VampirismBiomeFeatures;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="vampirism")
public class ModBiomes {
    public static final VampireForestBiome vampire_forest = (VampireForestBiome)UtilLib.getNull();

    static void registerBiomes(IForgeRegistry<Biome> registry) {
        registry.register((IForgeRegistryEntry)new VampireForestBiome());
    }

    static void addBiome() {
        BiomeDictionary.addTypes((Biome)vampire_forest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.SPOOKY});
        if (!((Boolean)VampirismConfig.SERVER.disableVampireForest.get()).booleanValue()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)vampire_forest, ((Integer)VampirismConfig.BALANCE.vampireForestWeight.get()).intValue()));
        }
    }

    static void addFeatures() {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            VampirismBiomeFeatures.addVampireDungeon(biome);
            if (!VampirismAPI.worldGenRegistry().canStructureBeGeneratedInBiome(ModFeatures.hunter_camp.getRegistryName(), biome) || biome instanceof IFactionBiome && !VReference.HUNTER_FACTION.equals(((IFactionBiome)biome).getFaction())) continue;
            VampirismBiomeFeatures.addHunterTent(biome);
        }
    }
}

