/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.blocks.AltarPillarBlock;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.blocks.GarlicBlock;
import de.teamlapen.vampirism.blocks.MedChairBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModLootTables;
import de.teamlapen.vampirism.world.loot.AddBookNbt;
import de.teamlapen.vampirism.world.loot.AdjustableLevelCondition;
import de.teamlapen.vampirism.world.loot.SetItemBloodCharge;
import de.teamlapen.vampirism.world.loot.StakeCondition;
import de.teamlapen.vampirism.world.loot.TentSpawnerCondition;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.EmptyLootEntry;
import net.minecraft.world.storage.loot.ILootFunctionConsumer;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.ValidationTracker;
import net.minecraft.world.storage.loot.conditions.BlockStateProperty;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.KilledByPlayer;
import net.minecraft.world.storage.loot.conditions.RandomChanceWithLooting;
import net.minecraft.world.storage.loot.conditions.SurvivesExplosion;
import net.minecraft.world.storage.loot.functions.ApplyBonus;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootingEnchantBonus;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetNBT;

public class LootTablesGenerator
extends LootTableProvider {
    public LootTablesGenerator(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    @Nonnull
    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new ModEntityLootTables(), (Object)LootParameterSets.field_216263_d), (Object)Pair.of(() -> new ModChestLootTables(), (Object)LootParameterSets.field_216261_b), (Object)Pair.of(() -> new ModBlockLootTables(), (Object)LootParameterSets.field_216267_h), (Object)Pair.of(() -> new InjectLootTables(), (Object)LootParameterSets.field_216261_b));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        for (ResourceLocation resourcelocation : Sets.difference(ModLootTables.getLootTables(), map.keySet())) {
            validationtracker.func_227530_a_("Missing built-in table: " + resourcelocation);
        }
        map.forEach((resourceLocation, lootTable) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)resourceLocation, (LootTable)lootTable));
    }

    private static class InjectLootTables
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
        private InjectLootTables() {
        }

        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(ModLootTables.abandoned_mineshaft, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)4.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.vampire_fang).func_216086_a(35)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.blood_bottle).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)1.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.vampire_book).func_216086_a(5).func_212841_b_(AddBookNbt.builder())).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(40))).func_216040_a(LootPool.func_216096_a().name("swiftness_armor").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.armor_of_swiftness_head_ultimate).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.armor_of_swiftness_chest_ultimate).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.armor_of_swiftness_legs_ultimate).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.armor_of_swiftness_feet_ultimate).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(88))).func_216040_a(LootPool.func_216096_a().name("hunter_weapons").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.hunter_axe_ultimate).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(95))).func_216040_a(LootPool.func_216096_a().name("vampire_weapons").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.heart_seeker_enhanced).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.heart_striker_enhanced).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(60))).func_216040_a(LootPool.func_216096_a().name("holy_Water").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.holy_salt).func_216086_a(50)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.holy_water_bottle_normal).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.holy_water_bottle_enhanced).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.holy_water_bottle_ultimate).func_216086_a(10))));
            consumer.accept(ModLootTables.desert_pyramid, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.blood_bottle).func_216086_a(25).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.6f, (float)0.6f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.vampire_book).func_216086_a(8).func_212841_b_(AddBookNbt.builder())).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(60))).func_216040_a(LootPool.func_216096_a().name("obsidian_armor").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.obsidian_armor_head_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.obsidian_armor_chest_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.obsidian_armor_legs_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.obsidian_armor_feet_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(72))));
            consumer.accept(ModLootTables.jungle_temple, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.blood_bottle).func_216086_a(30).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)1.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.vampire_book).func_216086_a(20).func_212841_b_(AddBookNbt.builder())).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.vampire_fang).func_216086_a(30)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(30))).func_216040_a(LootPool.func_216096_a().name("swiftness_armor").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.armor_of_swiftness_head_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.armor_of_swiftness_chest_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.armor_of_swiftness_legs_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.armor_of_swiftness_feet_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(72))).func_216040_a(LootPool.func_216096_a().name("hunter_coat").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.hunter_coat_head_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.hunter_coat_chest_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.hunter_coat_legs_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.hunter_coat_feet_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(72))));
            consumer.accept(ModLootTables.stronghold_corridor, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.vampire_book).func_216086_a(20).func_212841_b_(AddBookNbt.builder())).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(77))).func_216040_a(LootPool.func_216096_a().name("swiftness_armor").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.armor_of_swiftness_head_ultimate).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.armor_of_swiftness_chest_ultimate).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.armor_of_swiftness_legs_ultimate).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.armor_of_swiftness_feet_ultimate).func_216086_a(5).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(80))).func_216040_a(LootPool.func_216096_a().name("obsidian_armor").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.obsidian_armor_head_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.obsidian_armor_chest_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.obsidian_armor_legs_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.obsidian_armor_feet_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(72))).func_216040_a(LootPool.func_216096_a().name("vampire_weapons").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.heart_seeker_enhanced).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.heart_striker_enhanced).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(80))));
            consumer.accept(ModLootTables.stronghold_library, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.vampire_book).func_216086_a(1).func_212841_b_(AddBookNbt.builder()))));
        }
    }

    private static class ModBlockLootTables
    extends BlockLootTables {
        private ModBlockLootTables() {
        }

        protected void addTables() {
            this.func_218492_c((Block)ModBlocks.alchemical_cauldron);
            this.func_218492_c((Block)ModBlocks.altar_infusion);
            this.func_218492_c((Block)ModBlocks.altar_inspiration);
            this.func_218507_a(ModBlocks.altar_pillar, ModBlockLootTables.func_218546_a((IItemProvider)ModBlocks.altar_pillar).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(SurvivesExplosion.func_215968_b()).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221723_cX).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)ModBlocks.altar_pillar).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227194_a_(AltarPillarBlock.TYPE_PROPERTY, "stone")))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221698_bk).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)ModBlocks.altar_pillar).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227194_a_(AltarPillarBlock.TYPE_PROPERTY, "iron")))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221696_bj).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)ModBlocks.altar_pillar).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227194_a_(AltarPillarBlock.TYPE_PROPERTY, "gold")))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_221964_gn).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)ModBlocks.altar_pillar).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227194_a_(AltarPillarBlock.TYPE_PROPERTY, "bone"))))));
            this.func_218492_c(ModBlocks.altar_tip);
            this.func_218522_a((Block)ModBlocks.coffin, block -> ModBlockLootTables.func_218562_a((Block)block, CoffinBlock.PART, (Comparable)((Object)CoffinBlock.CoffinPart.HEAD)));
            this.func_218492_c((Block)ModBlocks.blood_container);
            this.func_218492_c((Block)ModBlocks.blood_grinder);
            this.func_218492_c((Block)ModBlocks.blood_pedestal);
            this.func_218492_c(ModBlocks.blood_potion_table);
            this.func_218492_c((Block)ModBlocks.blood_sieve);
            this.func_218492_c(ModBlocks.castle_block_dark_brick);
            this.func_218492_c(ModBlocks.castle_block_dark_brick_bloody);
            this.func_218492_c(ModBlocks.castle_block_dark_stone);
            this.func_218492_c(ModBlocks.castle_block_normal_brick);
            this.func_218492_c(ModBlocks.castle_block_purple_brick);
            this.func_218492_c((Block)ModBlocks.castle_slab_dark_brick);
            this.func_218492_c((Block)ModBlocks.castle_slab_dark_stone);
            this.func_218492_c((Block)ModBlocks.castle_slab_purple_brick);
            this.func_218492_c((Block)ModBlocks.castle_stairs_dark_brick);
            this.func_218492_c((Block)ModBlocks.castle_stairs_dark_stone);
            this.func_218492_c((Block)ModBlocks.castle_stairs_purple_brick);
            this.func_218492_c((Block)ModBlocks.church_altar);
            this.func_218492_c(ModBlocks.cursed_earth);
            this.func_218492_c(ModBlocks.fire_place);
            this.func_218507_a((Block)ModBlocks.garlic, (LootTable.Builder)ModBlockLootTables.func_218552_a((IItemProvider)ModBlocks.garlic, (ILootFunctionConsumer)LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.item_garlic))).func_216040_a(LootPool.func_216096_a().func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)ModBlocks.garlic).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((IProperty)GarlicBlock.field_176488_a, 7))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.item_garlic).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)3))))));
            this.func_218492_c((Block)ModBlocks.garlic_beacon_weak);
            this.func_218492_c((Block)ModBlocks.garlic_beacon_normal);
            this.func_218492_c((Block)ModBlocks.garlic_beacon_improved);
            this.func_218492_c(ModBlocks.hunter_table);
            this.func_218522_a(ModBlocks.med_chair, block -> ModBlockLootTables.func_218562_a((Block)block, MedChairBlock.PART, (Comparable)((Object)MedChairBlock.EnumPart.TOP)));
            this.func_218492_c((Block)ModBlocks.sunscreen_beacon);
            this.func_218507_a(ModBlocks.tent_main, ModBlockLootTables.func_218546_a((IItemProvider)ModItems.item_tent).func_216040_a(LootPool.func_216096_a().name("bonus").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(TentSpawnerCondition.builder()).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151034_e)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151025_P)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151044_h)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Blocks.field_196662_n))));
            this.func_218492_c(ModBlocks.totem_base);
            this.func_218492_c((Block)ModBlocks.totem_top);
            this.func_218507_a((Block)ModBlocks.totem_top_vampirism_hunter, ModBlockLootTables.func_218546_a((IItemProvider)ModBlocks.totem_top));
            this.func_218507_a((Block)ModBlocks.totem_top_vampirism_vampire, ModBlockLootTables.func_218546_a((IItemProvider)ModBlocks.totem_top));
            this.func_218492_c((Block)ModBlocks.vampire_orchid);
            this.func_218492_c(ModBlocks.weapon_table);
            this.func_218507_a(ModBlocks.tent, ModBlockLootTables.func_218482_a());
            this.func_218547_a((Block)ModBlocks.potted_vampire_orchid);
        }

        @Nonnull
        protected Iterable<Block> getKnownBlocks() {
            return ModBlocks.getAllBlocks();
        }
    }

    private static class ModChestLootTables
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
        private ModChestLootTables() {
        }

        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(ModLootTables.chest_hunter_trainer, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)5.0f, (float)9.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151042_j).func_216086_a(40)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.vampire_blood_bottle).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.item_garlic).func_216086_a(40))).func_216040_a(LootPool.func_216096_a().name("book").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.vampire_book).func_216086_a(50).func_212841_b_(AddBookNbt.builder())).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(95))).func_216040_a(LootPool.func_216096_a().name("hunter_weapons").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.hunter_axe_ultimate).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(95))).func_216040_a(LootPool.func_216096_a().name("swiftness_armor").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.armor_of_swiftness_head_ultimate).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.armor_of_swiftness_chest_ultimate).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.armor_of_swiftness_legs_ultimate).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.armor_of_swiftness_feet_ultimate).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(60))).func_216040_a(LootPool.func_216096_a().name("hunter_coat").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.hunter_coat_head_ultimate).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.hunter_coat_chest_ultimate).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.hunter_coat_legs_ultimate).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.hunter_coat_feet_ultimate).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(60))).func_216040_a(LootPool.func_216096_a().name("obsidian").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.obsidian_armor_head_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.obsidian_armor_chest_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.obsidian_armor_legs_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.obsidian_armor_feet_ultimate).func_216086_a(7).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.3f, (float)0.9f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(72))).func_216040_a(LootPool.func_216096_a().name("holy_water").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.holy_salt).func_216086_a(50)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.holy_water_bottle_normal).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.holy_water_bottle_enhanced).func_216086_a(20)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.holy_water_bottle_ultimate).func_216086_a(10))));
            consumer.accept(ModLootTables.chest_vampire_dungeon, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)7)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.vampire_fang).func_216086_a(35)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.blood_bottle).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)1.0f))))).func_216040_a(LootPool.func_216096_a().name("book").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.vampire_book).func_216086_a(70).func_212841_b_(AddBookNbt.builder())).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(30))).func_216040_a(LootPool.func_216096_a().name("equipment").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.heart_seeker_enhanced).func_216086_a(21).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.6f, (float)0.99f))).func_212841_b_(SetItemBloodCharge.builder((IRandomRange)RandomValueRange.func_215837_a((float)500.0f, (float)2000.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.heart_seeker_ultimate).func_216086_a(9).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.6f, (float)0.99f))).func_212841_b_(SetItemBloodCharge.builder((IRandomRange)RandomValueRange.func_215837_a((float)500.0f, (float)2000.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.heart_striker_enhanced).func_216086_a(21).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.6f, (float)0.99f))).func_212841_b_(SetItemBloodCharge.builder((IRandomRange)RandomValueRange.func_215837_a((float)500.0f, (float)2000.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.heart_striker_ultimate).func_216086_a(9).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.6f, (float)0.99f))).func_212841_b_(SetItemBloodCharge.builder((IRandomRange)RandomValueRange.func_215837_a((float)500.0f, (float)2000.0f)))).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(40))));
        }
    }

    private static class ModEntityLootTables
    extends EntityLootTables {
        private ModEntityLootTables() {
        }

        protected void addTables() {
            CompoundNBT splash = new CompoundNBT();
            splash.func_74757_a("splash", true);
            LootTable.Builder advanced_hunter = LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("general").func_212840_b_(KilledByPlayer.func_215994_b()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.vampire_blood_bottle).func_216086_a(4)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.item_garlic).func_216086_a(4).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.holy_water_bottle_enhanced).func_216086_a(3).func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)splash))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.holy_water_bottle_ultimate).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetNBT.func_215952_a((CompoundNBT)splash))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.holy_salt).func_216086_a(4).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))))).func_216040_a(LootPool.func_216096_a().name("special").func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.05f, (float)0.01f)).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.vampire_book).func_216086_a(1).func_212841_b_(AddBookNbt.builder())));
            this.func_218582_a(ModEntities.advanced_hunter, advanced_hunter);
            this.func_218582_a(ModEntities.advanced_hunter_imob, advanced_hunter);
            LootTable.Builder advanced_vampire = LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("general").func_212840_b_(KilledByPlayer.func_215994_b()).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.vampire_blood_bottle).func_216086_a(1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.blood_bottle).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)SetDamage.func_215931_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.5f, (float)1.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)1.0f, (float)1.0f))))).func_216040_a(LootPool.func_216096_a().name("special").func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.05f, (float)0.01f)).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.vampire_book).func_216086_a(1).func_212841_b_(AddBookNbt.builder())));
            this.func_218582_a(ModEntities.advanced_vampire, advanced_vampire);
            this.func_218582_a(ModEntities.advanced_vampire_imob, advanced_vampire);
            this.func_218582_a(ModEntities.blinding_bat, LootTable.func_216119_b());
            this.func_218582_a(ModEntities.converted_creature, LootTable.func_216119_b());
            this.func_218582_a(ModEntities.converted_creature_imob, LootTable.func_216119_b());
            this.func_218582_a(ModEntities.converted_sheep, LootTable.func_216119_b());
            this.func_218582_a(ModEntities.converted_horse, LootTable.func_216119_b());
            this.func_218582_a(ModEntities.dummy_creature, LootTable.func_216119_b());
            this.func_218582_a(ModEntities.ghost, LootTable.func_216119_b());
            this.func_218582_a(ModEntities.hunter_trainer, LootTable.func_216119_b());
            LootTable.Builder vampire = LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("general").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.33f, (float)0.05f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.vampire_fang).func_216086_a(1))).func_216040_a(LootPool.func_216096_a().name("special").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(StakeCondition.builder(LootContext.EntityTarget.KILLER_PLAYER)).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.5f, (float)0.05f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.vampire_blood_bottle).func_216086_a(1)));
            this.func_218582_a(ModEntities.vampire, vampire);
            this.func_218582_a(ModEntities.vampire_imob, vampire);
            this.func_218582_a(ModEntities.vampire_baron, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("pure_blood_0").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(AdjustableLevelCondition.builder(0, LootContext.EntityTarget.THIS)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.pure_blood_0).func_216086_a(1))).func_216040_a(LootPool.func_216096_a().name("pure_blood_1").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(AdjustableLevelCondition.builder(1, LootContext.EntityTarget.THIS)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.pure_blood_1).func_216086_a(1))).func_216040_a(LootPool.func_216096_a().name("pure_blood_2").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(AdjustableLevelCondition.builder(2, LootContext.EntityTarget.THIS)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.pure_blood_2).func_216086_a(1))).func_216040_a(LootPool.func_216096_a().name("pure_blood_3").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(AdjustableLevelCondition.builder(3, LootContext.EntityTarget.THIS)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.pure_blood_3).func_216086_a(1))).func_216040_a(LootPool.func_216096_a().name("pure_blood_4").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(AdjustableLevelCondition.builder(4, LootContext.EntityTarget.THIS)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.pure_blood_4).func_216086_a(1))));
            LootTable.Builder hunter = LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("general").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.33f, (float)0.005f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.human_heart).func_216086_a(1))).func_216040_a(LootPool.func_216096_a().name("special").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.25f, (float)0.05f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.holy_salt).func_216086_a(1)));
            this.func_218582_a(ModEntities.hunter, hunter);
            this.func_218582_a(ModEntities.hunter_imob, hunter);
            this.func_218582_a(ModEntities.villager_angry, LootTable.func_216119_b());
            this.func_218582_a(ModEntities.villager_converted, LootTable.func_216119_b());
        }

        @Nonnull
        protected Iterable<EntityType<?>> getKnownEntities() {
            return ModEntities.getAllEntities();
        }
    }
}

