/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.recipebuilder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AlchemicalCauldronRecipeBuilder {
    private final ItemStack result;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    private String group;
    private Ingredient ingredient;
    private Either<Ingredient, FluidStack> fluid;
    private ISkill[] skills;
    private int reqLevel = 1;
    private int cookTime = 200;
    private float exp = 0.2f;

    public AlchemicalCauldronRecipeBuilder(Item result, int count) {
        this.result = new ItemStack((IItemProvider)result, count);
    }

    public static AlchemicalCauldronRecipeBuilder cauldronRecipe(Item item) {
        return AlchemicalCauldronRecipeBuilder.cauldronRecipe(item, 1);
    }

    public static AlchemicalCauldronRecipeBuilder cauldronRecipe(Item item, int count) {
        return new AlchemicalCauldronRecipeBuilder(item, count);
    }

    public AlchemicalCauldronRecipeBuilder withIngredient(Tag<Item> tag) {
        this.ingredient = Ingredient.func_199805_a(tag);
        return this;
    }

    public AlchemicalCauldronRecipeBuilder withIngredient(IItemProvider ... items) {
        this.ingredient = Ingredient.func_199804_a((IItemProvider[])items);
        return this;
    }

    public AlchemicalCauldronRecipeBuilder withIngredient(ItemStack ... stacks) {
        this.ingredient = Ingredient.func_193369_a((ItemStack[])stacks);
        return this;
    }

    public AlchemicalCauldronRecipeBuilder withFluid(FluidStack fluid) {
        this.fluid = Either.right((Object)fluid);
        return this;
    }

    public AlchemicalCauldronRecipeBuilder withFluid(IItemProvider ... item) {
        this.fluid = Either.left((Object)Ingredient.func_199804_a((IItemProvider[])item));
        return this;
    }

    public AlchemicalCauldronRecipeBuilder withFluid(Tag<Item> tag) {
        this.fluid = Either.left((Object)Ingredient.func_199805_a(tag));
        return this;
    }

    public AlchemicalCauldronRecipeBuilder withFluid(ItemStack ... stacks) {
        this.fluid = Either.left((Object)Ingredient.func_193369_a((ItemStack[])stacks));
        return this;
    }

    public AlchemicalCauldronRecipeBuilder withSkills(ISkill ... skills) {
        this.skills = skills;
        return this;
    }

    public AlchemicalCauldronRecipeBuilder requireLevel(int level) {
        this.reqLevel = level;
        return this;
    }

    public AlchemicalCauldronRecipeBuilder cookTime(int cookTime) {
        this.cookTime = cookTime;
        return this;
    }

    public AlchemicalCauldronRecipeBuilder experience(float exp) {
        this.exp = exp;
        return this;
    }

    public AlchemicalCauldronRecipeBuilder withCriterion(String name, ICriterionInstance criterion) {
        this.advancementBuilder.func_200275_a(name, criterion);
        return this;
    }

    public AlchemicalCauldronRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    private void validate(ResourceLocation id) {
        if (this.ingredient == null) {
            throw new IllegalStateException("No ingredients defined for alchemical cauldron recipe " + id + "!");
        }
        if (this.fluid == null) {
            throw new IllegalStateException("No fluid defined for alchemical cauldron recipe " + id + "!");
        }
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        ISkill[] iSkillArray;
        id = new ResourceLocation(id.func_110624_b(), "alchemical_cauldron/" + id.func_110623_a());
        this.validate(id);
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)new RecipeUnlockedTrigger.Instance(id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        String string = this.group != null ? this.group : "";
        if (this.skills != null) {
            iSkillArray = this.skills;
        } else {
            ISkill[] iSkillArray2 = new ISkill[1];
            iSkillArray = iSkillArray2;
            iSkillArray2[0] = HunterSkills.basic_alchemy;
        }
        consumer.accept(new Result(id, string, this.ingredient, this.fluid, this.result, iSkillArray, this.reqLevel, this.cookTime, this.exp, this.advancementBuilder, new ResourceLocation(id.func_110624_b(), "recipes/" + this.result.func_77973_b().func_77640_w().func_200300_c() + "/" + id.func_110623_a())));
    }

    public static class Result
    implements IFinishedRecipe {
        private ResourceLocation id;
        private String group;
        private Ingredient ingredient;
        private Either<Ingredient, FluidStack> fluid;
        private ItemStack result;
        private ISkill[] skills;
        private int reqLevel;
        private int cookTimeIn;
        private float exp;
        private Advancement.Builder advancementBuilder;
        private ResourceLocation advancementId;

        public Result(@Nonnull ResourceLocation idIn, @Nonnull String groupIn, @Nonnull Ingredient ingredientIn, @Nonnull Either<Ingredient, FluidStack> fluidIn, @Nonnull ItemStack resultIn, @Nonnull ISkill[] skillsIn, int reqLevelIn, int cookTimeIn, float exp, Advancement.Builder advancementBuilderIn, ResourceLocation advancementId) {
            this.id = idIn;
            this.group = groupIn;
            this.ingredient = ingredientIn;
            this.fluid = fluidIn;
            this.result = resultIn;
            this.skills = skillsIn;
            this.reqLevel = reqLevelIn;
            this.cookTimeIn = cookTimeIn;
            this.exp = exp;
            this.advancementBuilder = advancementBuilderIn;
            this.advancementId = advancementId;
        }

        public void func_218610_a(JsonObject jsonObject) {
            if (!this.group.isEmpty()) {
                jsonObject.addProperty("group", this.group);
            }
            JsonObject result = new JsonObject();
            result.addProperty("item", this.result.func_77973_b().getRegistryName().toString());
            if (this.result.func_190916_E() > 1) {
                result.addProperty("count", (Number)this.result.func_190916_E());
            }
            jsonObject.add("result", (JsonElement)result);
            jsonObject.add("ingredient", this.ingredient.func_200304_c());
            this.fluid.ifLeft(ingredient1 -> jsonObject.add("fluidItem", ingredient1.func_200304_c()));
            this.fluid.ifRight(fluidStack -> {
                JsonObject fluid = new JsonObject();
                fluid.addProperty("fluid", fluidStack.getFluid().getRegistryName().toString());
                jsonObject.add("fluid", (JsonElement)fluid);
            });
            JsonArray skills = new JsonArray();
            for (ISkill skill : this.skills) {
                skills.add(skill.getRegistryName().toString());
            }
            jsonObject.add("skill", (JsonElement)skills);
            jsonObject.addProperty("cookTime", (Number)this.cookTimeIn);
            jsonObject.addProperty("experience", (Number)Float.valueOf(this.exp));
            jsonObject.addProperty("reqLevel", (Number)this.reqLevel);
        }

        @Nonnull
        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return ModRecipes.alchemical_cauldron;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

