/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.entity.ISundamageRegistry;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.util.Helper;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SundamageRegistry
implements ISundamageRegistry {
    private static final Logger LOGGER = LogManager.getLogger(SundamageRegistry.class);
    private HashMap<DimensionType, Boolean> sundamageDims = new HashMap();
    private HashMap<DimensionType, Boolean> sundamageConfiguredDims = new HashMap();
    private Set<ResourceLocation> noSundamageBiomesIDs = new CopyOnWriteArraySet<ResourceLocation>();
    private Set<ResourceLocation> noSundamageConfiguredBiomesIDs = new CopyOnWriteArraySet<ResourceLocation>();
    private Set<Class> noSundamageBiomes = new CopyOnWriteArraySet<Class>();

    public SundamageRegistry() {
        this.sundamageDims.put(DimensionType.field_223227_a_, true);
        this.sundamageDims.put(DimensionType.field_223228_b_, false);
        this.sundamageDims.put(DimensionType.field_223229_c_, false);
    }

    @Override
    public void addNoSundamageBiome(ResourceLocation registryName) {
        this.noSundamageBiomesIDs.add(registryName);
    }

    @Override
    public void addNoSundamageBiome(Class clazz) {
        this.noSundamageBiomes.add(clazz);
    }

    public void addNoSundamageBiomeConfigured(ResourceLocation id) {
        this.noSundamageConfiguredBiomesIDs.add(id);
    }

    @Override
    public void addNoSundamageBiomes(Biome ... biomes) {
        for (Biome b : biomes) {
            this.addNoSundamageBiome(b.getClass());
        }
    }

    @Override
    @Deprecated
    public boolean getSundamageInBiome(ResourceLocation registryName) {
        return !this.noSundamageBiomesIDs.contains(registryName) && !this.noSundamageConfiguredBiomesIDs.contains(registryName);
    }

    @Override
    public boolean getSundamageInBiome(@Nonnull Biome biome) {
        if (!this.getSundamageInBiome(biome.getRegistryName())) {
            return false;
        }
        for (Class clazz : this.noSundamageBiomes) {
            if (!clazz.isAssignableFrom(biome.getClass())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean getSundamageInDim(DimensionType dim) {
        Boolean r = this.sundamageConfiguredDims.get(dim);
        if (r == null) {
            r = this.sundamageDims.get(dim);
        }
        return r == null ? ((Boolean)VampirismConfig.SERVER.sundamageUnknownDimension.get()).booleanValue() : r.booleanValue();
    }

    @Override
    public boolean isGettingSundamage(LivingEntity entity, IWorld world) {
        return Helper.gettingSundamge(entity, world, null);
    }

    public void reloadConfiguration() {
        this.sundamageConfiguredDims.clear();
        List negative = (List)VampirismConfig.SERVER.sundamageDimensionsOverrideNegative.get();
        for (Object s : negative) {
            ResourceLocation id = new ResourceLocation((String)s);
            Optional opt = Registry.field_212622_k.func_218349_b(id);
            opt.ifPresent(type -> this.sundamageConfiguredDims.put((DimensionType)type, false));
            if (opt.isPresent()) continue;
            LOGGER.warn("Could not find configured negative sundamage dimension {}", s);
        }
        List positive = (List)VampirismConfig.SERVER.sundamageDimensionsOverridePositive.get();
        for (String s : positive) {
            ResourceLocation id = new ResourceLocation(s);
            Optional opt = Registry.field_212622_k.func_218349_b(id);
            opt.ifPresent(type -> this.sundamageConfiguredDims.put((DimensionType)type, true));
            if (opt.isPresent()) continue;
            LOGGER.warn("Could not find configured positive sundamage dimension {}", (Object)s);
        }
        this.noSundamageConfiguredBiomesIDs.clear();
        List biomes = (List)VampirismConfig.SERVER.sundamageDisabledBiomes.get();
        for (String s : biomes) {
            ResourceLocation id = new ResourceLocation(s);
            this.noSundamageConfiguredBiomesIDs.add(id);
        }
    }

    public void specifyConfiguredSundamageForDim(DimensionType dimension, boolean sundamage) {
        this.sundamageConfiguredDims.put(dimension, sundamage);
    }

    @Override
    public void specifySundamageForDim(DimensionType dimension, boolean sundamage) {
        this.sundamageDims.put(dimension, sundamage);
    }
}

