/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandlerDefaultImpl;
import de.teamlapen.vampirism.util.ModEventFactory;
import de.teamlapen.vampirism.util.REFERENCE;
import de.teamlapen.vampirism.util.ScoreboardUtil;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FactionPlayerHandler
implements ISyncable.ISyncableEntityCapabilityInst,
IFactionPlayerHandler {
    private static final Logger LOGGER = LogManager.getLogger(FactionPlayerHandler.class);
    @CapabilityInject(value=IFactionPlayerHandler.class)
    public static Capability<IFactionPlayerHandler> CAP = (Capability)UtilLib.getNull();
    private final PlayerEntity player;
    private IPlayableFaction<? extends IFactionPlayer> currentFaction = null;
    private int currentLevel = 0;
    @Nullable
    private IAction boundAction1;
    @Nullable
    private IAction boundAction2;

    public static FactionPlayerHandler get(PlayerEntity player) {
        return (FactionPlayerHandler)player.getCapability(CAP, null).orElseThrow(() -> new IllegalStateException("Cannot get FactionPlayerHandler from EntityPlayer " + player));
    }

    public static LazyOptional<FactionPlayerHandler> getOpt(@Nonnull PlayerEntity player) {
        LazyOptional opt = player.getCapability(CAP, null).cast();
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get Faction player capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt;
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IFactionPlayerHandler.class, (Capability.IStorage)new Storage(), FactionPlayerHandlerDefaultImpl::new);
    }

    public static ICapabilityProvider createNewCapability(final PlayerEntity player) {
        return new ICapabilitySerializable<CompoundNBT>(){
            final IFactionPlayerHandler inst;
            final LazyOptional<IFactionPlayerHandler> opt;
            {
                this.inst = new FactionPlayerHandler(player);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            public void deserializeNBT(CompoundNBT nbt) {
                CAP.getStorage().readNBT(CAP, (Object)this.inst, null, (INBT)nbt);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                return CAP.orEmpty(capability, this.opt);
            }

            public CompoundNBT serializeNBT() {
                return (CompoundNBT)CAP.getStorage().writeNBT(CAP, (Object)this.inst, null);
            }
        };
    }

    private FactionPlayerHandler(PlayerEntity player) {
        this.player = player;
    }

    @Override
    public boolean canJoin(IPlayableFaction faction) {
        Event.Result res = ModEventFactory.fireCanJoinFactionEvent(this, this.currentFaction, faction);
        if (res == Event.Result.DEFAULT) {
            return this.currentFaction == null;
        }
        return res == Event.Result.ALLOW;
    }

    @Override
    public boolean canLeaveFaction() {
        return this.currentFaction == null || (Boolean)this.currentFaction.getPlayerCapability(this.player).map(IFactionPlayer::canLeaveFaction).orElse((Object)false) != false;
    }

    public void copyFrom(PlayerEntity old) {
        FactionPlayerHandler oldP = FactionPlayerHandler.get(old);
        this.currentFaction = oldP.currentFaction;
        this.currentLevel = oldP.currentLevel;
        this.boundAction1 = oldP.boundAction1;
        this.boundAction2 = oldP.boundAction2;
        this.notifyFaction(oldP.currentFaction, oldP.currentLevel);
    }

    @Nullable
    public IAction getBoundAction1() {
        return this.boundAction1;
    }

    @Nullable
    public IAction getBoundAction2() {
        return this.boundAction2;
    }

    @Override
    public ResourceLocation getCapKey() {
        return REFERENCE.FACTION_PLAYER_HANDLER_KEY;
    }

    @Override
    public IPlayableFaction<? extends IFactionPlayer> getCurrentFaction() {
        return this.currentFaction;
    }

    @Override
    @Nonnull
    public Optional<? extends IFactionPlayer> getCurrentFactionPlayer() {
        return this.currentFaction == null ? Optional.empty() : (Optional)this.currentFaction.getPlayerCapability(this.player).map(Optional::of).orElse(Optional.empty());
    }

    @Override
    public int getCurrentLevel() {
        return this.currentLevel;
    }

    @Override
    public int getCurrentLevel(IPlayableFaction f) {
        return this.isInFaction(f) ? this.currentLevel : 0;
    }

    @Override
    public float getCurrentLevelRelative() {
        return this.currentFaction == null ? 0.0f : (float)this.currentLevel / (float)this.currentFaction.getHighestReachableLevel();
    }

    @Override
    public PlayerEntity getPlayer() {
        return this.player;
    }

    @Override
    public int getTheEntityID() {
        return this.player.func_145782_y();
    }

    @Override
    public boolean isInFaction(@Nullable IPlayableFaction f) {
        return Objects.equals(this.currentFaction, f);
    }

    @Override
    public void joinFaction(@Nonnull IPlayableFaction faction) {
        if (this.canJoin(faction)) {
            this.setFactionAndLevel(faction, 1);
        }
    }

    @Override
    public void loadUpdateFromNBT(CompoundNBT nbt) {
        IPlayableFaction<? extends IFactionPlayer> old = this.currentFaction;
        int oldLevel = this.currentLevel;
        String f = nbt.func_74779_i("faction");
        if ("null".equals(f)) {
            this.currentFaction = null;
            this.currentLevel = 0;
        } else {
            this.currentFaction = this.getFactionFromKey(new ResourceLocation(f));
            if (this.currentFaction == null) {
                LOGGER.error("Cannot find faction {} on client. You have to register factions on both sides!", (Object)f);
                this.currentLevel = 0;
            } else {
                this.currentLevel = nbt.func_74762_e("level");
            }
        }
        if (nbt.func_74764_b("bound1")) {
            this.setBoundAction1((IAction)ModRegistries.ACTIONS.getValue(new ResourceLocation(nbt.func_74779_i("bound1"))), false);
        }
        if (nbt.func_74764_b("bound2")) {
            this.setBoundAction2((IAction)ModRegistries.ACTIONS.getValue(new ResourceLocation(nbt.func_74779_i("bound2"))), false);
        }
        this.notifyFaction(old, oldLevel);
    }

    @Override
    public boolean onEntityAttacked(DamageSource src, float amt) {
        if (((Boolean)VampirismConfig.SERVER.pvpOnlyBetweenFactions.get()).booleanValue() && src instanceof EntityDamageSource && src.func_76346_g() instanceof PlayerEntity) {
            FactionPlayerHandler other = FactionPlayerHandler.get((PlayerEntity)src.func_76346_g());
            return this.currentFaction == null || !this.currentFaction.equals(other.currentFaction);
        }
        return true;
    }

    public void setBoundAction1(@Nullable IAction boundAction1, boolean sync) {
        this.boundAction1 = boundAction1;
        if (sync) {
            this.sync(false);
            this.player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.actions.bind_action", new Object[]{new TranslationTextComponent(boundAction1.getTranslationKey(), new Object[0]).func_150254_d(), "1"}), true);
        }
    }

    public void setBoundAction2(@Nullable IAction boundAction2, boolean sync) {
        this.boundAction2 = boundAction2;
        if (sync) {
            this.sync(false);
            this.player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.actions.bind_action", new Object[]{new TranslationTextComponent(boundAction2.getTranslationKey(), new Object[0]).func_150254_d(), "2"}), true);
        }
    }

    @Override
    public boolean setFactionAndLevel(IPlayableFaction faction, int level) {
        IPlayableFaction<? extends IFactionPlayer> old = this.currentFaction;
        int oldLevel = this.currentLevel;
        if (!(this.currentFaction == null || this.currentFaction.equals(faction) && level != 0 || ((Boolean)this.currentFaction.getPlayerCapability(this.player).map(IFactionPlayer::canLeaveFaction).orElse((Object)false)).booleanValue())) {
            LOGGER.info("You cannot leave faction {}, it is prevented by respective mod", (Object)this.currentFaction.getID());
            return false;
        }
        if (faction != null && (level < 0 || level > faction.getHighestReachableLevel())) {
            LOGGER.warn("Level {} in faction {} cannot be reached", (Object)level, (Object)faction.getID());
            return false;
        }
        if (ModEventFactory.fireChangeLevelOrFactionEvent(this, old, oldLevel, faction, faction == null ? 0 : level)) {
            LOGGER.debug("Faction or Level change event canceled");
            return false;
        }
        if (faction == null) {
            this.currentFaction = null;
            this.currentLevel = 0;
        } else {
            this.currentFaction = faction;
            this.currentLevel = level;
        }
        if (this.currentFaction == null) {
            this.currentLevel = 0;
        } else if (this.currentLevel == 0) {
            this.currentFaction = null;
        }
        this.notifyFaction(old, oldLevel);
        this.sync(!Objects.equals(old, this.currentFaction));
        if (this.player instanceof ServerPlayerEntity) {
            ModAdvancements.TRIGGER_FACTION.trigger((ServerPlayerEntity)this.player, this.currentFaction, this.currentLevel);
        }
        return true;
    }

    @Override
    public boolean setFactionLevel(@Nonnull IPlayableFaction faction, int level) {
        return faction.equals(this.currentFaction) && this.setFactionAndLevel(faction, level);
    }

    @Override
    public void writeFullUpdateToNBT(CompoundNBT nbt) {
        nbt.func_74778_a("faction", this.currentFaction == null ? "null" : this.currentFaction.getID().toString());
        nbt.func_74768_a("level", this.currentLevel);
        if (this.getBoundAction1() != null) {
            nbt.func_74778_a("bound1", this.getBoundAction1().getRegistryName().toString());
        }
        if (this.getBoundAction2() != null) {
            nbt.func_74778_a("bound2", this.getBoundAction2().getRegistryName().toString());
        }
    }

    private IPlayableFaction getFactionFromKey(ResourceLocation key) {
        for (IPlayableFaction p : VampirismAPI.factionRegistry().getPlayableFactions()) {
            if (!p.getID().equals((Object)key)) continue;
            return p;
        }
        return null;
    }

    private void loadNBTData(CompoundNBT nbt) {
        if (nbt.func_74764_b("faction")) {
            this.currentFaction = this.getFactionFromKey(new ResourceLocation(nbt.func_74779_i("faction")));
            if (this.currentFaction == null) {
                LOGGER.warn("Could not find faction {}. Did mods change?", (Object)nbt.func_74779_i("faction"));
            } else {
                this.currentLevel = nbt.func_74762_e("level");
                this.notifyFaction(null, 0);
            }
        }
        if (nbt.func_74764_b("bound1")) {
            LOGGER.info((Object)new ResourceLocation(nbt.func_74779_i("bound1")));
            this.setBoundAction1((IAction)ModRegistries.ACTIONS.getValue(new ResourceLocation(nbt.func_74779_i("bound1"))), false);
        }
        if (nbt.func_74764_b("bound2")) {
            LOGGER.info((Object)new ResourceLocation(nbt.func_74779_i("bound1")));
            this.setBoundAction2((IAction)ModRegistries.ACTIONS.getValue(new ResourceLocation(nbt.func_74779_i("bound2"))), false);
        }
    }

    private void notifyFaction(IPlayableFaction<? extends IFactionPlayer> oldFaction, int oldLevel) {
        if (oldFaction != null && !oldFaction.equals(this.currentFaction)) {
            LOGGER.debug("Leaving faction {}", (Object)oldFaction.getID());
            oldFaction.getPlayerCapability(this.player).ifPresent(c -> c.onLevelChanged(0, oldLevel));
        }
        if (this.currentFaction != null) {
            LOGGER.debug("Changing to {} {}", this.currentFaction, (Object)this.currentLevel);
            this.currentFaction.getPlayerCapability(this.player).ifPresent(c -> c.onLevelChanged(this.currentLevel, Objects.equals(oldFaction, this.currentFaction) ? oldLevel : 0));
        }
        ScoreboardUtil.updateScoreboard(this.player, ScoreboardUtil.FACTION_CRITERIA, this.currentFaction == null ? 0 : this.currentFaction.getID().hashCode());
    }

    private void saveNBTData(CompoundNBT nbt) {
        if (this.currentFaction != null) {
            nbt.func_74778_a("faction", this.currentFaction.getID().toString());
            nbt.func_74768_a("level", this.currentLevel);
        }
        if (this.getBoundAction1() != null) {
            nbt.func_74778_a("bound1", this.getBoundAction1().getRegistryName().toString());
        }
        if (this.getBoundAction2() != null) {
            nbt.func_74778_a("bound2", this.getBoundAction2().getRegistryName().toString());
        }
    }

    private void sync(boolean all) {
        HelperLib.sync(this, (Entity)this.player, all);
    }

    private static class Storage
    implements Capability.IStorage<IFactionPlayerHandler> {
        private Storage() {
        }

        public void readNBT(Capability<IFactionPlayerHandler> capability, IFactionPlayerHandler instance, Direction side, INBT nbt) {
            ((FactionPlayerHandler)instance).loadNBTData((CompoundNBT)nbt);
        }

        public INBT writeNBT(Capability<IFactionPlayerHandler> capability, IFactionPlayerHandler instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            ((FactionPlayerHandler)instance).saveNBTData(nbt);
            return nbt;
        }
    }
}

