/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.container;

import de.teamlapen.lib.lib.inventory.InventoryContainer;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.items.HunterIntelItem;
import de.teamlapen.vampirism.items.PureBloodItem;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;

public class HunterTableContainer
extends InventoryContainer
implements IInventoryChangedListener {
    private static final InventoryContainer.SelectorInfo[] SELECTOR_INFOS = new InventoryContainer.SelectorInfo[]{new InventoryContainer.SelectorInfo(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151122_aG}), 15, 28), new InventoryContainer.SelectorInfo(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.vampire_fang}), 42, 28), new InventoryContainer.SelectorInfo(Ingredient.func_199805_a(ModTags.Items.PURE_BLOOD), 69, 28), new InventoryContainer.SelectorInfo(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.vampire_book}), 96, 28)};
    private final SlotResult slotResult;
    private final int hunterLevel;
    private final HunterLevelingConf levelingConf = HunterLevelingConf.instance();
    private ItemStack missing = ItemStack.field_190927_a;

    @Deprecated
    public HunterTableContainer(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, IWorldPosCallable.field_221489_a);
    }

    public HunterTableContainer(int id, PlayerInventory playerInventory, IWorldPosCallable worldPosCallable) {
        super(ModContainer.hunter_table, id, playerInventory, worldPosCallable, (IInventory)new Inventory(SELECTOR_INFOS.length), SELECTOR_INFOS);
        ((Inventory)this.inventory).func_110134_a((IInventoryChangedListener)this);
        this.slotResult = new SlotResult(this, (IInventory)new CraftResultInventory(){

            public int func_70297_j_() {
                return 1;
            }
        }, 4, 146, 28);
        this.func_75146_a(this.slotResult);
        this.hunterLevel = FactionPlayerHandler.get(playerInventory.field_70458_d).getCurrentLevel(VReference.HUNTER_FACTION);
        this.addPlayerSlots(playerInventory);
    }

    @Override
    public boolean func_75145_c(PlayerEntity playerIn) {
        return HunterTableContainer.func_216963_a((IWorldPosCallable)this.worldPos, (PlayerEntity)playerIn, (Block)ModBlocks.hunter_table);
    }

    public ItemStack getMissingItems() {
        return this.missing;
    }

    public boolean isLevelValid() {
        return this.levelingConf.isLevelValidForTable(this.hunterLevel + 1);
    }

    @Override
    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (!playerIn.func_130014_f_().field_72995_K) {
            this.func_193327_a(playerIn, playerIn.field_70170_p, this.inventory);
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
        if (this.isLevelValid()) {
            int[] req = this.levelingConf.getItemRequirementsForTable(this.hunterLevel + 1);
            this.missing = this.checkItems(req[0], req[1], req[2], req[3]);
            if (this.missing.func_190926_b()) {
                this.slotResult.field_75224_c.func_70299_a(0, new ItemStack((IItemProvider)HunterIntelItem.getIntelForExactlyLevel(this.hunterLevel + 1)));
            } else {
                this.slotResult.field_75224_c.func_70299_a(0, ItemStack.field_190927_a);
            }
        }
    }

    public void func_76316_a(IInventory invBasic) {
        this.func_75130_a(invBasic);
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity playerEntity, int index) {
        ItemStack result = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            result = slotStack.func_77946_l();
            if (index == 4) {
                if (!this.func_75135_a(slotStack, 5, 41, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 5) {
                if (index < 32) {
                    if (!this.func_75135_a(slotStack, 0, 5, false)) {
                        return ItemStack.field_190927_a;
                    }
                    if (this.func_75135_a(slotStack, 32, 41, false)) {
                        return ItemStack.field_190927_a;
                    }
                } else if (!this.func_75135_a(slotStack, 0, 32, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (!this.func_75135_a(slotStack, 5, 41, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == result.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerEntity, slotStack);
        }
        return result;
    }

    protected void onPickupResult() {
        int[] req = this.levelingConf.getItemRequirementsForTable(this.hunterLevel + 1);
        InventoryHelper.removeItems(this.inventory, new int[]{1, req[0], req[1], req[3]});
    }

    private ItemStack checkItems(int fangs, int blood, int bloodLevel, int par3) {
        return InventoryHelper.checkItems(this.inventory, new Item[]{Items.field_151122_aG, ModItems.vampire_fang, PureBloodItem.getBloodItemForLevel(bloodLevel), ModItems.vampire_book}, new int[]{1, fangs, blood, par3});
    }

    private class SlotResult
    extends Slot {
        private final HunterTableContainer container;

        public SlotResult(HunterTableContainer container, IInventory inventory, int index, int xPosition, int yPosition) {
            super(inventory, index, xPosition, yPosition);
            this.container = container;
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public ItemStack func_190901_a(PlayerEntity playerIn, ItemStack stack) {
            this.container.onPickupResult();
            return stack;
        }
    }
}

