/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.container;

import de.teamlapen.lib.lib.inventory.InventoryContainer;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.HunterTrainerEntity;
import de.teamlapen.vampirism.items.HunterIntelItem;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class HunterTrainerContainer
extends InventoryContainer
implements IInventoryChangedListener {
    private static final InventoryContainer.SelectorInfo[] SELECTOR_INFOS = new InventoryContainer.SelectorInfo[]{new InventoryContainer.SelectorInfo(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151042_j}), 27, 26), new InventoryContainer.SelectorInfo(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151043_k}), 57, 26), new InventoryContainer.SelectorInfo(Ingredient.func_199805_a(ModTags.Items.HUNTER_INTEL), 86, 26)};
    private final PlayerEntity player;
    @Nullable
    private final HunterTrainerEntity entity;
    private boolean changed = false;
    private ItemStack missing = ItemStack.field_190927_a;

    @Deprecated
    public HunterTrainerContainer(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, null);
    }

    public HunterTrainerContainer(int id, PlayerInventory playerInventory, @Nullable HunterTrainerEntity trainer) {
        super(ModContainer.hunter_trainer, id, playerInventory, trainer == null ? IWorldPosCallable.field_221489_a : IWorldPosCallable.func_221488_a((World)trainer.field_70170_p, (BlockPos)trainer.func_180425_c()), (IInventory)new Inventory(SELECTOR_INFOS.length), SELECTOR_INFOS);
        ((Inventory)this.inventory).func_110134_a((IInventoryChangedListener)this);
        this.player = playerInventory.field_70458_d;
        this.addPlayerSlots(playerInventory);
        this.entity = trainer;
    }

    @Override
    public boolean func_75145_c(PlayerEntity player) {
        if (this.entity == null) {
            return false;
        }
        return new Vec3d(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()).func_72438_d(new Vec3d(this.entity.func_226277_ct_(), this.entity.func_226278_cu_(), this.entity.func_226281_cx_())) < 5.0;
    }

    public boolean canLevelup() {
        int targetLevel = FactionPlayerHandler.get(this.player).getCurrentLevel(VReference.HUNTER_FACTION) + 1;
        HunterLevelingConf levelingConf = HunterLevelingConf.instance();
        if (!levelingConf.isLevelValidForTrainer(targetLevel)) {
            return false;
        }
        int[] req = levelingConf.getItemRequirementsForTrainer(targetLevel);
        int level = levelingConf.getHunterIntelMetaForLevel(targetLevel);
        this.missing = InventoryHelper.checkItems(this.inventory, new Item[]{Items.field_151042_j, Items.field_151043_k, HunterIntelItem.getIntelForLevel(level)}, new int[]{req[0], req[1], 1});
        return this.missing.func_190926_b();
    }

    public ItemStack getMissingItems() {
        return this.missing;
    }

    public boolean hasChanged() {
        if (this.changed) {
            this.changed = false;
            return true;
        }
        return false;
    }

    @Override
    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (!playerIn.func_130014_f_().field_72995_K) {
            this.func_193327_a(playerIn, playerIn.func_130014_f_(), this.inventory);
        }
    }

    public void func_76316_a(IInventory iInventory) {
        this.changed = true;
    }

    public void onLevelupClicked() {
        if (this.canLevelup()) {
            int old = FactionPlayerHandler.get(this.player).getCurrentLevel(VReference.HUNTER_FACTION);
            FactionPlayerHandler.get(this.player).setFactionLevel(VReference.HUNTER_FACTION, old + 1);
            int[] req = HunterLevelingConf.instance().getItemRequirementsForTrainer(old + 1);
            InventoryHelper.removeItems(this.inventory, new int[]{req[0], req[1], 1});
            this.player.func_195064_c(new EffectInstance(ModEffects.saturation, 400, 2));
            this.changed = true;
        }
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity playerEntity, int index) {
        ItemStack result = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            result = slotStack.func_77946_l();
            if (index >= 3) {
                if (index < 30) {
                    if (!this.func_75135_a(slotStack, 0, 3, false)) {
                        return ItemStack.field_190927_a;
                    }
                    if (this.func_75135_a(slotStack, 30, 39, false)) {
                        return ItemStack.field_190927_a;
                    }
                } else if (!this.func_75135_a(slotStack, 0, 30, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (!this.func_75135_a(slotStack, 3, 39, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == result.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerEntity, slotStack);
        }
        return result;
    }
}

