/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.container;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.blocks.WeaponTableBlock;
import de.teamlapen.vampirism.client.gui.recipebook.WeaponTableRecipePlacer;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.inventory.inventory.WeaponTableCraftingSlot;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.util.RecipeBookCategories;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.state.IProperty;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.IContainerFactory;

public class WeaponTableContainer
extends RecipeBookContainer<CraftingInventory> {
    private final IWorldPosCallable worldPos;
    private final HunterPlayer hunterPlayer;
    private final PlayerEntity player;
    private CraftingInventory craftMatrix = new CraftingInventory((Container)this, 4, 4);
    private CraftResultInventory craftResult = new CraftResultInventory();
    private boolean missingLava = false;
    private boolean prevMissingLava = false;

    @Deprecated
    public WeaponTableContainer(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, IWorldPosCallable.field_221489_a);
    }

    public WeaponTableContainer(int id, PlayerInventory playerInventory, IWorldPosCallable worldPosCallable) {
        super(ModContainer.weapon_table, id);
        this.worldPos = worldPosCallable;
        this.hunterPlayer = HunterPlayer.get(playerInventory.field_70458_d);
        this.player = playerInventory.field_70458_d;
        this.func_75146_a(new WeaponTableCraftingSlot(playerInventory.field_70458_d, this.craftMatrix, (IInventory)this.craftResult, 0, 144, 46, worldPosCallable));
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, j + i * 4, 34 + j * 19, 16 + i * 19));
            }
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.func_75146_a(new Slot((IInventory)playerInventory, i1 + k * 9 + 9, 18 + i1 * 18, 107 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.func_75146_a(new Slot((IInventory)playerInventory, l, 18 + l * 18, 165));
        }
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    public void func_217056_a(boolean shouldPlaceAll, @Nonnull IRecipe<?> recipe, @Nonnull ServerPlayerEntity serverPlayer) {
        new WeaponTableRecipePlacer<CraftingInventory>(this).func_194327_a(serverPlayer, recipe, shouldPlaceAll);
    }

    public boolean func_75145_c(@Nonnull PlayerEntity playerIn) {
        return WeaponTableContainer.func_216963_a((IWorldPosCallable)this.worldPos, (PlayerEntity)playerIn, (Block)ModBlocks.weapon_table);
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.craftResult && super.func_94530_a(stack, slotIn);
    }

    public void func_201768_e() {
        this.craftMatrix.func_174888_l();
        this.craftResult.func_174888_l();
    }

    public void func_201771_a(@Nonnull RecipeItemHelper recipeItemHelper) {
        this.craftMatrix.func_194018_a(recipeItemHelper);
    }

    public int func_201772_h() {
        return this.craftMatrix.func_174923_h();
    }

    public int func_201767_f() {
        return 0;
    }

    public int func_203721_h() {
        return 17;
    }

    public int func_201770_g() {
        return this.craftMatrix.func_174922_i();
    }

    public boolean hasLava() {
        return (Boolean)this.worldPos.func_221485_a((world, blockPos) -> (Integer)world.func_180495_p(blockPos).func_177229_b((IProperty)WeaponTableBlock.LAVA) > 0, (Object)false);
    }

    public boolean isMissingLava() {
        return this.missingLava;
    }

    public boolean func_201769_a(IRecipe<? super CraftingInventory> recipeIn) {
        return recipeIn.func_77569_a((IInventory)this.craftMatrix, this.player.field_70170_p);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.worldPos.func_221486_a((world, pos) -> {
            this.func_193327_a(playerIn, (World)world, (IInventory)this.craftMatrix);
            for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                ItemStack itemstack = this.craftMatrix.func_70304_b(i);
                if (itemstack.func_190926_b()) continue;
                playerIn.func_71019_a(itemstack, false);
            }
            this.missingLava = false;
        });
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.worldPos.func_221486_a((world, pos) -> this.slotChangedCraftingGrid((World)world, this.player, this.hunterPlayer, this.craftMatrix, this.craftResult));
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemStackCopy = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemStackCopy = itemstack1.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(itemstack1, 17, 53, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemStackCopy);
            } else if (index >= 17 && index < 44 ? !this.func_75135_a(itemstack1, 44, 53, false) : (index >= 44 && index < 53 ? !this.func_75135_a(itemstack1, 17, 44, false) : !this.func_75135_a(itemstack1, 17, 53, false))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemStackCopy.func_190916_E() == itemstack1.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemStackCopy;
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener icontainerlistener : this.field_75149_d) {
            if (this.prevMissingLava == this.missingLava) continue;
            icontainerlistener.func_71112_a((Container)this, 0, this.missingLava ? 1 : 0);
        }
        this.prevMissingLava = this.missingLava;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_75137_b(int id, int data) {
        if (id == 0) {
            this.missingLava = data != 0;
        }
    }

    private void slotChangedCraftingGrid(World worldIn, PlayerEntity playerIn, HunterPlayer hunter, CraftingInventory craftMatrixIn, CraftResultInventory craftResultIn) {
        if (!worldIn.field_72995_K) {
            IWeaponTableRecipe recipe;
            ServerPlayerEntity entityplayermp = (ServerPlayerEntity)playerIn;
            Optional optional = worldIn.func_73046_m().func_199529_aN().func_215371_a(ModRecipes.WEAPONTABLE_CRAFTING_TYPE, (IInventory)craftMatrixIn, worldIn);
            this.missingLava = false;
            craftResultIn.func_70299_a(0, ItemStack.field_190927_a);
            if (optional.isPresent() && craftResultIn.func_201561_a(worldIn, entityplayermp, (IRecipe)(recipe = (IWeaponTableRecipe)optional.get())) && recipe.getRequiredLevel() <= hunter.getLevel() && Helper.areSkillsEnabled(hunter.getSkillHandler(), recipe.getRequiredSkills())) {
                this.worldPos.func_221486_a((world, pos) -> {
                    if ((Integer)world.func_180495_p(pos).func_177229_b((IProperty)WeaponTableBlock.LAVA) >= recipe.getRequiredLavaUnits()) {
                        craftResultIn.func_70299_a(0, recipe.getCraftingResult(craftMatrixIn));
                    } else {
                        this.missingLava = true;
                    }
                });
            }
            entityplayermp.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 0, craftResultIn.func_70301_a(0)));
        }
    }

    @Nonnull
    public List<RecipeBookCategories> getRecipeBookCategories() {
        return Lists.newArrayList((Object[])new RecipeBookCategories[]{RecipeBookCategories.MISC});
    }

    public static class Factory
    implements IContainerFactory<WeaponTableContainer> {
        public WeaponTableContainer create(int windowId, PlayerInventory inv, PacketBuffer data) {
            BlockPos pos = data.func_179259_c();
            return new WeaponTableContainer(windowId, inv, IWorldPosCallable.func_221488_a((World)inv.field_70458_d.field_70170_p, (BlockPos)pos));
        }
    }
}

