/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.inventory.recipes.VampirismRecipeHelper;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.ForgeRegistryEntry;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ShapelessWeaponTableRecipe
implements ICraftingRecipe,
IWeaponTableRecipe {
    protected static int MAX_WIDTH = 4;
    protected static int MAX_HEIGHT = 4;
    private final ResourceLocation id;
    private final String group;
    private final NonNullList<Ingredient> recipeItems;
    private final ItemStack recipeOutput;
    private final int requiredLevel;
    private final ISkill[] requiredSkills;
    private final int requiredLava;
    private final boolean isSimple;

    public ShapelessWeaponTableRecipe(ResourceLocation recipeId, String group, NonNullList<Ingredient> ingredients, ItemStack result, int level, int lava, ISkill[] skills) {
        this.id = recipeId;
        this.group = group;
        this.recipeItems = ingredients;
        this.recipeOutput = result;
        this.requiredLevel = level;
        this.requiredLava = lava;
        this.requiredSkills = skills;
        this.isSimple = ingredients.stream().allMatch(Ingredient::isSimple);
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.recipeItems.size();
    }

    @Override
    public ItemStack getCraftingResult(CraftingInventory inv) {
        return this.recipeOutput.func_77946_l();
    }

    public String func_193358_e() {
        return this.group;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Override
    public NonNullList<Ingredient> func_192400_c() {
        return this.recipeItems;
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    @Override
    public int getRequiredLavaUnits() {
        return this.requiredLava;
    }

    @Override
    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    @Override
    public ISkill[] getRequiredSkills() {
        return this.requiredSkills;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipes.shapeless_crafting_weapontable;
    }

    public IRecipeType<? extends IRecipe> func_222127_g() {
        return ModRecipes.WEAPONTABLE_CRAFTING_TYPE;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        RecipeItemHelper recipeitemhelper = new RecipeItemHelper();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < inv.func_174923_h(); ++j) {
            for (int k = 0; k < inv.func_174922_i(); ++k) {
                ItemStack itemstack = inv.func_70301_a(k + j * inv.func_174922_i());
                if (itemstack.func_190926_b()) continue;
                ++i;
                if (this.isSimple) {
                    recipeitemhelper.func_194112_a(new ItemStack((IItemProvider)itemstack.func_77973_b()));
                    continue;
                }
                inputs.add(itemstack);
            }
        }
        return i == this.recipeItems.size() && (this.isSimple ? recipeitemhelper.func_194116_a((IRecipe)this, null) : RecipeMatcher.findMatches(inputs, this.recipeItems) != null);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapelessWeaponTableRecipe> {
        public ShapelessWeaponTableRecipe read(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = VampirismRecipeHelper.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            int level = JSONUtils.func_151208_a((JsonObject)json, (String)"level", (int)1);
            ISkill[] skills = VampirismRecipeHelper.deserializeSkills(JSONUtils.func_151213_a((JsonObject)json, (String)"skill", null));
            int lava = JSONUtils.func_151208_a((JsonObject)json, (String)"lava", (int)0);
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (ingredients.size() > MAX_WIDTH * MAX_HEIGHT) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is " + MAX_WIDTH * MAX_HEIGHT);
            }
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            return new ShapelessWeaponTableRecipe(recipeId, group, ingredients, result, level, lava, skills);
        }

        public ShapelessWeaponTableRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            NonNullList ingredients = NonNullList.func_191197_a((int)buffer.func_150792_a(), (Object)Ingredient.field_193370_a);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack result = buffer.func_150791_c();
            int level = buffer.func_150792_a();
            int lava = buffer.func_150792_a();
            ISkill[] skills = new ISkill[buffer.func_150792_a()];
            for (int i = 0; i < skills.length; ++i) {
                skills[i] = (ISkill)ModRegistries.SKILLS.getValue(new ResourceLocation(buffer.func_150789_c(Short.MAX_VALUE)));
            }
            return new ShapelessWeaponTableRecipe(recipeId, group, (NonNullList<Ingredient>)ingredients, result, level, lava, skills);
        }

        public void write(PacketBuffer buffer, ShapelessWeaponTableRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            buffer.func_150787_b(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.recipeOutput);
            buffer.func_150787_b(recipe.requiredLevel);
            buffer.func_150787_b(recipe.requiredLava);
            buffer.func_150787_b(recipe.requiredSkills.length);
            for (ISkill skill : recipe.requiredSkills) {
                buffer.func_180714_a(skill.getRegistryName().toString());
            }
        }
    }
}

