/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.items.VampirismVampireSword;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HeartStrikerItem
extends VampirismVampireSword
implements IItemWithTier {
    public static final String regName = "heart_striker";
    private static final int[] DAMAGE_TIER = new int[]{8, 9, 11};
    private static final float[] UNTRAINED_SPEED_TIER = new float[]{-4.2f, -3.9f, -3.6f};
    private static final float[] TRAINED_SPEED_TIER = new float[]{-1.6f, -1.5f, -1.4f};
    private final IItemWithTier.TIER tier;

    public HeartStrikerItem(IItemWithTier.TIER tier) {
        super("heart_striker_" + tier.func_176610_l(), ItemTier.IRON, DAMAGE_TIER[tier.ordinal()], UNTRAINED_SPEED_TIER[tier.ordinal()], TRAINED_SPEED_TIER[tier.ordinal()], new Item.Properties().func_200916_a(VampirismMod.creativeTab).func_200918_c(2500));
        this.tier = tier;
        this.setTranslation_key(regName);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        this.addTierInformation(tooltip);
    }

    @Override
    public String getBaseRegName() {
        return regName;
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    @Override
    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (target.func_110143_aJ() <= 0.0f && Helper.isVampire((Entity)attacker)) {
            float trained = this.getTrained(stack, attacker);
            int exp = target instanceof PlayerEntity ? 10 : (attacker instanceof PlayerEntity ? Helper.getExperiencePoints(target, (PlayerEntity)attacker) : 5);
            trained += (float)exp / 5.0f * (1.0f - trained) / 15.0f;
            this.setTrained(stack, attacker, trained);
        }
        float charged = this.getCharged(stack);
        charged = (float)((double)charged - (Double)VampirismConfig.BALANCE.heartSeekerUsageFactor.get() / 100.0 * (double)(this.getVampirismTier().ordinal() + 2) / 2.0);
        this.setCharged(stack, charged);
        attacker.func_184611_a(Hand.MAIN_HAND, stack);
        return super.func_77644_a(stack, target, attacker);
    }

    @Override
    protected float getChargingFactor(ItemStack stack) {
        return (float)((Double)VampirismConfig.BALANCE.heartSeekerChargingFactor.get() * 2.0 / (double)((float)this.getVampirismTier().ordinal() + 2.0f));
    }

    public boolean func_82789_a(ItemStack p_82789_1_, ItemStack p_82789_2_) {
        return this.tier == IItemWithTier.TIER.ULTIMATE && super.func_82789_a(p_82789_1_, p_82789_2_);
    }
}

