/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.skills;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.player.skills.SkillNode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkillHandler<T extends IFactionPlayer>
implements ISkillHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger(SkillHandler.class);
    private final ArrayList<ISkill> enabledSkills = new ArrayList();
    private final T player;
    private final IPlayableFaction<T> faction;
    private boolean dirty = false;

    public SkillHandler(T player, IPlayableFaction<T> faction) {
        this.player = player;
        this.faction = faction;
    }

    @Override
    public ISkillHandler.Result canSkillBeEnabled(ISkill skill) {
        if (this.isSkillEnabled(skill)) {
            return ISkillHandler.Result.ALREADY_ENABLED;
        }
        SkillNode node = this.findSkillNode(this.getRootNode(), skill);
        if (node != null) {
            if (node.isRoot() || this.isNodeEnabled(node.getParent())) {
                if (this.getLeftSkillPoints() > 0) {
                    return this.isNodeEnabled(node) ? ISkillHandler.Result.OTHER_NODE_SKILL : ISkillHandler.Result.OK;
                }
                return ISkillHandler.Result.NO_POINTS;
            }
            return ISkillHandler.Result.PARENT_NOT_ENABLED;
        }
        LOGGER.warn("Node for skill {} could not be found", (Object)skill);
        return ISkillHandler.Result.NOT_FOUND;
    }

    public void disableAllSkills() {
        for (ISkill skill : this.enabledSkills) {
            skill.onDisable((IFactionPlayer)this.player);
        }
        this.enabledSkills.clear();
        this.dirty = true;
    }

    @Override
    public void disableSkill(ISkill skill) {
        if (this.enabledSkills.remove(skill)) {
            skill.onDisable((IFactionPlayer)this.player);
            this.dirty = true;
        }
    }

    public void enableRootSkill() {
        this.enableSkill(this.getRootNode().getElements()[0]);
    }

    @Override
    public void enableSkill(ISkill skill) {
        if (!this.enabledSkills.contains(skill)) {
            skill.onEnable((IFactionPlayer)this.player);
            this.enabledSkills.add(skill);
            this.dirty = true;
            if (this.player.getRepresentingPlayer() instanceof ServerPlayerEntity) {
                ModAdvancements.TRIGGER_SKILL_UNLOCKED.trigger((ServerPlayerEntity)this.player.getRepresentingPlayer(), skill);
            }
        }
    }

    public SkillNode findSkillNode(SkillNode base, ISkill skill) {
        for (ISkill s : base.getElements()) {
            if (!s.equals(skill)) continue;
            return base;
        }
        for (SkillNode child : base.getChildren()) {
            SkillNode node = this.findSkillNode(child, skill);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    @Override
    public int getLeftSkillPoints() {
        int level = this.player.getLevel();
        if (((Boolean)VampirismConfig.SERVER.unlockAllSkills.get()).booleanValue() && level == this.player.getMaxLevel()) {
            return 1;
        }
        return this.player.getLevel() - this.enabledSkills.size();
    }

    @Override
    public ISkill[] getParentSkills(ISkill skill) {
        SkillNode node = this.findSkillNode(this.getRootNode(), skill);
        if (node == null) {
            return null;
        }
        return node.getParent().getElements();
    }

    public IFactionPlayer<T> getPlayer() {
        return this.player;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isNodeEnabled(SkillNode node) {
        for (ISkill s : this.enabledSkills) {
            if (!node.containsSkill(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSkillEnabled(ISkill skill) {
        return this.enabledSkills.contains(skill);
    }

    public void loadFromNbt(CompoundNBT nbt) {
        if (!nbt.func_74764_b("skills")) {
            return;
        }
        for (String id : nbt.func_74775_l("skills").func_150296_c()) {
            ISkill skill = (ISkill)ModRegistries.SKILLS.getValue(new ResourceLocation(id));
            if (skill == null) {
                LOGGER.warn("Skill {} does not exist anymore", (Object)id);
                continue;
            }
            this.enableSkill(skill);
        }
    }

    public void readUpdateFromServer(CompoundNBT nbt) {
        if (!nbt.func_74764_b("skills")) {
            return;
        }
        List old = (List)this.enabledSkills.clone();
        for (String id : nbt.func_74775_l("skills").func_150296_c()) {
            ISkill skill = (ISkill)ModRegistries.SKILLS.getValue(new ResourceLocation(id));
            if (skill == null) {
                LOGGER.error("Skill {} does not exist on client!!!", (Object)id);
                continue;
            }
            if (old.contains(skill)) {
                old.remove(skill);
                continue;
            }
            this.enableSkill(skill);
        }
        for (ISkill skill : old) {
            this.disableSkill(skill);
        }
    }

    @Override
    public void resetSkills() {
        this.disableAllSkills();
        this.enableRootSkill();
    }

    public void saveToNbt(CompoundNBT nbt) {
        CompoundNBT skills = new CompoundNBT();
        for (ISkill skill : this.enabledSkills) {
            skills.func_74757_a(skill.getRegistryName().toString(), true);
        }
        nbt.func_218657_a("skills", (INBT)skills);
    }

    public void writeUpdateForClient(CompoundNBT nbt) {
        CompoundNBT skills = new CompoundNBT();
        for (ISkill skill : this.enabledSkills) {
            skills.func_74757_a(skill.getRegistryName().toString(), true);
        }
        nbt.func_218657_a("skills", (INBT)skills);
        this.dirty = false;
    }

    private SkillNode getRootNode() {
        return VampirismMod.proxy.getSkillTree(this.player.isRemote()).getRootNodeForFaction(this.faction.getID());
    }
}

