/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire.actions;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.AreaParticleCloudEntity;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;

public class TeleportVampireAction
extends DefaultVampireAction {
    @Override
    public boolean activate(IVampirePlayer vampire) {
        PlayerEntity player = vampire.getRepresentingPlayer();
        RayTraceResult target = UtilLib.getPlayerLookingSpot(player, ((Integer)VampirismConfig.BALANCE.vaTeleportMaxDistance.get()).intValue());
        double ox = player.func_226277_ct_();
        double oy = player.func_226278_cu_();
        double oz = player.func_226281_cx_();
        if (target.func_216346_c() == RayTraceResult.Type.MISS) {
            player.func_184185_a(SoundEvents.field_187679_dF, 1.0f, 1.0f);
            return false;
        }
        BlockPos pos = null;
        if (target.func_216346_c() == RayTraceResult.Type.BLOCK) {
            if (player.func_130014_f_().func_180495_p(((BlockRayTraceResult)target).func_216350_a()).func_185904_a().func_76230_c()) {
                pos = ((BlockRayTraceResult)target).func_216350_a().func_177984_a();
            }
        } else if (player.func_130014_f_().func_180495_p(((EntityRayTraceResult)target).func_216348_a().func_180425_c()).func_185904_a().func_76230_c()) {
            pos = ((EntityRayTraceResult)target).func_216348_a().func_180425_c();
        }
        if (pos != null) {
            player.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
            if (player.func_130014_f_().func_72953_d(player.func_174813_aQ()) || !player.func_130014_f_().func_226668_i_((Entity)player)) {
                pos = null;
            }
        }
        if (pos == null) {
            player.func_70107_b(ox, oy, oz);
            player.func_184185_a(SoundEvents.field_187676_dE, 1.0f, 1.0f);
            return false;
        }
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity playerMp = (ServerPlayerEntity)player;
            playerMp.func_71123_m();
            playerMp.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
        }
        AreaParticleCloudEntity particleCloud = new AreaParticleCloudEntity((EntityType<? extends AreaParticleCloudEntity>)ModEntities.particle_cloud, player.func_130014_f_());
        particleCloud.func_70107_b(ox, oy, oz);
        particleCloud.setRadius(0.7f);
        particleCloud.setHeight(player.func_213302_cg());
        particleCloud.setDuration(5);
        particleCloud.setSpawnRate(15.0f);
        player.func_130014_f_().func_217376_c((Entity)particleCloud);
        player.func_130014_f_().func_184134_a(ox, oy, oz, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        player.func_130014_f_().func_184134_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        return true;
    }

    @Override
    public boolean canBeUsedBy(IVampirePlayer vampire) {
        return !vampire.getActionHandler().isActionActive(VampireActions.bat);
    }

    @Override
    public int getCooldown() {
        return (Integer)VampirismConfig.BALANCE.vaTeleportCooldown.get() * 20;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.vaTeleportEnabled.get();
    }
}

