/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.lib.lib.tile.InventoryTileEntity;
import de.teamlapen.lib.lib.util.ValuedObject;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.advancements.VampireActionTrigger;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.blocks.AltarPillarBlock;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.inventory.container.AltarInfusionContainer;
import de.teamlapen.vampirism.items.PureBloodItem;
import de.teamlapen.vampirism.particle.FlyingBloodParticleData;
import de.teamlapen.vampirism.player.vampire.VampireLevelingConf;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AltarInfusionTileEntity
extends InventoryTileEntity
implements ITickableTileEntity {
    private static final Logger LOGGER = LogManager.getLogger(AltarInfusionTileEntity.class);
    private final int DURATION_TICK = 450;
    private UUID playerToLoadUUID;
    private PlayerEntity player;
    private BlockPos[] tips;
    private int runningTick;
    private int targetLevel;
    private LazyOptional<IItemHandler> itemHandlerOptional = LazyOptional.of(this::createWrapper);

    public AltarInfusionTileEntity() {
        super(ModTiles.altar_infusion, 3, AltarInfusionContainer.SELECTOR_INFOS);
    }

    public Result canActivate(PlayerEntity player, boolean messagePlayer) {
        if (this.runningTick > 0) {
            if (messagePlayer) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.altar_infusion.ritual_still_running", new Object[0]));
            }
            return Result.ISRUNNING;
        }
        this.player = null;
        this.targetLevel = VampirePlayer.get(player).getLevel() + 1;
        int requiredLevel = this.checkRequiredLevel();
        if (requiredLevel == -1) {
            if (messagePlayer) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.altar_infusion.ritual_level_wrong", new Object[0]));
            }
            return Result.WRONGLEVEL;
        }
        if (player.func_130014_f_().func_72935_r()) {
            if (messagePlayer) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.altar_infusion.ritual_night_only", new Object[0]));
            }
            return Result.NIGHTONLY;
        }
        if (!this.checkStructureLevel(requiredLevel)) {
            if (messagePlayer) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.altar_infusion.ritual_structure_wrong", new Object[0]));
            }
            this.tips = null;
            return Result.STRUCTUREWRONG;
        }
        if (!this.checkItemRequirements(player, messagePlayer)) {
            this.tips = null;
            return Result.INVMISSING;
        }
        return Result.OK;
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public PHASE getCurrentPhase() {
        if (this.runningTick < 1) {
            return PHASE.NOT_RUNNING;
        }
        if (this.runningTick == 1) {
            return PHASE.CLEAN_UP;
        }
        if (this.runningTick > 350) {
            return PHASE.PARTICLE_SPREAD;
        }
        if (this.runningTick < 290 && this.runningTick >= 250) {
            return PHASE.BEAM1;
        }
        if (this.runningTick < 250 && this.runningTick > 50) {
            return PHASE.BEAM2;
        }
        if (this.runningTick == 50) {
            return PHASE.LEVELUP;
        }
        if (this.runningTick < 50) {
            return PHASE.ENDING;
        }
        return PHASE.WAITING;
    }

    public PlayerEntity getPlayer() {
        if (this.runningTick <= 1) {
            return null;
        }
        return this.player;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public int getRunningTick() {
        return this.runningTick;
    }

    public BlockPos[] getTips() {
        if (this.runningTick <= 1) {
            return null;
        }
        return this.tips;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        int tick = tagCompound.func_74762_e("tick");
        if (tick > 0 && this.player == null && tagCompound.func_186855_b("playerUUID")) {
            UUID playerID = tagCompound.func_186857_a("playerUUID");
            if (!this.loadRitual(playerID)) {
                this.playerToLoadUUID = playerID;
            }
            this.runningTick = tick;
        }
    }

    public void startRitual(PlayerEntity player) {
        if (this.field_145850_b == null) {
            return;
        }
        LOGGER.debug("Starting ritual for {}", (Object)player);
        this.player = player;
        this.runningTick = 450;
        this.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            for (BlockPos pTip : this.tips) {
                ModParticles.spawnParticlesServer(this.field_145850_b, new FlyingBloodParticleData(ModParticles.flying_blood, 60, false, (double)pTip.func_177958_n() + 0.5, (double)pTip.func_177956_o() + 0.3, (double)pTip.func_177952_p() + 0.5), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 3, 0.1, 0.1, 0.1, 0.0);
            }
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        }
        player.func_195064_c(new EffectInstance(Effects.field_76429_m, 450, 10));
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (this.playerToLoadUUID != null) {
            if (!this.loadRitual(this.playerToLoadUUID)) {
                return;
            }
            this.playerToLoadUUID = null;
            this.func_70296_d();
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        }
        if (this.runningTick == 450 && !this.field_145850_b.field_72995_K) {
            LOGGER.debug("Ritual started");
            this.consumeItems();
            this.func_70296_d();
        }
        if (this.runningTick <= 0) {
            return;
        }
        --this.runningTick;
        if (this.player == null || !this.player.func_70089_S()) {
            this.runningTick = 1;
        } else if (this.player.func_213322_ci().field_72448_b >= 0.0) {
            this.player.func_213293_j(0.0, 0.0, 0.0);
        } else {
            this.player.func_213293_j(0.0, this.player.func_213322_ci().field_72448_b, 0.0);
            this.player.func_213317_d(this.player.func_213322_ci().func_216372_d(1.0, 0.5, 1.0));
        }
        PHASE phase = this.getCurrentPhase();
        if (this.field_145850_b.field_72995_K) {
            if (phase.equals((Object)PHASE.PARTICLE_SPREAD) && this.runningTick % 15 == 0) {
                BlockPos pos = this.func_174877_v();
                for (BlockPos pTip : this.tips) {
                    ModParticles.spawnParticlesClient(this.field_145850_b, new FlyingBloodParticleData(ModParticles.flying_blood, 60, false, (double)pTip.func_177958_n() + 0.5, (double)pTip.func_177956_o() + 0.3, (double)pTip.func_177952_p() + 0.5), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, 5, 0.1, new Random());
                }
            }
            if (this.runningTick == 250 && this.getPlayer().func_175144_cb()) {
                VampirismMod.proxy.renderScreenFullColor(200, 50, 0xFF0000);
            }
        }
        if (phase.equals((Object)PHASE.CLEAN_UP)) {
            this.player = null;
            this.tips = null;
            this.func_70296_d();
            this.runningTick = 0;
        }
        if (phase.equals((Object)PHASE.LEVELUP)) {
            if (!this.field_145850_b.field_72995_K) {
                FactionPlayerHandler handler = FactionPlayerHandler.get(this.player);
                if (handler.getCurrentLevel(VReference.VAMPIRE_FACTION) != this.targetLevel - 1) {
                    LOGGER.warn("Player {} changed level while the ritual was running. Cannot levelup.", (Object)this.player);
                    return;
                }
                handler.setFactionLevel(VReference.VAMPIRE_FACTION, handler.getCurrentLevel(VReference.VAMPIRE_FACTION) + 1);
                VampirePlayer.get(this.player).drinkBlood(Integer.MAX_VALUE, 0.0f, false);
                if (this.player instanceof ServerPlayerEntity) {
                    ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((ServerPlayerEntity)this.player, VampireActionTrigger.Action.PERFORM_RITUAL_INFUSION);
                }
            } else {
                this.field_145850_b.func_184134_a(this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f) * 0.7f, true);
                this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_(), 1.0, 0.0, 0.0);
            }
            this.player.func_195064_c(new EffectInstance(ModEffects.saturation, 400, 2));
            this.player.func_195064_c(new EffectInstance(Effects.field_76428_l, 400, 2));
            this.player.func_195064_c(new EffectInstance(Effects.field_76420_g, 400, 2));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT nbt = super.func_189515_b(compound);
        nbt.func_74768_a("tick", this.runningTick);
        if (this.player != null) {
            nbt.func_186854_a("playerUUID", this.player.func_110124_au());
        }
        return nbt;
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new AltarInfusionContainer(id, player, (IInventory)this, this.field_145850_b == null ? IWorldPosCallable.field_221489_a : IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.field_174879_c));
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("tile.vampirism.altar_infusion", new Object[0]);
    }

    private boolean checkItemRequirements(PlayerEntity player, boolean messagePlayer) {
        int newLevel = this.targetLevel;
        VampireLevelingConf.AltarInfusionRequirements requirements = VampireLevelingConf.getInstance().getAltarInfusionRequirements(newLevel);
        ItemStack missing = InventoryHelper.checkItems((IInventory)this, new Item[]{PureBloodItem.getBloodItemForLevel(requirements.pureBloodLevel), ModItems.human_heart, ModItems.vampire_book}, new int[]{requirements.blood, requirements.heart, requirements.vampireBook});
        if (!missing.func_190926_b()) {
            if (messagePlayer) {
                TranslationTextComponent item = missing.func_77973_b() instanceof PureBloodItem ? ((PureBloodItem)missing.func_77973_b()).getCustomName() : new TranslationTextComponent(missing.func_77977_a(), new Object[0]);
                TranslationTextComponent main = new TranslationTextComponent("text.vampirism.altar_infusion.ritual_missing_items", new Object[]{missing.func_190916_E(), item});
                player.func_145747_a((ITextComponent)main);
            }
            return false;
        }
        return true;
    }

    private int checkRequiredLevel() {
        int newLevel = this.targetLevel;
        if (!VampireLevelingConf.getInstance().isLevelValidForAltarInfusion(newLevel)) {
            return -1;
        }
        return VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(newLevel);
    }

    private boolean checkStructureLevel(int required) {
        int i;
        int v;
        if (this.field_145850_b == null) {
            return false;
        }
        BlockPos[] tips = this.findTips();
        ValuedObject[] valuedTips = new ValuedObject[tips.length];
        for (int i2 = 0; i2 < tips.length; ++i2) {
            BlockState temp;
            BlockPos pPos = tips[i2];
            int j = 0;
            AltarPillarBlock.EnumPillarType type = null;
            while ((temp = this.field_145850_b.func_180495_p(pPos.func_177982_a(0, -j - 1, 0))).func_177230_c().equals((Object)ModBlocks.altar_pillar)) {
                AltarPillarBlock.EnumPillarType t = (AltarPillarBlock.EnumPillarType)((Object)temp.func_177229_b(AltarPillarBlock.TYPE_PROPERTY));
                if (type == null) {
                    type = t;
                    ++j;
                    continue;
                }
                if (!type.equals((Object)t)) break;
                ++j;
            }
            int value = (int)((float)(10 * Math.min(j, 3)) * (type == null ? 0.0f : type.getValue()));
            valuedTips[i2] = new ValuedObject<BlockPos>(tips[i2], value);
        }
        Arrays.sort(valuedTips, ValuedObject.getInvertedComparator());
        int found = 0;
        for (i = 0; found < required * 10 && i < valuedTips.length && i < 9 && (v = valuedTips[i].value) != 0; found += v, ++i) {
        }
        valuedTips = Arrays.copyOfRange(valuedTips, 0, i);
        this.tips = ValuedObject.extract(BlockPos.class, valuedTips);
        return found >= required * 10;
    }

    private void consumeItems() {
        VampireLevelingConf.AltarInfusionRequirements requirements = VampireLevelingConf.getInstance().getAltarInfusionRequirements(this.targetLevel);
        InventoryHelper.removeItems((IInventory)this, new int[]{requirements.blood, requirements.heart, requirements.vampireBook});
    }

    private BlockPos[] findTips() {
        if (this.field_145850_b == null) {
            return new BlockPos[0];
        }
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int x = this.func_174877_v().func_177958_n() - 4; x < this.func_174877_v().func_177958_n() + 5; ++x) {
            for (int y = this.func_174877_v().func_177956_o() + 1; y < this.func_174877_v().func_177956_o() + 4; ++y) {
                for (int z = this.func_174877_v().func_177952_p() - 4; z < this.func_174877_v().func_177952_p() + 5; ++z) {
                    if (!this.field_145850_b.func_180495_p((BlockPos)pos.func_181079_c(x, y, z)).func_177230_c().equals((Object)ModBlocks.altar_tip)) continue;
                    list.add(new BlockPos(x, y, z));
                }
            }
        }
        return list.toArray(new BlockPos[0]);
    }

    private boolean loadRitual(UUID playerID) {
        if (this.field_145850_b == null) {
            return false;
        }
        if (this.field_145850_b.func_217369_A().size() == 0) {
            return false;
        }
        this.player = this.field_145850_b.func_217371_b(playerID);
        if (this.player != null && this.player.func_70089_S()) {
            this.targetLevel = VampirePlayer.get(this.player).getLevel() + 1;
            this.checkStructureLevel(this.checkRequiredLevel());
        } else {
            this.runningTick = 0;
            this.tips = null;
            LOGGER.warn("Failed to find player {}", (Object)playerID);
        }
        return true;
    }

    public static enum Result {
        OK,
        ISRUNNING,
        WRONGLEVEL,
        NIGHTONLY,
        STRUCTUREWRONG,
        INVMISSING;

    }

    public static enum PHASE {
        NOT_RUNNING,
        PARTICLE_SPREAD,
        BEAM1,
        BEAM2,
        WAITING,
        LEVELUP,
        ENDING,
        CLEAN_UP;

    }
}

