/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.lib.lib.util.SimpleSpawnerLogic;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.hunter.AdvancedHunterEntity;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TentTileEntity
extends TileEntity
implements ITickableTileEntity {
    private final SimpleSpawnerLogic<BasicHunterEntity> spawnerLogicHunter;
    private final SimpleSpawnerLogic<AdvancedHunterEntity> spawnerLogicAdvancedHunter;
    private boolean spawn = false;
    private boolean advanced = false;

    public TentTileEntity() {
        super(ModTiles.tent);
        this.spawnerLogicHunter = new SimpleSpawnerLogic<BasicHunterEntity>(ModEntities.hunter).setActivateRange(64).setSpawnRange(6).setMinSpawnDelay(600).setMaxSpawnDelay(1000).setMaxNearbyEntities(2).setDailyLimit((Integer)VampirismConfig.BALANCE.hunterTentMaxSpawn.get()).setLimitTotalEntities(VReference.HUNTER_CREATURE_TYPE).setOnSpawned(hunter -> hunter.makeCampHunter(this.field_174879_c));
        this.spawnerLogicAdvancedHunter = new SimpleSpawnerLogic<AdvancedHunterEntity>(ModEntities.advanced_hunter).setActivateRange(64).setSpawnRange(6).setMinSpawnDelay(1200).setMaxSpawnDelay(2000).setMaxNearbyEntities(1).setDailyLimit(1).setLimitTotalEntities(VReference.HUNTER_CREATURE_TYPE).setOnSpawned(hunter -> hunter.makeCampHunter(this.field_174879_c));
    }

    public boolean isSpawner() {
        return this.spawn;
    }

    public boolean func_145842_c(int id, int type) {
        return this.spawnerLogicHunter.setDelayToMin(id) || this.spawnerLogicAdvancedHunter.setDelayToMin(id) || super.func_145842_c(id, type);
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("spawner_logic_1")) {
            this.spawnerLogicHunter.readFromNbt(nbt.func_74775_l("spawner_logic_1"));
        }
        if (nbt.func_74764_b("spawner_logic_2")) {
            this.spawnerLogicAdvancedHunter.readFromNbt(nbt.func_74775_l("spawner_logic_2"));
        }
        if (nbt.func_74764_b("advanced")) {
            this.advanced = nbt.func_74767_n("advanced");
        }
        this.spawn = nbt.func_74767_n("spawn");
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        this.spawnerLogicHunter.setBlockPos(this.field_174879_c);
        this.spawnerLogicAdvancedHunter.setBlockPos(this.field_174879_c);
    }

    public void func_226984_a_(World worldIn, BlockPos pos) {
        super.func_226984_a_(worldIn, pos);
        this.spawnerLogicHunter.setWorld(worldIn);
        this.spawnerLogicAdvancedHunter.setWorld(worldIn);
        this.spawnerLogicHunter.setBlockPos(this.field_174879_c);
        this.spawnerLogicAdvancedHunter.setBlockPos(this.field_174879_c);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (this.spawn) {
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 64L == 0L && Feature.field_214550_p.func_202366_b((IWorld)this.field_145850_b, this.field_174879_c)) {
                this.spawn = false;
            }
            this.spawnerLogicHunter.updateSpawner();
            if (this.advanced) {
                this.spawnerLogicAdvancedHunter.updateSpawner();
            }
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT nbt = super.func_189515_b(compound);
        CompoundNBT logic1 = new CompoundNBT();
        CompoundNBT logic2 = new CompoundNBT();
        this.spawnerLogicHunter.writeToNbt(logic1);
        this.spawnerLogicAdvancedHunter.writeToNbt(logic2);
        nbt.func_218657_a("spawner_logic_1", (INBT)logic1);
        nbt.func_218657_a("spawner_logic_2", (INBT)logic2);
        nbt.func_74757_a("spawn", this.spawn);
        nbt.func_74757_a("advanced", this.advanced);
        return nbt;
    }

    public void setSpawn(boolean spawn) {
        this.spawn = spawn;
    }

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(1.0, 0.0, 1.0);
    }
}

