/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class VampirismWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "vampirism";
    private final List<BlockPos> vampireDungeons = Lists.newLinkedList();

    @Nonnull
    public static VampirismWorldData get(@Nonnull ServerWorld world) {
        return (VampirismWorldData)world.func_217481_x().func_215752_a(() -> new VampirismWorldData(IDENTIFIER), IDENTIFIER);
    }

    public VampirismWorldData(String name) {
        super(name);
    }

    public void addNewVampireDungeon(@Nonnull BlockPos pos) {
        this.vampireDungeons.add(pos);
        this.func_76185_a();
    }

    @Nullable
    public BlockPos getRandomVampireDungeon(Random rng) {
        return this.vampireDungeons.size() == 0 ? null : this.vampireDungeons.get(rng.nextInt(this.vampireDungeons.size()));
    }

    public void onAltarInspirationDestroyed(BlockPos pos) {
        if (this.vampireDungeons.remove(pos)) {
            this.func_76185_a();
        }
    }

    public void func_76184_a(CompoundNBT nbt) {
        if (nbt.func_74764_b("vampire_dungeons")) {
            this.vampireDungeons.clear();
            ListNBT dungeons = nbt.func_150295_c("vampire_dungeons", 10);
            for (int i = 0; i < dungeons.size(); ++i) {
                CompoundNBT tag = dungeons.func_150305_b(i);
                this.vampireDungeons.add(NBTUtil.func_186861_c((CompoundNBT)tag));
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT dungeons = new ListNBT();
        for (BlockPos pos : this.vampireDungeons) {
            dungeons.add((Object)NBTUtil.func_186859_a((BlockPos)pos));
        }
        compound.func_218657_a("vampire_dungeons", (INBT)dungeons);
        return compound;
    }
}

