/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.features;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModFeatures;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.IPlantable;

public class VampirismBiomeFeatures {
    private static final BlockClusterFeatureConfig flowerConfig = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ModBlocks.vampire_orchid.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    private static final TreeFeatureConfig treeConfigSmall = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196618_L.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196645_X.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(2, 0)).func_225569_d_(4).func_227354_b_(2).func_227360_i_(3).func_227352_a_().setSapling((IPlantable)Blocks.field_196675_u).func_225568_b_();
    private static final TreeFeatureConfig treeConfigBig = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196618_L.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196645_X.func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(3, 0)).func_225569_d_(6).func_227354_b_(2).func_227360_i_(5).func_227352_a_().setSapling((IPlantable)Blocks.field_196675_u).func_225568_b_();

    public static void addVampirismFlowers(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227247_y_.func_225566_b_((IFeatureConfig)flowerConfig).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
    }

    public static void addVampireTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Feature.field_202301_A.func_225566_b_((IFeatureConfig)treeConfigSmall).func_227227_a_(0.2f), (Object)Feature.field_202301_A.func_225566_b_((IFeatureConfig)treeConfigBig).func_227227_a_(0.1f)), Feature.field_202301_A.func_225566_b_((IFeatureConfig)treeConfigSmall).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(5, 0.05f, 1))))));
    }

    public static void addHunterTent(Biome biomeIn) {
        biomeIn.func_226711_a_(ModFeatures.hunter_camp.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        if (!((Boolean)VampirismConfig.SERVER.disableHunterTentGen.get()).booleanValue()) {
            biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ModFeatures.hunter_camp.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        }
    }

    public static void addVampireDungeon(Biome biome) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, ModFeatures.vampire_dungeon.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215007_F.func_227446_a_((IPlacementConfig)new ChanceConfig(((Integer)VampirismConfig.BALANCE.vampireDungeonWeight.get()).intValue()))));
    }
}

