/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.RandomRanges;
import net.minecraft.world.storage.loot.conditions.ILootCondition;

public class SetMetaBasedOnLevel
extends LootFunction {
    private final IRandomRange max;
    private final LootContext.EntityTarget target;

    protected SetMetaBasedOnLevel(ILootCondition[] conditions, IRandomRange max, LootContext.EntityTarget targetIn) {
        super(conditions);
        this.max = max;
        this.target = targetIn;
    }

    @Nonnull
    public ItemStack func_215859_a(@Nonnull ItemStack stack, LootContext context) {
        if (context.func_216031_c(this.target.func_216029_a()) instanceof IAdjustableLevel) {
            int l = ((IAdjustableLevel)this.target.func_216029_a()).getLevel();
            int amount = this.max.func_186511_a(context.func_216032_b());
            if (amount != -1) {
                l = Math.min(amount, l);
            }
            stack.func_196085_b(l);
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<SetMetaBasedOnLevel> {
        public Serializer() {
            super(new ResourceLocation("vampirism", "set_meta_from_level"), SetMetaBasedOnLevel.class);
        }

        public void serialize(@Nonnull JsonObject json, SetMetaBasedOnLevel value, @Nonnull JsonSerializationContext context) {
            super.func_186532_a(json, (LootFunction)value, context);
            json.add("max", RandomRanges.func_216131_a((IRandomRange)value.max, (JsonSerializationContext)context));
            json.add("entity", context.serialize((Object)value.target));
        }

        @Nonnull
        public SetMetaBasedOnLevel deserialize(@Nonnull JsonObject jsonObject, @Nonnull JsonDeserializationContext jsonDeserializationContext, @Nonnull ILootCondition[] iLootConditions) {
            IRandomRange range = RandomRanges.func_216130_a((JsonElement)jsonObject.get("max"), (JsonDeserializationContext)jsonDeserializationContext);
            LootContext.EntityTarget target = (LootContext.EntityTarget)jsonDeserializationContext.deserialize(jsonObject.get("entity"), LootContext.EntityTarget.class);
            return new SetMetaBasedOnLevel(iLootConditions, range, target);
        }
    }
}

