/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.entity;

import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.entity.IPlayerEventListener;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.lib.network.RequestPlayerUpdatePacket;
import de.teamlapen.lib.network.UpdateEntityPacket;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EntityEventHandler {
    private final Capability[] listeners;

    public EntityEventHandler(Capability[] listeners) {
        this.listeners = listeners;
    }

    @SubscribeEvent
    public void onChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        for (Capability listener : this.listeners) {
            event.getPlayer().getCapability(listener, null).ifPresent(cap -> ((IPlayerEventListener)cap).onChangedDimension((RegistryKey<World>)event.getFrom(), (RegistryKey<World>)event.getTo()));
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity().func_130014_f_().field_72995_K && event.getEntity() instanceof PlayerEntity && ((PlayerEntity)event.getEntity()).func_175144_cb() && HelperRegistry.getSyncablePlayerCaps().size() > 0) {
            VampLib.dispatcher.sendToServer(new RequestPlayerUpdatePacket());
        }
        if (event.getEntity() instanceof PlayerEntity) {
            for (Capability listener : this.listeners) {
                event.getEntity().getCapability(listener, null).ifPresent(cap -> ((IPlayerEventListener)cap).onJoinWorld());
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            for (Capability listener : this.listeners) {
                boolean cancel = (Boolean)event.getEntity().getCapability(listener, null).map(cap -> ((IPlayerEventListener)cap).onEntityAttacked(event.getSource(), event.getAmount())).orElse((Object)false);
                if (!cancel) continue;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            for (Capability listener : this.listeners) {
                event.getEntity().getCapability(listener, null).ifPresent(cap -> ((IPlayerEventListener)cap).onDeath(event.getSource()));
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            for (Capability listener : this.listeners) {
                event.getEntity().getCapability(listener, null).ifPresent(cap -> ((IPlayerEventListener)cap).onUpdate());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerClone(PlayerEvent.Clone event) {
        for (Capability listener : this.listeners) {
            event.getEntity().getCapability(listener, null).ifPresent(cap -> ((IPlayerEventListener)cap).onPlayerClone(event.getOriginal(), event.isWasDeath()));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        for (Capability listener : this.listeners) {
            event.getPlayer().getCapability(listener, null).ifPresent(cap -> ((IPlayerEventListener)cap).onPlayerLoggedIn());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        for (Capability listener : this.listeners) {
            event.getPlayer().getCapability(listener, null).ifPresent(cap -> ((IPlayerEventListener)cap).onPlayerLoggedOut());
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        for (Capability listener : this.listeners) {
            event.player.getCapability(listener, null).ifPresent(cap -> ((IPlayerEventListener)cap).onUpdatePlayer(event.phase));
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        UpdateEntityPacket packet;
        if ((event.getTarget() instanceof CreatureEntity && HelperRegistry.getSyncableEntityCaps().size() > 0 || event.getTarget() instanceof ISyncable || event.getTarget() instanceof PlayerEntity && HelperRegistry.getSyncablePlayerCaps().size() > 0) && (packet = UpdateEntityPacket.createJoinWorldPacket(event.getTarget())) != null) {
            VampLib.dispatcher.sendTo(packet, (ServerPlayerEntity)event.getPlayer());
        }
    }
}

