/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.lib.lib.util.UtilLib;
import java.awt.Color;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ForgeIngameGui;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public abstract class GuiPieMenu<T>
extends Screen {
    private static final ResourceLocation backgroundTex = new ResourceLocation("teamlapenlib", "textures/gui/pie_menu_bg.png");
    private static final ResourceLocation centerTex = new ResourceLocation("teamlapenlib", "textures/gui/pie_menu_center.png");
    private static final ResourceLocation WIDGETS = new ResourceLocation("textures/gui/widgets.png");
    protected final ArrayList<T> elements;
    protected final Color backgroundColor;
    private final float BGT = 0.7f;
    private final int BGS = 300;
    private final int RR = 60;
    private final int CS = 100;
    private int selectedElement = -1;
    private int elementCount;
    private double radDiff;

    public GuiPieMenu(Color backgroundColorIn, ITextComponent title) {
        super(title);
        this.field_230711_n_ = true;
        this.backgroundColor = backgroundColorIn;
        this.elements = new ArrayList();
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        boolean center;
        int cX = this.field_230708_k_ / 2;
        int cY = this.field_230709_l_ / 2;
        double radius = (double)this.field_230709_l_ / 4.0;
        this.drawBackground(stack, cX, cY);
        double mouseRad = this.updateMouse(mouseX, mouseY, cX, cY, radius / 2.0);
        boolean bl = center = (double)((mouseX - cX) * (mouseX - cX) + (mouseY - cY) * (mouseY - cY)) < radius / 4.0 * (radius / 4.0);
        if (center) {
            this.selectedElement = -1;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            T element = this.elements.get(i);
            double rad = this.radDiff * (double)i;
            boolean selected = false;
            if (!center && mouseRad > rad - this.radDiff / 2.0 && mouseRad < rad + this.radDiff / 2.0) {
                selected = true;
            } else if (!center && rad == 0.0 && mouseRad > Math.PI * 2 - this.radDiff / 2.0) {
                selected = true;
            }
            int x = (int)((double)cX + Math.cos(rad) * radius) - 8;
            int y = (int)((double)cY - Math.sin(rad) * radius) - 8;
            Color col = this.getColor(element);
            RenderSystem.color4f((float)col.getRed(), (float)col.getGreen(), (float)col.getBlue(), (float)0.5f);
            this.field_230706_i_.func_110434_K().func_110577_a(WIDGETS);
            this.func_238474_b_(stack, x - 2, y - 2, 1, 1, 20, 20);
            if (selected) {
                this.func_238474_b_(stack, x - 3, y - 3, 1, 23, 22, 22);
            }
            if (selected) {
                this.selectedElement = i;
                this.drawSelectedCenter(stack, cX, cY, rad);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_230706_i_.func_110434_K().func_110577_a(this.getIconLoc(element));
            UtilLib.drawTexturedModalRect(stack.func_227866_c_().func_227870_a_(), this.func_230927_p_(), x, y, 0, 0, 16, 16, 16, 16);
            this.afterIconDraw(stack, element, x, y);
        }
        if (this.selectedElement == -1) {
            this.drawUnselectedCenter(stack, cX, cY);
        } else {
            String name = UtilLib.translate(this.getUnlocalizedName(this.elements.get(this.selectedElement)), new Object[0]);
            int tx = cX - this.field_230706_i_.field_71466_p.func_78256_a(name) / 2;
            int ty = this.field_230709_l_ / 7;
            this.field_230706_i_.field_71466_p.func_238405_a_(stack, name, (float)tx, (float)ty, Color.WHITE.getRGB());
        }
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.field_230706_i_ != null && this.field_230706_i_.field_71439_g != null) {
            if (!this.field_230706_i_.field_71439_g.func_70089_S()) {
                this.field_230706_i_.field_71439_g.func_71053_j();
            } else {
                this.field_230706_i_.field_71439_g.field_71158_b.func_225607_a_(this.field_230706_i_.field_71439_g.func_228354_I_());
            }
        }
    }

    public boolean func_223281_a_(int key, int scancode, int modifiers) {
        if (!this.isKeyBindingStillPressed()) {
            this.selectedAndClose();
            return true;
        }
        return false;
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        return false;
    }

    public boolean func_231048_c_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        if (!this.isKeyBindingStillPressed()) {
            this.selectedAndClose();
            return true;
        }
        return false;
    }

    public void func_231160_c_() {
        this.onGuiInit();
        this.elementCount = this.elements.size();
        this.radDiff = Math.PI * 2 / (double)this.elementCount;
        GLFW.glfwSetInputMode((long)this.field_230706_i_.func_228018_at_().func_198092_i(), (int)208897, (int)212994);
        ForgeIngameGui.renderCrosshairs = false;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        GLFW.glfwSetInputMode((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)208897, (int)212993);
        ForgeIngameGui.renderCrosshairs = true;
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        ForgeIngameGui.renderCrosshairs = true;
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected boolean isKeyBindingStillPressed() {
        return this.getMenuKeyBinding().func_151470_d();
    }

    protected void afterIconDraw(MatrixStack stack, T element, int x, int y) {
    }

    protected void drawLine(MatrixStack stack, double x1, double y1, double x2, double y2) {
        RenderSystem.disableTexture();
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        builder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        RenderSystem.lineWidth((float)2.0f);
        builder.func_227888_a_(stack.func_227866_c_().func_227870_a_(), (float)x1, (float)y1, (float)this.func_230927_p_()).func_225586_a_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).func_181675_d();
        builder.func_227888_a_(stack.func_227866_c_().func_227870_a_(), (float)x2, (float)y2, (float)this.func_230927_p_()).func_225586_a_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
    }

    @Nonnull
    protected Color getColor(T s) {
        return Color.WHITE;
    }

    protected abstract ResourceLocation getIconLoc(T var1);

    protected abstract KeyBinding getMenuKeyBinding();

    protected void selectedAndClose() {
        this.func_231175_as__();
        if (this.selectedElement >= 0) {
            this.onElementSelected(this.elements.get(this.selectedElement));
        }
    }

    protected int getSelectedElement() {
        return this.selectedElement;
    }

    protected abstract String getUnlocalizedName(T var1);

    protected void onElementSelected(T id) {
    }

    protected abstract void onGuiInit();

    private void drawBackground(MatrixStack stack, float cX, float cY) {
        float scale = ((float)this.field_230709_l_ / 2.0f + 16.0f + 16.0f) / 300.0f;
        stack.func_227860_a_();
        RenderSystem.enableBlend();
        stack.func_227861_a_((double)cX, (double)cY, (double)this.func_230927_p_());
        stack.func_227862_a_(scale, scale, 1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(backgroundTex);
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        builder.func_227888_a_(matrix, 150.0f, 150.0f, (float)this.func_230927_p_()).func_225586_a_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).func_225583_a_(1.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix, 150.0f, -150.0f, (float)this.func_230927_p_()).func_225586_a_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).func_225583_a_(1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix, -150.0f, -150.0f, (float)this.func_230927_p_()).func_225586_a_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).func_225583_a_(0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix, -150.0f, 150.0f, (float)this.func_230927_p_()).func_225586_a_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).func_225583_a_(0.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        if (this.elementCount > 1) {
            for (int i = 0; i < this.elementCount; ++i) {
                double rad = (double)i * this.radDiff + this.radDiff / 2.0;
                double cos = Math.cos(rad);
                double sin = Math.sin(rad);
                this.drawLine(stack, cos * 60.0, sin * 60.0, cos * 300.0 / 2.0, sin * 300.0 / 2.0);
            }
        }
        RenderSystem.disableBlend();
        stack.func_227865_b_();
    }

    private void drawSelectedCenter(MatrixStack stack, double cX, double cY, double rad) {
        double deg = Math.toDegrees(-rad);
        float scale = (float)this.field_230709_l_ / 4.0f / 100.0f;
        stack.func_227860_a_();
        RenderSystem.enableBlend();
        stack.func_227861_a_(cX, cY, (double)this.func_230927_p_());
        stack.func_227862_a_(scale, scale, 1.0f);
        stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)deg));
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        this.field_230706_i_.func_110434_K().func_110577_a(centerTex);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        builder.func_227888_a_(matrix, 50.0f, 50.0f, (float)this.func_230927_p_()).func_225586_a_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).func_225583_a_(0.5f, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix, 50.0f, -50.0f, (float)this.func_230927_p_()).func_225586_a_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).func_225583_a_(0.5f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix, -50.0f, -50.0f, (float)this.func_230927_p_()).func_225586_a_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).func_225583_a_(0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix, -50.0f, 50.0f, (float)this.func_230927_p_()).func_225586_a_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).func_225583_a_(0.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableBlend();
        stack.func_227865_b_();
    }

    private void drawUnselectedCenter(MatrixStack stack, double cX, double cY) {
        float scale = (float)this.field_230709_l_ / 4.0f / 100.0f;
        stack.func_227860_a_();
        RenderSystem.enableBlend();
        stack.func_227861_a_(cX, cY, (double)this.func_230927_p_());
        stack.func_227862_a_(scale, scale, 1.0f);
        Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
        this.field_230706_i_.func_110434_K().func_110577_a(centerTex);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        builder.func_227888_a_(matrix, 50.0f, 50.0f, (float)this.func_230927_p_()).func_225586_a_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).func_225583_a_(1.0f, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix, 50.0f, -50.0f, (float)this.func_230927_p_()).func_225586_a_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).func_225583_a_(1.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix, -50.0f, -50.0f, (float)this.func_230927_p_()).func_225586_a_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).func_225583_a_(0.5f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix, -50.0f, 50.0f, (float)this.func_230927_p_()).func_225586_a_(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), 178).func_225583_a_(0.5f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableBlend();
        stack.func_227865_b_();
    }

    private void setAbsoluteMouse(double x, double y) {
        x = x * (double)this.field_230706_i_.func_228018_at_().func_198109_k() / (double)this.field_230708_k_;
        y = -(y + 1.0 - (double)this.field_230709_l_) * (double)this.field_230706_i_.func_228018_at_().func_198091_l() / (double)this.field_230709_l_;
        GLFW.glfwSetCursorPos((long)this.field_230706_i_.func_228018_at_().func_198092_i(), (double)x, (double)y);
    }

    private double updateMouse(int x, int y, int cX, int cY, double r) {
        int dx = x - cX;
        int dy = y - cY;
        double rad = Math.atan2(dy, -dx) + Math.PI;
        if ((double)Math.abs(dx) > Math.abs(Math.cos(rad) * r) + 8.0 || (double)Math.abs(dy) > Math.abs(Math.sin(rad) * r) + 8.0) {
            this.setAbsoluteMouse((double)dx / 1.5 + (double)cX + 4.0, (double)cY - (double)dy / 1.5);
        }
        return rad;
    }
}

