/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.teamlapen.lib.lib.config.BloodValueLoader;
import de.teamlapen.lib.lib.util.LogUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.FolderName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BloodValueLoaderDynamic
extends BloodValueLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<BloodValueLoaderDynamic> LOADER = Lists.newArrayList();
    @Nullable
    private static File bloodValueWorldFile;
    private final Consumer<Map<ResourceLocation, Integer>> addCalculatedValues;
    private final Supplier<Map<ResourceLocation, Integer>> getCalculatedValues;
    private final String name;
    private final String modId;
    private final FolderName worldSubFolder;

    public BloodValueLoaderDynamic(@Nonnull String modIdIn, @Nonnull String nameIn, @Nonnull BiConsumer<Map<ResourceLocation, Integer>, Integer> consumerIn, @Nullable ResourceLocation multiplierNameIn, @Nonnull Consumer<Map<ResourceLocation, Integer>> addCalculatedValuesIn, @Nonnull Supplier<Map<ResourceLocation, Integer>> getCalculatedValuesIn) {
        super(nameIn, consumerIn, multiplierNameIn);
        this.addCalculatedValues = addCalculatedValuesIn;
        this.getCalculatedValues = getCalculatedValuesIn;
        this.name = nameIn;
        this.modId = modIdIn;
        this.worldSubFolder = new FolderName(this.modId);
        LOADER.add(this);
    }

    public void onServerStarting(MinecraftServer server) {
        bloodValueWorldFile = new File(server.func_240776_a_(this.worldSubFolder).toFile(), "calculated-" + this.name + "-blood-values.txt");
        if (bloodValueWorldFile.exists()) {
            this.loadDynamicBloodValues(bloodValueWorldFile);
        }
    }

    public void onServerStopping() {
        if (bloodValueWorldFile != null) {
            this.saveDynamicBloodValues(bloodValueWorldFile);
        } else {
            LOGGER.warn("Can't save {} blood values. File does not exist", (Object)this.name);
        }
    }

    private void loadDynamicBloodValues(File f) {
        try {
            Map<ResourceLocation, Integer> saved = this.loadBloodValuesFromReader(new InputStreamReader(new FileInputStream(f)), f.getName());
            this.addCalculatedValues.accept(saved);
        }
        catch (IOException e) {
            LOGGER.error(LogUtil.CONFIG, "[ModCompat]Could not read saved {} blood values from world from file {} {}", (Object)this.name, (Object)f, (Object)e);
        }
    }

    private void saveDynamicBloodValues(File f) {
        Map<ResourceLocation, Integer> values = this.getCalculatedValues.get();
        if (!f.exists() && values.isEmpty()) {
            return;
        }
        if (!f.exists() && f.getParentFile() != null) {
            f.getParentFile().mkdirs();
        }
        try {
            if (!BloodValueLoaderDynamic.writeBloodValues(new FileWriter(f), values, "Dynamically calculated blood values - DON'T EDIT")) {
                LOGGER.warn(LogUtil.CONFIG, "Could not write calculated {} values to file", (Object)this.name);
            }
        }
        catch (IOException e) {
            LOGGER.error(LogUtil.CONFIG, "Failed to write calculated blood values to file", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeBloodValues(Writer w, Map<ResourceLocation, Integer> values, String comment) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(w);
            bw.write(35);
            bw.write(comment);
            bw.newLine();
            for (Map.Entry<ResourceLocation, Integer> entry : values.entrySet()) {
                bw.write(entry.getKey().toString());
                bw.write(61);
                bw.write(String.valueOf(entry.getValue()));
                bw.newLine();
            }
            bw.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error(LogUtil.CONFIG, "Failed to write blood values", (Throwable)e);
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            w.close();
        }
        return false;
    }

    public static List<BloodValueLoaderDynamic> getDynamicBloodLoader() {
        return ImmutableList.copyOf(LOADER);
    }
}

