/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.inventory;

import com.mojang.datafixers.util.Either;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IWorldPosCallable;

public abstract class InventoryContainer
extends Container {
    protected final IWorldPosCallable worldPos;
    protected final IInventory inventory;
    private final int size;

    public InventoryContainer(ContainerType<? extends InventoryContainer> containerType, int id, PlayerInventory playerInventory, IWorldPosCallable worldPos, @Nonnull IInventory inventory, SelectorInfo ... selectorInfos) {
        this(containerType, id, worldPos, inventory, selectorInfos.length);
        if (inventory.func_70302_i_() < selectorInfos.length) {
            throw new IllegalArgumentException("Inventory size smaller than selector infos");
        }
        inventory.func_174889_b(playerInventory.field_70458_d);
        for (int i = 0; i < selectorInfos.length; ++i) {
            this.func_75146_a(new SelectorSlot(inventory, i, selectorInfos[i]){

                public void func_75220_a(@Nonnull ItemStack p_75220_1_, @Nonnull ItemStack p_75220_2_) {
                    super.func_75220_a(p_75220_1_, p_75220_2_);
                    InventoryContainer.this.func_75130_a(this.field_75224_c);
                }
            });
        }
    }

    private InventoryContainer(ContainerType<? extends InventoryContainer> containerType, int id, IWorldPosCallable worldPos, IInventory inventory, int size) {
        super(containerType, id);
        this.worldPos = worldPos;
        this.inventory = inventory;
        this.size = size;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.inventory.func_174886_c(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerEntity, int index) {
        ItemStack result = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            result = slotStack.func_77946_l();
            if (index >= this.size && index < 27 + this.size ? !this.func_75135_a(slotStack, 27 + this.size, 36 + this.size, false) : index >= 27 + this.size && index < 36 + this.size && !this.func_75135_a(slotStack, this.size, 27 + this.size, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == result.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerEntity, slotStack);
        }
        return result;
    }

    protected void addPlayerSlots(PlayerInventory playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public static class SelectorInfo {
        public final Either<Ingredient, Function<ItemStack, Boolean>> ingredient;
        public final int xDisplay;
        public final int yDisplay;
        public final int stackLimit;
        public final boolean inverted;

        public SelectorInfo(Either<Ingredient, Function<ItemStack, Boolean>> ingredient, int x, int y, boolean inverted, int limit) {
            this.ingredient = ingredient;
            this.xDisplay = x;
            this.yDisplay = y;
            this.stackLimit = limit;
            this.inverted = inverted;
        }

        public SelectorInfo(Ingredient ingredient, int x, int y) {
            this(ingredient, x, y, false);
        }

        public SelectorInfo(Ingredient ingredient, int x, int y, boolean inverted) {
            this(ingredient, x, y, inverted, 64);
        }

        public SelectorInfo(Ingredient ingredient, int x, int y, boolean inverted, int stackLimit) {
            this((Either<Ingredient, Function<ItemStack, Boolean>>)Either.left((Object)ingredient), x, y, inverted, stackLimit);
        }

        public SelectorInfo(Ingredient ingredient, int x, int y, int stackLimit) {
            this((Either<Ingredient, Function<ItemStack, Boolean>>)Either.left((Object)ingredient), x, y, false, stackLimit);
        }

        public SelectorInfo(Function<ItemStack, Boolean> ingredient, int x, int y) {
            this(ingredient, x, y, false);
        }

        public SelectorInfo(Function<ItemStack, Boolean> ingredient, int x, int y, boolean inverted) {
            this(ingredient, x, y, inverted, 64);
        }

        public SelectorInfo(Function<ItemStack, Boolean> ingredient, int x, int y, boolean inverted, int stackLimit) {
            this((Either<Ingredient, Function<ItemStack, Boolean>>)Either.right(ingredient), x, y, inverted, stackLimit);
        }

        public SelectorInfo(Function<ItemStack, Boolean> ingredient, int x, int y, int stackLimit) {
            this((Either<Ingredient, Function<ItemStack, Boolean>>)Either.right(ingredient), x, y, false, stackLimit);
        }

        public boolean validate(ItemStack s) {
            boolean result = (Boolean)this.ingredient.map(ingredient -> ingredient.test(s) || ingredient.func_203189_d(), function -> (Boolean)function.apply(s));
            return result != this.inverted;
        }
    }

    public static class SelectorSlot
    extends Slot {
        private final SelectorInfo info;

        public SelectorSlot(IInventory inventoryIn, int index, SelectorInfo info) {
            super(inventoryIn, index, info.xDisplay, info.yDisplay);
            this.info = info;
        }

        public int func_178170_b(ItemStack stack) {
            return this.info.stackLimit;
        }

        public boolean func_75214_a(ItemStack stack) {
            return this.info.validate(stack);
        }
    }
}

