/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.tile;

import de.teamlapen.lib.lib.inventory.InventoryContainer;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class InventoryTileEntity
extends LockableTileEntity
implements INamedContainerProvider {
    protected final int MAX_DIST_SQRT = 64;
    protected NonNullList<ItemStack> inventorySlots;
    protected InventoryContainer.SelectorInfo[] selectors;

    public InventoryTileEntity(TileEntityType<?> tileEntityTypeIn, int size, InventoryContainer.SelectorInfo ... selectorInfos) {
        super(tileEntityTypeIn);
        this.inventorySlots = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        if (selectorInfos.length != size) {
            throw new IllegalArgumentException("Selector count must match inventory size");
        }
        this.selectors = selectorInfos;
    }

    public void func_174888_l() {
        this.inventorySlots.clear();
    }

    public ItemStack func_70298_a(int slot, int amt) {
        return ItemStackHelper.func_188382_a(this.inventorySlots, (int)slot, (int)amt);
    }

    public int func_70302_i_() {
        return this.inventorySlots.size();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventorySlots.get(index);
    }

    public boolean func_191420_l() {
        return this.inventorySlots.isEmpty();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.selectors.length) {
            return false;
        }
        return this.selectors[slot].validate(stack);
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_230337_a_(BlockState state, CompoundNBT tagCompound) {
        super.func_230337_a_(state, tagCompound);
        this.inventorySlots.clear();
        ItemStackHelper.func_191283_b((CompoundNBT)tagCompound, this.inventorySlots);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventorySlots, (int)index);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventorySlots.set(slot, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventorySlots);
        return compound;
    }

    @Nonnull
    protected InvWrapper createWrapper() {
        return new SelectorInvWrapper((IInventory)this);
    }

    protected boolean isFull() {
        for (ItemStack s : this.inventorySlots) {
            if (!s.func_190926_b() && s.func_190916_E() >= s.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private class SelectorInvWrapper
    extends InvWrapper {
        SelectorInvWrapper(IInventory inv) {
            super(inv);
        }

        public int getSlotLimit(int slot) {
            return slot < 0 || slot >= InventoryTileEntity.this.selectors.length ? 0 : InventoryTileEntity.this.selectors[slot].stackLimit;
        }
    }
}

