/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import de.teamlapen.lib.lib.util.UtilLib;
import java.util.Collections;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleSpawnerLogic<T extends Entity> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MOB_COUNT_DIV = (int)Math.pow(17.0, 2.0);
    @Nonnull
    private final EntityType<T> entityType;
    @Nullable
    private BlockPos pos;
    @Nullable
    private World world;
    @Nullable
    private Consumer<T> onSpawned;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int activateRange = 16;
    private int dailyLimit = Integer.MAX_VALUE;
    private int spawnCount = 1;
    private int maxNearbyEntities = 4;
    private int spawnRange = 4;
    private int spawnDelay = 20;
    private int spawnedToday = 0;
    private long spawnedLast = 0L;
    private boolean flag = true;
    private EntityClassification limitType;

    public SimpleSpawnerLogic(@Nonnull EntityType<T> entityTypeIn) {
        this.entityType = entityTypeIn;
    }

    @Nonnull
    public EntityType<T> getEntityType() {
        return this.entityType;
    }

    public int getSpawnedToday() {
        return this.spawnedToday;
    }

    public boolean isActivated() {
        if (this.world == null) {
            return false;
        }
        if (this.pos == null) {
            return false;
        }
        return this.world.func_217358_a((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5, (double)this.activateRange);
    }

    public void readFromNbt(CompoundNBT nbt) {
        this.spawnDelay = nbt.func_74762_e("delay");
        this.spawnedToday = nbt.func_74762_e("spawned_today");
        this.spawnedLast = nbt.func_74763_f("spawned_last");
        this.flag = nbt.func_74767_n("spawner_flag");
    }

    public boolean setDelayToMin(int id) {
        if (id == 1 && this.world.field_72995_K) {
            this.spawnDelay = this.minSpawnDelay;
            return true;
        }
        return false;
    }

    public void setWorld(World worldIn) {
        this.world = worldIn;
    }

    public void setBlockPos(BlockPos blockPosIn) {
        this.pos = blockPosIn;
    }

    public SimpleSpawnerLogic<T> setLimitTotalEntities(EntityClassification creatureType) {
        this.limitType = creatureType;
        return this;
    }

    public SimpleSpawnerLogic<T> setMaxNearbyEntities(int maxNearbyEntities) {
        this.maxNearbyEntities = maxNearbyEntities;
        return this;
    }

    public SimpleSpawnerLogic<T> setMaxSpawnDelay(int maxSpawnDelay) {
        this.maxSpawnDelay = maxSpawnDelay;
        return this;
    }

    public SimpleSpawnerLogic<T> setMinSpawnDelay(int minSpawnDelay) {
        this.minSpawnDelay = minSpawnDelay;
        return this;
    }

    public SimpleSpawnerLogic<T> setSpawn(boolean spawn) {
        this.flag = spawn;
        return this;
    }

    public SimpleSpawnerLogic<T> setSpawnCount(int spawnCount) {
        this.spawnCount = spawnCount;
        return this;
    }

    public SimpleSpawnerLogic<T> setDailyLimit(int dailyLimit) {
        this.dailyLimit = dailyLimit;
        return this;
    }

    public SimpleSpawnerLogic<T> setSpawnRange(int spawnRange) {
        this.spawnRange = spawnRange;
        return this;
    }

    public SimpleSpawnerLogic<T> setActivateRange(int activateRange) {
        this.activateRange = activateRange;
        return this;
    }

    public SimpleSpawnerLogic<T> setOnSpawned(Consumer<T> onSpawned) {
        this.onSpawned = onSpawned;
        return this;
    }

    public void updateSpawner() {
        if (this.isActivated() && !this.world.field_72995_K) {
            Entity entity;
            if (this.spawnDelay == -1) {
                this.resetTimer();
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
                return;
            }
            if (this.world.func_82737_E() % 24000L < this.spawnedLast) {
                this.spawnedToday = 0;
                this.flag = true;
            } else if (this.spawnedToday >= this.dailyLimit) {
                this.flag = false;
            }
            if (!this.flag) {
                return;
            }
            boolean flag1 = false;
            for (int i = 0; i < this.spawnCount && (entity = this.getEntityType().func_200721_a(this.world)) != null; ++i) {
                int j = this.world.func_217357_a(entity.getClass(), this.getSpawningBox()).size();
                if (j >= this.maxNearbyEntities) {
                    this.resetTimer();
                    break;
                }
                if (this.limitType != null) {
                    WorldEntitySpawner.EntityDensityManager densityManager = ((ServerWorld)this.world).func_72863_F().func_241101_k_();
                    if (densityManager.func_234991_a_(this.limitType)) break;
                    this.resetTimer();
                    break;
                }
                if (!UtilLib.spawnEntityInWorld(this.world, this.getSpawningBox(), entity, 1, Collections.emptyList(), SpawnReason.SPAWNER)) continue;
                this.onSpawned(entity);
                flag1 = true;
            }
            if (flag1) {
                this.resetTimer();
                ++this.spawnedToday;
                this.spawnedLast = this.world.func_82737_E() % 24000L;
            }
        }
    }

    public void writeToNbt(CompoundNBT nbt) {
        nbt.func_74768_a("delay", this.spawnDelay);
        nbt.func_74768_a("spawned_today", this.spawnedToday);
        nbt.func_74772_a("spawned_last", this.spawnedLast);
        nbt.func_74757_a("spawner_flag", this.flag);
    }

    protected AxisAlignedBB getSpawningBox() {
        return new AxisAlignedBB((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p(), (double)(this.pos.func_177958_n() + 1), (double)(this.pos.func_177956_o() + 1), (double)(this.pos.func_177952_p() + 1)).func_72314_b((double)this.spawnRange, (double)this.spawnRange, (double)this.spawnRange);
    }

    protected void onSpawned(T e) {
        if (e instanceof MobEntity) {
            ((MobEntity)e).func_70656_aK();
        }
        if (this.onSpawned != null) {
            this.onSpawned.accept(e);
        }
    }

    private void resetTimer() {
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            this.spawnDelay = this.minSpawnDelay;
        } else {
            int i = this.maxSpawnDelay - this.minSpawnDelay;
            this.spawnDelay = this.minSpawnDelay + this.world.field_73012_v.nextInt(i);
        }
    }
}

