/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.ForgeI18n;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UtilLib {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern oldFormatPattern = Pattern.compile("%[sd]");

    public static String entityToString(Entity e) {
        if (e == null) {
            return "Entity is null";
        }
        return e.toString();
    }

    public static boolean doesBlockHaveSolidTopSurface(World worldIn, BlockPos pos) {
        return Block.func_220056_d((BlockState)worldIn.func_180495_p(pos), (IBlockReader)worldIn, (BlockPos)pos, (Direction)Direction.UP);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawTexturedModalRect(Matrix4f matrix, float zLevel, int x, int y, int textureX, int textureY, int width, int height, int texWidth, int texHeight) {
        float f = 1.0f / (float)texWidth;
        float f1 = 1.0f / (float)texHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_227888_a_(matrix, (float)x, (float)(y + height), zLevel).func_225583_a_((float)textureX * f, (float)(textureY + height) * f1).func_181675_d();
        vertexbuffer.func_227888_a_(matrix, (float)(x + width), (float)(y + height), zLevel).func_225583_a_((float)(textureX + width) * f, (float)(textureY + height) * f1).func_181675_d();
        vertexbuffer.func_227888_a_(matrix, (float)(x + width), (float)y, zLevel).func_225583_a_((float)(textureX + width) * f, (float)textureY * f1).func_181675_d();
        vertexbuffer.func_227888_a_(matrix, (float)x, (float)y, zLevel).func_225583_a_((float)textureX * f, (float)textureY * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static RayTraceResult getPlayerLookingSpot(PlayerEntity player, double restriction) {
        float scale = 1.0f;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * scale;
        float yaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * scale;
        double x = player.field_70169_q + (player.func_226277_ct_() - player.field_70169_q) * (double)scale;
        double y = player.field_70167_r + (player.func_226278_cu_() - player.field_70167_r) * (double)scale + 1.62;
        double z = player.field_70166_s + (player.func_226281_cx_() - player.field_70166_s) * (double)scale;
        Vector3d vector1 = new Vector3d(x, y, z);
        float cosYaw = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float cosPitch = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float sinPitch = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float pitchAdjustedSinYaw = sinYaw * cosPitch;
        float pitchAdjustedCosYaw = cosYaw * cosPitch;
        double distance = 500.0;
        if (restriction == 0.0 && player instanceof ServerPlayerEntity) {
            distance = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() - 0.5;
        } else if (restriction > 0.0) {
            distance = restriction;
        }
        Vector3d vector2 = vector1.func_72441_c((double)pitchAdjustedSinYaw * distance, (double)sinPitch * distance, (double)pitchAdjustedCosYaw * distance);
        return player.func_130014_f_().func_217299_a(new RayTraceContext(vector1, vector2, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player));
    }

    public static BlockPos getRandomPosInBox(World w, AxisAlignedBB box) {
        int x = (int)box.field_72340_a + w.field_73012_v.nextInt((int)(box.field_72336_d - box.field_72340_a) + 1);
        int z = (int)box.field_72339_c + w.field_73012_v.nextInt((int)(box.field_72334_f - box.field_72339_c) + 1);
        int y = w.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z) + 5;
        BlockPos.Mutable pos = new BlockPos.Mutable(x, y, z);
        while ((double)y > box.field_72338_b && !w.func_180495_p((BlockPos)pos).func_215686_e((IBlockReader)w, (BlockPos)pos)) {
            pos.func_181079_c(x, --y, z);
        }
        if ((double)y < box.field_72338_b || (double)y > box.field_72337_e - 1.0) {
            pos.func_181079_c(x, (int)box.field_72338_b + w.field_73012_v.nextInt((int)(box.field_72337_e - box.field_72338_b) + 1), z);
        }
        return pos.func_177984_a();
    }

    public static int countPlayerLoadedChunks(World world) {
        ArrayList chunks = Lists.newArrayList();
        int i = 0;
        for (PlayerEntity entityplayer : world.func_217369_A()) {
            if (entityplayer.func_175149_v()) continue;
            int x = MathHelper.func_76128_c((double)(entityplayer.func_226277_ct_() / 16.0));
            int z = MathHelper.func_76128_c((double)(entityplayer.func_226281_cx_() / 16.0));
            for (int dx = -8; dx <= 8; ++dx) {
                for (int dz = -8; dz <= 8; ++dz) {
                    ChunkPos chunkpos = new ChunkPos(dx + x, dz + z);
                    if (chunks.contains(chunkpos)) continue;
                    ++i;
                    chunks.add(chunkpos);
                }
            }
        }
        return i;
    }

    @Nonnull
    public static Vector3d getItemPosition(LivingEntity entity, boolean mainHand) {
        boolean left = (mainHand ? entity.func_184591_cq() : entity.func_184591_cq().func_188468_a()) == HandSide.LEFT;
        boolean firstPerson = entity instanceof PlayerEntity && ((PlayerEntity)entity).func_175144_cb() && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
        Vector3d dir = firstPerson ? entity.func_189651_aD() : Vector3d.func_189984_a((Vector2f)new Vector2f(entity.field_70125_A, entity.field_70761_aq));
        dir = dir.func_178785_b(0.62831855f * (left ? 1.0f : -1.0f)).func_186678_a(0.75);
        return dir.func_72441_c(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
    }

    public static <T extends MobEntity> Entity spawnEntityBehindEntity(LivingEntity entity, EntityType<T> toSpawn, SpawnReason reason) {
        BlockPos behind = UtilLib.getPositionBehindEntity(entity, 2.0f);
        MobEntity e = (MobEntity)toSpawn.func_200721_a(entity.func_130014_f_());
        e.func_70107_b((double)behind.func_177958_n(), entity.func_226278_cu_(), (double)behind.func_177952_p());
        if (e.func_213380_a((IWorld)entity.func_130014_f_(), reason) && e.func_205019_a((IWorldReader)entity.func_130014_f_())) {
            entity.func_130014_f_().func_217376_c((Entity)e);
            return e;
        }
        int y = entity.func_130014_f_().func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, behind).func_177956_o();
        e.func_70107_b((double)behind.func_177958_n(), (double)y, (double)behind.func_177952_p());
        if (e.func_213380_a((IWorld)entity.func_130014_f_(), reason) && e.func_205019_a((IWorldReader)entity.func_130014_f_())) {
            entity.func_130014_f_().func_217376_c((Entity)e);
            UtilLib.onInitialSpawn((Entity)e, reason);
            return e;
        }
        e.func_70106_y();
        return null;
    }

    private static void onInitialSpawn(Entity e, SpawnReason reason) {
        if (e instanceof MobEntity) {
            ((MobEntity)e).func_213386_a((IWorld)e.func_130014_f_(), e.func_130014_f_().func_175649_E(e.func_233580_cy_()), reason, null, null);
        }
    }

    public static BlockPos getPositionBehindEntity(LivingEntity p, float distance) {
        float yaw = p.field_70759_as;
        float cosYaw = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        double x = p.func_226277_ct_() + (double)(sinYaw * distance);
        double z = p.func_226281_cx_() + (double)(cosYaw * distance);
        return new BlockPos(x, p.func_226278_cu_(), z);
    }

    public static boolean spawnEntityInWorld(World world, AxisAlignedBB box, Entity e, int maxTry, @Nonnull List<? extends LivingEntity> avoidedEntities, SpawnReason reason) {
        if (!world.func_217344_a((int)box.field_72340_a, (int)box.field_72338_b, (int)box.field_72339_c, (int)box.field_72336_d, (int)box.field_72337_e, (int)box.field_72334_f)) {
            return false;
        }
        boolean flag = false;
        int i = 0;
        BlockPos backupPos = null;
        while (!flag && i++ < maxTry) {
            BlockPos c = UtilLib.getRandomPosInBox(world, box);
            if (!world.isAreaLoaded(c, 5) || !WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.func_209344_a((EntityType)e.func_200600_R()), (IWorldReader)world, (BlockPos)c, (EntityType)e.func_200600_R())) continue;
            e.func_70107_b((double)c.func_177958_n(), (double)c.func_177956_o() + 0.2, (double)c.func_177952_p());
            if (e instanceof MobEntity && (!((MobEntity)e).func_213380_a((IWorld)world, reason) || !((MobEntity)e).func_205019_a((IWorldReader)e.func_130014_f_()))) continue;
            backupPos = c;
            for (LivingEntity livingEntity : avoidedEntities) {
                if (livingEntity.func_70068_e(e) < 500.0 && livingEntity.func_70685_l(e)) continue;
                flag = true;
            }
        }
        if (!flag && backupPos != null) {
            e.func_70107_b((double)backupPos.func_177958_n(), (double)backupPos.func_177956_o() + 0.2, (double)backupPos.func_177952_p());
            flag = true;
        }
        if (flag) {
            world.func_217376_c(e);
            UtilLib.onInitialSpawn(e, reason);
            return true;
        }
        return false;
    }

    @Nullable
    public static Entity spawnEntityInWorld(World world, AxisAlignedBB box, EntityType entityType, int maxTry, @Nonnull List<? extends LivingEntity> avoidedEntities, SpawnReason reason) {
        Entity e = entityType.func_200721_a(world);
        if (UtilLib.spawnEntityInWorld(world, box, e, maxTry, avoidedEntities, reason)) {
            return e;
        }
        if (e != null) {
            e.func_70106_y();
        }
        return null;
    }

    public static boolean teleportTo(MobEntity entity, double x, double y, double z, boolean sound) {
        double d3 = entity.func_226277_ct_();
        double d4 = entity.func_226278_cu_();
        double d5 = entity.func_226281_cx_();
        entity.func_226288_n_(x, y, z);
        boolean flag = false;
        BlockPos blockPos = entity.func_233580_cy_();
        double ty = y;
        if (entity.func_130014_f_().func_175667_e(blockPos)) {
            boolean flag1 = false;
            while (!flag1 && blockPos.func_177956_o() > 0) {
                BlockState blockState = entity.func_130014_f_().func_180495_p(blockPos.func_177977_b());
                if (blockState.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                entity.func_226288_n_(x, ty -= 1.0, z);
                blockPos = blockPos.func_177977_b();
            }
            if (flag1) {
                entity.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
                if (entity.func_130014_f_().func_226669_j_((Entity)entity) && !entity.func_130014_f_().func_72953_d(entity.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            entity.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (entity.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            float f1 = (entity.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            float f2 = (entity.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (entity.func_226277_ct_() - d3) * d6 + (entity.func_70681_au().nextDouble() - 0.5) * (double)entity.func_213311_cf() * 2.0;
            double d8 = d4 + (entity.func_226278_cu_() - d4) * d6 + entity.func_70681_au().nextDouble() * (double)entity.func_213302_cg();
            double d9 = d5 + (entity.func_226281_cx_() - d5) * d6 + (entity.func_70681_au().nextDouble() - 0.5) * (double)entity.func_213311_cf() * 2.0;
            entity.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197599_J, d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        if (sound) {
            entity.func_130014_f_().func_184134_a(d3, d4, d5, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
            entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return true;
    }

    public static void spawnParticles(World world, IParticleData particle, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int amount, float maxOffset) {
        double x = xCoord;
        double y = yCoord;
        double z = zCoord;
        for (int i = 0; i < amount; ++i) {
            world.func_195594_a(particle, x, y, z, xSpeed, ySpeed, zSpeed);
            Random ran = world.field_73012_v;
            x = xCoord + ran.nextGaussian() * (double)maxOffset;
            y = yCoord + ran.nextGaussian() * (double)maxOffset;
            z = zCoord + ran.nextGaussian() * (double)maxOffset;
        }
    }

    public static void spawnParticlesAroundEntity(LivingEntity e, IParticleData particle, double maxDistance, int amount) {
        int short1 = amount;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0) - 0.5;
            float f = (e.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            float f1 = (e.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            float f2 = (e.func_70681_au().nextFloat() - 0.5f) * 0.2f;
            double d7 = e.func_226277_ct_() + maxDistance * d6 + (e.func_70681_au().nextDouble() - 0.5) * (double)e.func_213311_cf() * 2.0;
            double d8 = e.func_226278_cu_() + maxDistance / 2.0 * d6 + e.func_70681_au().nextDouble() * (double)e.func_110143_aJ();
            double d9 = e.func_226281_cx_() + maxDistance * d6 + (e.func_70681_au().nextDouble() - 0.5) * (double)e.func_213311_cf() * 2.0;
            e.func_130014_f_().func_195594_a(particle, d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
    }

    public static void sendMessageToAllExcept(PlayerEntity player, ITextComponent message) {
        for (Object o : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            if (o.equals(player)) continue;
            ((PlayerEntity)o).func_145747_a(message, Util.field_240973_b_);
        }
    }

    public static void sendMessageToAll(ITextComponent message) {
        UtilLib.sendMessageToAllExcept(null, message);
    }

    public static boolean canReallySee(LivingEntity entity, LivingEntity target, boolean alsoRaytrace) {
        if (alsoRaytrace && !entity.func_70685_l((Entity)target)) {
            return false;
        }
        Vector3d look1 = new Vector3d(-Math.sin((double)(entity.field_70759_as / 180.0f) * Math.PI), 0.0, Math.cos((double)(entity.field_70759_as / 180.0f) * Math.PI));
        Vector3d dist = new Vector3d(target.func_226277_ct_() - entity.func_226277_ct_(), 0.0, target.func_226281_cx_() - entity.func_226281_cx_());
        double alpha = Math.acos((look1 = look1.func_72432_b()).func_72430_b(dist = dist.func_72432_b()));
        return alpha < 1.7453292519943295;
    }

    @Nonnull
    public static <T> T getNull() {
        return null;
    }

    public static void write(CompoundNBT nbt, String base, BlockPos pos) {
        nbt.func_74768_a(base + "_x", pos.func_177958_n());
        nbt.func_74768_a(base + "_y", pos.func_177956_o());
        nbt.func_74768_a(base + "_z", pos.func_177952_p());
    }

    public static BlockPos readPos(CompoundNBT nbt, String base) {
        return new BlockPos(nbt.func_74762_e(base + "_x"), nbt.func_74762_e(base + "_y"), nbt.func_74762_e(base + "_z"));
    }

    public static String[] prefix(String prefix, String ... strings) {
        String[] result = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            result[i] = prefix + strings[i];
        }
        return result;
    }

    public static Predicate getPredicateForClass(Class clazz) {
        return clazz::isInstance;
    }

    public static AxisAlignedBB createBB(BlockPos center, int distance, boolean fullY) {
        return new AxisAlignedBB((double)(center.func_177958_n() - distance), fullY ? 0.0 : (double)(center.func_177956_o() - distance), (double)(center.func_177952_p() - distance), (double)(center.func_177958_n() + distance), fullY ? 256.0 : (double)(center.func_177956_o() + distance), (double)(center.func_177952_p() + distance));
    }

    public static boolean isNonNull(Object ... objects) {
        for (Object o : objects) {
            if (o != null) continue;
            return false;
        }
        return true;
    }

    private static ChunkPos isBiomeAt(ServerWorld world, int x, int z, List<Biome> biomes) {
        BlockPos pos = world.func_72863_F().func_201711_g().func_202090_b().func_225531_a_(x, world.func_181545_F(), z, 32, biomes, new Random());
        if (pos != null) {
            return new ChunkPos(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        }
        return null;
    }

    public static ChunkPos findNearBiome(ServerWorld world, BlockPos center, int maxDist, List<Biome> biomes) {
        long start = System.currentTimeMillis();
        maxDist = maxDist / 20 * 20;
        long maxop = ((long)maxDist * (long)maxDist + (long)maxDist) / 2L;
        for (int i = 0; i < maxDist; i += 4) {
            ChunkPos loc;
            int cz;
            int cx = -i;
            for (cz = -i; cz <= i; ++cz) {
                if (cz % 4 != 0) continue;
                loc = UtilLib.isBiomeAt(world, center.func_177958_n() + (cx << 4), center.func_177952_p() + (cz << 4), biomes);
                if (loc != null) {
                    LOGGER.trace("Took {} ms to find a vampire biome {} {}", (Object)((int)(System.currentTimeMillis() - start)), (Object)loc.field_77276_a, (Object)loc.field_77275_b);
                    return loc;
                }
                if (cz != i || cx >= 0) continue;
                cz = -i;
                cx = i;
            }
            cz = -i;
            for (int cx2 = -i + 1; cx2 < i; ++cx2) {
                if (cx2 % 4 != 0) continue;
                loc = UtilLib.isBiomeAt(world, center.func_177958_n() + (cx2 << 4), center.func_177952_p() + (cz << 4), biomes);
                if (loc != null) {
                    LOGGER.trace("Took {} ms to find a vampire biome {} {}", (Object)((int)(System.currentTimeMillis() - start)), (Object)loc.field_77276_a, (Object)loc.field_77275_b);
                    return loc;
                }
                if (cx != i - 1 || cz >= 0) continue;
                cz = i;
                cx = i - 1;
            }
            if (i * 10 % maxDist != 0) continue;
            long op = ((long)i * (long)i + (long)i) / 2L;
            double perc = (double)op / (double)maxop * 100.0;
            LOGGER.trace("Search {} percent finished", (Object)((int)perc));
        }
        LOGGER.trace("Took {} ms to not find a vampire biome", (Object)((int)(System.currentTimeMillis() - start)));
        return null;
    }

    public static boolean isPlayerOp(PlayerEntity player) {
        return ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH()) != null;
    }

    public static boolean isSameInstanceAsServer() {
        return ServerLifecycleHooks.getCurrentServer() != null;
    }

    public static String translate(String key, Object ... format) {
        String pattern = ForgeI18n.getPattern((String)key);
        if (format.length == 0) {
            return pattern;
        }
        try {
            pattern = UtilLib.replaceDeprecatedFormatter(pattern);
            return ForgeI18n.parseFormat((String)pattern, (Object[])format);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Illegal format found `{}`", (Object)pattern);
            return pattern;
        }
    }

    private static String replaceDeprecatedFormatter(String text) {
        StringBuffer sb = null;
        Matcher m = oldFormatPattern.matcher(text);
        int i = 0;
        while (m.find()) {
            String t = m.group();
            t = "{" + i++ + "}";
            if (sb == null) {
                sb = new StringBuffer(text.length());
            }
            m.appendReplacement(sb, t);
        }
        if (sb == null) {
            return text;
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static VoxelShape rotateShape(VoxelShape shape, RotationAmount rotation) {
        HashSet rotatedShapes = new HashSet();
        shape.func_197755_b((x1, y1, z1, x2, y2, z2) -> {
            x1 = x1 * 16.0 - 8.0;
            x2 = x2 * 16.0 - 8.0;
            z1 = z1 * 16.0 - 8.0;
            z2 = z2 * 16.0 - 8.0;
            if (rotation == RotationAmount.NINETY) {
                rotatedShapes.add(Block.func_208617_a((double)(8.0 - z1), (double)(y1 * 16.0), (double)(8.0 + x1), (double)(8.0 - z2), (double)(y2 * 16.0), (double)(8.0 + x2)));
            } else if (rotation == RotationAmount.HUNDRED_EIGHTY) {
                rotatedShapes.add(Block.func_208617_a((double)(8.0 - x1), (double)(y1 * 16.0), (double)(8.0 - z1), (double)(8.0 - x2), (double)(y2 * 16.0), (double)(8.0 - z2)));
            } else if (rotation == RotationAmount.TWO_HUNDRED_SEVENTY) {
                rotatedShapes.add(Block.func_208617_a((double)(8.0 + z1), (double)(y1 * 16.0), (double)(8.0 - x1), (double)(8.0 + z2), (double)(y2 * 16.0), (double)(8.0 - x2)));
            }
        });
        return (VoxelShape)rotatedShapes.stream().reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    }

    public static String aiTaskListToStringDebug(GoalSelector tasks) {
        Collection c = (Collection)ObfuscationReflectionHelper.getPrivateValue(GoalSelector.class, (Object)tasks, (String)"executingTaskEntries");
        Iterator var1 = c.iterator();
        if (!var1.hasNext()) {
            return "[]";
        }
        StringBuilder var2 = new StringBuilder();
        var2.append('[');
        while (true) {
            Object var3;
            var2.append((Object)((var3 = var1.next()) == c ? "(this Collection)" : ((PrioritizedGoal)var3).func_220772_j()));
            if (!var1.hasNext()) {
                return var2.append(']').toString();
            }
            var2.append(',').append(' ');
        }
    }

    public static boolean isInsideStructure(Entity entity, Structure<?> s) {
        StructureStart<?> start = UtilLib.getStructureStartAt(entity, s);
        return start != null && start.func_75069_d();
    }

    public static boolean isInsideStructure(World w, BlockPos p, Structure<?> s) {
        StructureStart<?> start = UtilLib.getStructureStartAt(w, p, s);
        return start != null && start.func_75069_d();
    }

    @Nullable
    public static StructureStart<?> getStructureStartAt(Entity entity, Structure<?> s) {
        return UtilLib.getStructureStartAt(entity.func_130014_f_(), entity.func_233580_cy_(), s);
    }

    @Nullable
    public static StructureStart<?> getStructureStartAt(World w, BlockPos pos, Structure<?> s) {
        if (w instanceof ServerWorld) {
            return ((ServerWorld)w).func_241112_a_().func_235010_a_(pos, true, s);
        }
        return null;
    }

    public static CompoundNBT checkNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        return stack.func_77978_p();
    }

    public static float[] getColorComponents(int color) {
        int i = (color & 0xFF0000) >> 16;
        int j = (color & 0xFF00) >> 8;
        int k = color & 0xFF;
        return new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
    }

    @Nonnull
    public static int[] bbToInt(@Nonnull AxisAlignedBB bb) {
        return new int[]{(int)bb.field_72340_a, (int)bb.field_72338_b, (int)bb.field_72339_c, (int)bb.field_72336_d, (int)bb.field_72337_e, (int)bb.field_72334_f};
    }

    @Nonnull
    public static int[] mbToInt(@Nonnull MutableBoundingBox bb) {
        return new int[]{bb.field_78897_a, bb.field_78895_b, bb.field_78896_c, bb.field_78893_d, bb.field_78894_e, bb.field_78892_f};
    }

    @Nonnull
    public static AxisAlignedBB intToBB(int[] array) {
        return new AxisAlignedBB((double)array[0], (double)array[1], (double)array[2], (double)array[3], (double)array[4], (double)array[5]);
    }

    @Nonnull
    public static MutableBoundingBox intToMB(int[] array) {
        return new MutableBoundingBox(array[0], array[1], array[2], array[3], array[4], array[5]);
    }

    public static ITextComponent addFormatting(ITextComponent component, TextFormatting format) {
        if (component instanceof IFormattableTextComponent) {
            ((IFormattableTextComponent)component).func_240699_a_(format);
        }
        return component;
    }

    public static enum RotationAmount {
        NINETY,
        HUNDRED_EIGHTY,
        TWO_HUNDRED_SEVENTY;

    }
}

