/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.client.gui.SelectActionScreen;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.network.InputEventPacket;
import de.teamlapen.vampirism.player.skills.ActionSkill;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.player.skills.SkillNode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class SkillsScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("vampirism", "textures/gui/skills_window.png");
    private static final ResourceLocation ACTIONBUTTON = new ResourceLocation("vampirism", "textures/gui/action_configure.png");
    private final int area_min_y = -77;
    private final int skill_width = 24;
    private final List<SkillNode> skillNodes = new ArrayList<SkillNode>();
    private final int display_width = 256;
    private final int display_height = 202;
    private int area_min_x = 0;
    private int area_max_x = 0;
    private int area_max_y;
    private float zoomOut = 1.0f;
    private double displayX;
    private double displayY;
    private double displayXNew;
    private double displayYNew;
    private SkillHandler skillHandler;
    private boolean display;
    private ISkill selected;

    public SkillsScreen() {
        super((ITextComponent)new TranslationTextComponent("screen.vampirism.skills"));
        this.field_230708_k_ = 256;
        this.field_230709_l_ = 202;
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        if (!this.display) {
            super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
            return;
        }
        this.func_230446_a_(stack);
        this.drawSkills(stack, mouseX, mouseY, partialTicks);
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        this.drawTitle(stack);
        RenderSystem.enableLighting();
        RenderSystem.enableDepthTest();
    }

    public void func_231023_e_() {
        if (!this.field_230706_i_.field_71439_g.func_70089_S()) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        this.zoomOut = (float)((double)this.zoomOut + (p_mouseScrolled_5_ > 0.0 ? -0.25 : 0.25));
        this.zoomOut = MathHelper.func_76131_a((float)this.zoomOut, (float)1.0f, (float)2.0f);
        this.checkDisplay();
        return true;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        boolean retur = super.func_231044_a_(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && this.selected != null) {
            if (this.skillHandler.canSkillBeEnabled(this.selected) == ISkillHandler.Result.OK) {
                VampirismMod.dispatcher.sendToServer(new InputEventPacket("us", this.selected.getRegistryName().toString()));
                this.playSoundEffect(SoundEvents.field_187802_ec, 0.7f);
                return true;
            }
            this.playSoundEffect(SoundEvents.field_187679_dF, 0.5f);
            return true;
        }
        return retur;
    }

    public boolean func_231045_a_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        this.displayY -= p_mouseDragged_8_;
        this.displayX -= p_mouseDragged_6_;
        this.checkDisplay();
        return true;
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256 || ModKeys.getKeyBinding(ModKeys.KEY.SKILL).getKey().func_197937_c() == p_keyPressed_1_) {
            this.field_230706_i_.func_147108_a(null);
            this.field_230706_i_.func_213228_a(true);
            return true;
        }
        super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        return false;
    }

    public void func_231160_c_() {
        Optional<? extends IFactionPlayer> fOpt = FactionPlayerHandler.get((PlayerEntity)this.field_230706_i_.field_71439_g).getCurrentFactionPlayer();
        fOpt.ifPresent(factionPlayer -> {
            IFaction faction = factionPlayer.getFaction();
            this.display = true;
            this.skillHandler = (SkillHandler)factionPlayer.getSkillHandler();
            Integer[] info = VampirismMod.proxy.getSkillTree(true).getDisplayInfo(faction.getID());
            int w = info[0] * info[1] * 24 * 2;
            this.area_max_x = w + 10 - 256;
            this.area_min_x = -w - 10 - 256;
            this.area_max_y = info[2] * 24 * 2;
            this.displayXNew = -100.0;
            this.displayX = -100.0;
            this.displayYNew = -10.0;
            this.displayY = -10.0;
            this.skillNodes.clear();
            SkillNode root = VampirismMod.proxy.getSkillTree(true).getRootNodeForFaction(faction.getID());
            this.addToList(this.skillNodes, root);
        });
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 24, this.field_230709_l_ / 2 + 74, 80, 20, (ITextComponent)new TranslationTextComponent("gui.done"), context -> this.field_230706_i_.func_147108_a(null)));
        if (this.display) {
            Button resetSkills = (Button)this.func_230480_a_((Widget)new Button((this.field_230708_k_ - 256) / 2 + 24 + 20, this.field_230709_l_ / 2 + 74, 80, 20, (ITextComponent)new TranslationTextComponent("text.vampirism.skill.resetall"), context -> {
                boolean test = VampirismMod.inDev || VampirismMod.instance.getVersionInfo().getCurrentVersion().isTestVersion();
                ConfirmScreen resetGui = new ConfirmScreen(cxt -> {
                    if (cxt) {
                        VampirismMod.dispatcher.sendToServer(new InputEventPacket("rs", ""));
                        Minecraft.func_71410_x().func_147108_a((Screen)this);
                    } else {
                        Minecraft.func_71410_x().func_147108_a((Screen)this);
                    }
                }, (ITextComponent)new TranslationTextComponent("gui.vampirism.reset_skills.title"), (ITextComponent)new TranslationTextComponent("gui.vampirism.reset_skills." + (test ? "desc_test" : "desc")));
                Minecraft.func_71410_x().func_147108_a((Screen)resetGui);
            }));
            this.func_230480_a_((Widget)new ImageButton((this.field_230708_k_ - 256) / 2 + 10, this.field_230709_l_ / 2 + 74, 20, 20, 0, 0, 20, ACTIONBUTTON, 20, 40, context -> {
                IPlayableFaction<? extends IFactionPlayer> faction = FactionPlayerHandler.get((PlayerEntity)this.field_230706_i_.field_71439_g).getCurrentFaction();
                Minecraft.func_71410_x().func_147108_a((Screen)new SelectActionScreen(faction.getColor(), true));
            }));
            if (fOpt.map(IFactionPlayer::getLevel).orElse(0) < 2) {
                resetSkills.field_230693_o_ = false;
            }
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected void drawTitle(MatrixStack stack) {
        TranslationTextComponent title = new TranslationTextComponent("text.vampirism.skills.gui_title");
        int x = (this.field_230708_k_ - 256) / 2;
        int y = (this.field_230709_l_ - 202) / 2;
        this.field_230712_o_.func_238422_b_(stack, (ITextProperties)title, (float)(x + 15), (float)(y + 5), -1);
        TranslationTextComponent points = new TranslationTextComponent("text.vampirism.skills.points_left", new Object[]{this.skillHandler.getLeftSkillPoints()});
        x = (this.field_230708_k_ + 256) / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)points);
        this.field_230712_o_.func_238422_b_(stack, (ITextProperties)points, (float)(x - 15), (float)(y + 5), -1);
    }

    private void addToList(List<SkillNode> list, SkillNode root) {
        list.add(root);
        for (SkillNode node : root.getChildren()) {
            this.addToList(list, node);
        }
    }

    private void checkDisplay() {
        this.displayY = MathHelper.func_151237_a((double)this.displayY, (double)(-20.0f / this.zoomOut), (double)(350.0f / this.zoomOut));
        this.displayXNew = this.displayX = MathHelper.func_151237_a((double)this.displayX, (double)(-400.0f / this.zoomOut + (this.zoomOut - 2.0f) * -1.0f * 250.0f), (double)(-300.0f / this.zoomOut + (this.zoomOut - 2.0f) * -1.0f * 250.0f));
        this.displayYNew = this.displayY;
    }

    private void drawSkills(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        int offsetX = MathHelper.func_76128_c((double)(this.displayX + (this.displayXNew - this.displayX) * (double)partialTicks));
        int offsetY = MathHelper.func_76128_c((double)(this.displayY + (this.displayYNew - this.displayY) * (double)partialTicks));
        if (offsetX < this.area_min_x) {
            offsetX = this.area_min_x;
        }
        if (offsetY < -77) {
            offsetY = -77;
        }
        if (offsetX >= this.area_max_x) {
            offsetX = this.area_max_x - 1;
        }
        if (offsetY >= this.area_max_y) {
            offsetY = this.area_max_y - 1;
        }
        int k = (this.field_230708_k_ - this.display_width) / 2;
        int l = (this.field_230709_l_ - this.display_height) / 2;
        int i1 = k + 16;
        int j1 = l + 17;
        GL11.glEnable((int)3089);
        double scale = this.field_230706_i_.func_228018_at_().func_198100_s();
        GL11.glScissor((int)((int)((double)k * scale)), (int)((int)((double)l * scale)), (int)((int)(256.0 * scale)), (int)((int)(202.0 * scale)));
        this.func_230926_e_(0);
        RenderSystem.depthFunc((int)518);
        stack.func_227860_a_();
        stack.func_227861_a_((double)i1, (double)j1, -200.0);
        stack.func_227862_a_(1.0f / this.zoomOut, 1.0f / this.zoomOut, 1.0f);
        RenderSystem.enableTexture();
        RenderSystem.disableLighting();
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableColorMaterial();
        int k1 = offsetX + 288 >> 4;
        int l1 = offsetY + 288 >> 4;
        int i2 = (offsetX + 512) % 16;
        int j2 = (offsetY + 288) % 16;
        Random random = new Random();
        float f = 16.0f / this.zoomOut;
        float f1 = 16.0f / this.zoomOut;
        int y = 0;
        while ((float)y * f - (float)j2 < 155.0f) {
            float f2 = 0.6f - (float)(l1 + y) / 25.0f * 0.3f;
            RenderSystem.color4f((float)f2, (float)f2, (float)f2, (float)1.0f);
            int x = 0;
            while ((float)x * f1 - (float)i2 < 224.0f) {
                random.setSeed(this.field_230706_i_.func_110432_I().func_148255_b().hashCode() + k1 + x + (l1 + y) * 16);
                int j4 = random.nextInt(1 + l1 + y) + (l1 + y) / 2;
                TextureAtlasSprite textureatlassprite = this.getTexture(Blocks.field_150354_m);
                if (j4 <= 37 && l1 + y != 35) {
                    if (j4 == 22) {
                        textureatlassprite = random.nextInt(2) == 0 ? this.getTexture(Blocks.field_150402_ci) : this.getTexture(Blocks.field_150451_bX);
                    } else if (j4 == 10) {
                        textureatlassprite = this.getTexture(ModBlocks.castle_block_dark_brick_bloody);
                    } else if (j4 == 8) {
                        textureatlassprite = this.getTexture(Blocks.field_196696_di);
                    } else if (j4 > 4) {
                        textureatlassprite = this.getTexture(ModBlocks.castle_block_normal_brick);
                    } else if (j4 > 0) {
                        textureatlassprite = this.getTexture(Blocks.field_150346_d);
                    }
                } else {
                    Block block = Blocks.field_150357_h;
                    textureatlassprite = this.getTexture(block);
                }
                this.field_230706_i_.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
                SkillsScreen.func_238470_a_((MatrixStack)stack, (int)(x * 16 - i2), (int)(y * 16 - j2), (int)this.func_230927_p_(), (int)16, (int)16, (TextureAtlasSprite)textureatlassprite);
                ++x;
            }
            ++y;
        }
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        for (SkillNode node : this.skillNodes) {
            if (node.getParent() == null) continue;
            int xs = this.findHorizontalNodeCenter(node) - offsetX + 11;
            int ys = node.getElements()[0].getRenderRow() * 24 - offsetY + 11;
            int xp = this.findHorizontalNodeCenter(node.getParent()) - offsetX + 11;
            int yp = node.getParent().getElements()[0].getRenderRow() * 24 - offsetY + 11;
            int unlockstate = this.skillHandler.isNodeEnabled(node) ? 0 : (this.skillHandler.isNodeEnabled(node.getParent()) ? 1 : -1);
            int color = -16777216;
            if (unlockstate == 0) {
                color = -6250336;
            } else if (unlockstate == 1) {
                color = -16738048;
            }
            this.func_238465_a_(stack, xs, xp, yp, color);
            this.func_238473_b_(stack, xs, ys - 11, yp, color);
            if (ys > yp) {
                this.func_238474_b_(stack, xs - 5, ys - 11 - 7, 96, 234, 11, 7);
                continue;
            }
            if (ys < yp) {
                this.func_238474_b_(stack, xs - 5, ys + 11, 96, 241, 11, 7);
                continue;
            }
            if (xs > xp) {
                this.func_238474_b_(stack, xs - 11 - 7, ys - 5, 114, 234, 7, 11);
                continue;
            }
            if (xs >= xp) continue;
            this.func_238474_b_(stack, xs + 11, ys - 5, 107, 234, 7, 11);
        }
        float mMouseX = (float)(mouseX - i1) * this.zoomOut;
        float mMouseY = (float)(mouseY - j1) * this.zoomOut;
        RenderHelper.func_227780_a_();
        RenderSystem.disableLighting();
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableColorMaterial();
        ISkill newselected = null;
        for (SkillNode node : this.skillNodes) {
            ISkill[] elements = node.getElements();
            if (elements.length > 1) {
                int minX = elements[0].getRenderColumn() * 24 - offsetX;
                int maxX = elements[elements.length - 1].getRenderColumn() * 24 - offsetX;
                int y2 = elements[0].getRenderRow() * 24 - offsetY;
                if (maxX >= -24 && y2 >= -24 && (float)minX <= 224.0f * this.zoomOut && (float)y2 <= 155.0f * this.zoomOut) {
                    RenderSystem.enableBlend();
                    this.func_238468_a_(stack, minX - 1, y2 - 1, maxX + 23, y2 + 23, -6578783, -6578783);
                    RenderSystem.disableBlend();
                }
            }
            for (int i = 0; i < elements.length; ++i) {
                int unlockstate;
                ISkill skill = elements[i];
                int x = skill.getRenderColumn() * 24 - offsetX;
                int y3 = skill.getRenderRow() * 24 - offsetY;
                if (x < -24 || y3 < -24 || !((float)x <= 224.0f * this.zoomOut) || !((float)y3 <= 155.0f * this.zoomOut)) continue;
                int n = this.skillHandler.isSkillEnabled(skill) ? 0 : (this.skillHandler.isNodeEnabled(node) ? -1 : (unlockstate = this.skillHandler.canSkillBeEnabled(skill) == ISkillHandler.Result.OK ? 1 : 2));
                if (unlockstate == 0) {
                    float f5 = 1.0f;
                    RenderSystem.color4f((float)f5, (float)f5, (float)f5, (float)1.0f);
                } else if (unlockstate == 1) {
                    float f6 = 0.6f;
                    RenderSystem.color4f((float)f6, (float)f6, (float)f6, (float)1.0f);
                } else if (unlockstate == 2) {
                    float f7 = 0.3f;
                    RenderSystem.color4f((float)f7, (float)f7, (float)f7, (float)1.0f);
                } else if (unlockstate == -1) {
                    float f8 = 0.2f;
                    RenderSystem.color4f((float)f8, (float)f8, (float)f8, (float)1.0f);
                }
                this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
                RenderSystem.enableBlend();
                this.func_238474_b_(stack, x - 2, y3 - 2, 0, 202, 26, 26);
                RenderSystem.disableBlend();
                this.field_230706_i_.func_110434_K().func_110577_a(this.getIconLoc(skill));
                RenderSystem.disableLighting();
                RenderSystem.enableBlend();
                UtilLib.drawTexturedModalRect(stack.func_227866_c_().func_227870_a_(), this.func_230927_p_(), x + 3, y3 + 3, 0, 0, 16, 16, 16, 16);
                RenderSystem.disableLighting();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (mMouseX >= (float)x && mMouseX <= (float)(x + 22) && mMouseY >= (float)y3 && mMouseY <= (float)(y3 + 22)) {
                    newselected = skill;
                }
                if (i + 1 >= elements.length) continue;
                this.field_230712_o_.getClass();
                this.func_238471_a_(stack, this.field_230712_o_, "OR", x + 24 + 12, y3 + 1 + (24 - 9) / 2, 0xFFFFFF);
            }
        }
        GL11.glDisable((int)3089);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        stack.func_227865_b_();
        Color color = this.skillHandler.getPlayer().getFaction().getColor();
        RenderSystem.color4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        this.func_238474_b_(stack, k, l, 0, 0, this.display_width, this.display_height);
        this.func_230926_e_(0);
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        RenderSystem.enableTexture();
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.selected = newselected;
        if (this.selected != null) {
            stack.func_227860_a_();
            stack.func_227861_a_(0.0, 0.0, 1.0);
            int m2MouseX = mouseX + 12;
            int m2MouseY = mouseY - 4;
            TranslationTextComponent name = new TranslationTextComponent(this.selected.getTranslationKey());
            ITextComponent desc = this.selected.getDescription();
            ISkillHandler.Result result = this.skillHandler.canSkillBeEnabled(this.selected);
            int width_name = Math.max(this.field_230712_o_.func_238414_a_((ITextProperties)name), 110);
            List descLines = desc == null ? Collections.emptyList() : this.field_230712_o_.func_238425_b_((ITextProperties)desc, width_name);
            int n = descLines.size();
            this.field_230712_o_.getClass();
            int height_desc = n * 9;
            if (result == ISkillHandler.Result.ALREADY_ENABLED || result == ISkillHandler.Result.PARENT_NOT_ENABLED) {
                height_desc += 12;
            }
            this.func_238468_a_(stack, m2MouseX - 3, m2MouseY - 3, m2MouseX + width_name + 3, m2MouseY + height_desc + 3 + 12, -1073741824, -1073741824);
            this.field_230712_o_.func_238407_a_(stack, (ITextProperties)name, (float)m2MouseX, (float)m2MouseY, -8355712);
            int j = 0;
            for (ITextProperties t : descLines) {
                this.field_230712_o_.func_238422_b_(stack, t, (float)m2MouseX, (float)(m2MouseY + 12 + j), -11513776);
                this.field_230712_o_.getClass();
                j += 9;
            }
            if (result == ISkillHandler.Result.ALREADY_ENABLED) {
                this.field_230712_o_.func_238407_a_(stack, (ITextProperties)new TranslationTextComponent("text.vampirism.skill.unlocked"), (float)m2MouseX, (float)(m2MouseY + height_desc + 3), -283136);
            } else if (result == ISkillHandler.Result.PARENT_NOT_ENABLED) {
                this.field_230712_o_.func_238407_a_(stack, (ITextProperties)new TranslationTextComponent("text.vampirism.skill.unlock_parent_first"), (float)m2MouseX, (float)(m2MouseY + height_desc + 3), -6086104);
            }
            stack.func_227865_b_();
        }
        RenderSystem.enableDepthTest();
        RenderSystem.enableLighting();
        RenderHelper.func_74518_a();
    }

    private int findHorizontalNodeCenter(SkillNode node) {
        int width = (node.getElements().length - 1) * 2 * 24;
        return node.getElements()[0].getRenderColumn() * 24 + width / 2;
    }

    private ResourceLocation getIconLoc(ISkill skill) {
        if (skill instanceof ActionSkill) {
            return new ResourceLocation(((ActionSkill)skill).getActionID().func_110624_b(), "textures/actions/" + ((ActionSkill)skill).getActionID().func_110623_a() + ".png");
        }
        return new ResourceLocation(skill.getRegistryName().func_110624_b(), "textures/skills/" + skill.getRegistryName().func_110623_a() + ".png");
    }

    private TextureAtlasSprite getTexture(BlockState blockstate) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(blockstate);
    }

    private TextureAtlasSprite getTexture(Block block) {
        return this.getTexture(block.func_176223_P());
    }

    private void playSoundEffect(SoundEvent event, float pitch) {
        this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)event, (float)1.0f));
    }
}

