/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.items.HunterCoatItem;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.hunter.HunterPlayerSpecialAttribute;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.tileentity.TotemTileEntity;
import de.teamlapen.vampirism.util.Helper;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.OutlineLayerBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class RenderHandler
implements ISelectiveResourceReloadListener {
    private static final ResourceLocation saturation1 = new ResourceLocation("vampirism:shaders/saturation1.json");
    private static final int ENTITY_NEAR_SQ_DISTANCE = 100;
    @Nonnull
    private final Minecraft mc;
    private final int BLOOD_VISION_FADE_TICKS = 80;
    private final int VAMPIRE_BIOME_FADE_TICKS = 60;
    private final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private OutlineLayerBuffer bloodVisionBuffer;
    private BatEntity entityBat;
    private int vampireBiomeTicks = 0;
    private boolean insideFog = false;
    private int bloodVisionTicks = 0;
    private int lastBloodVisionTicks = 0;
    private float vampireBiomeFogDistanceMultiplier = 1.0f;
    @Nullable
    private ShaderGroup blurShader;
    private int displayHeight;
    private int displayWidth;
    private boolean isInsideBloodVisionRendering = false;
    private boolean hunterDisguiseEnabled;
    @Nullable
    private Shader blur1;
    @Nullable
    private Shader blur2;
    @Nullable
    private Shader blit0;

    public RenderHandler(@Nonnull Minecraft mc) {
        this.mc = mc;
    }

    @Nullable
    public IResourceType getResourceType() {
        return VanillaResourceType.SHADERS;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.field_71441_e == null || this.mc.field_71439_g == null || !this.mc.field_71439_g.func_70089_S()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        this.lastBloodVisionTicks = this.bloodVisionTicks;
        VampirePlayer vampire = VampirePlayer.get((PlayerEntity)this.mc.field_71439_g);
        if (vampire.getSpecialAttributes().blood_vision && !((Boolean)VampirismConfig.CLIENT.disableBloodVisionRendering.get()).booleanValue() && !VampirePlayer.get((PlayerEntity)this.mc.field_71439_g).isGettingSundamage((IWorld)this.mc.field_71439_g.field_70170_p)) {
            if (this.bloodVisionTicks < 80) {
                ++this.bloodVisionTicks;
            }
        } else {
            if (this.bloodVisionTicks > 0) {
                this.bloodVisionTicks -= 2;
            }
            if (this.vampireBiomeTicks > 10 && this.bloodVisionTicks == 15) {
                this.bloodVisionTicks = 0;
            }
        }
        if (this.mc.field_71439_g.field_70173_aa % 10 == 0) {
            if ((((Boolean)VampirismConfig.CLIENT.renderVampireForestFog.get()).booleanValue() || ((Boolean)VampirismConfig.SERVER.enforceRenderForestFog.get()).booleanValue()) && (Helper.isEntityInVampireBiome((Entity)this.mc.field_71439_g) || TotemTileEntity.isInsideVampireAreaCached((RegistryKey<World>)this.mc.field_71441_e.func_234923_W_(), this.mc.field_71439_g.func_233580_cy_()))) {
                this.insideFog = true;
                this.vampireBiomeFogDistanceMultiplier = vampire.getSpecialAttributes().increasedVampireFogDistance ? 2.0f : 1.0f;
            } else {
                this.insideFog = false;
            }
        }
        if (this.insideFog) {
            if (this.vampireBiomeTicks < 60) {
                ++this.vampireBiomeTicks;
            }
        } else if (this.vampireBiomeTicks > 0) {
            --this.vampireBiomeTicks;
        }
        if (this.mc.field_71439_g != null && this.mc.field_71439_g.func_70681_au().nextInt(10) == 3) {
            EffectInstance pe = this.mc.field_71439_g.func_70660_b(ModEffects.saturation);
            boolean active = pe != null && pe.func_76458_c() >= 2;
            GameRenderer renderer = this.mc.field_71460_t;
            if (active && renderer.func_147706_e() == null) {
                renderer.func_175069_a(saturation1);
            } else if (!active && renderer.func_147706_e() != null && renderer.func_147706_e().func_148022_b().equals(saturation1.toString())) {
                renderer.func_181022_b();
            }
        }
    }

    @SubscribeEvent
    public void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        if (this.vampireBiomeTicks == 0) {
            return;
        }
        float f = 60.0f / (float)this.vampireBiomeTicks / 1.5f;
        float fogStart = Math.min(event.getFarPlaneDistance() * 0.75f, 6.0f * (f *= this.vampireBiomeFogDistanceMultiplier));
        float fogEnd = Math.min(event.getFarPlaneDistance(), 50.0f * f);
        RenderSystem.fogStart((float)(event.getType() == FogRenderer.FogType.FOG_SKY ? 0.0f : fogStart));
        RenderSystem.fogEnd((float)fogEnd);
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        if (this.mc.field_71439_g != null && this.mc.field_71439_g.func_70089_S() && VampirePlayer.get((PlayerEntity)this.mc.field_71439_g).getActionHandler().isActionActive(VampireActions.bat)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderLivingPost(RenderLivingEvent.Post event) {
        if (!this.isInsideBloodVisionRendering && this.shouldRenderBloodVision()) {
            double dist;
            LivingEntity entity = event.getEntity();
            boolean flag = true;
            if (entity instanceof PlayerEntity && HunterCoatItem.isFullyEquipped((PlayerEntity)entity)) {
                flag = false;
            }
            if ((dist = this.mc.field_71439_g.func_70068_e((Entity)entity)) > (double)((Integer)VampirismConfig.BALANCE.vsBloodVisionDistSQ.get()).intValue()) {
                flag = false;
            }
            if (flag) {
                LazyOptional<IExtendedCreatureVampirism> opt;
                LazyOptional<IExtendedCreatureVampirism> lazyOptional = opt = entity instanceof CreatureEntity && entity.func_70089_S() ? ExtendedCreature.getSafe((Entity)entity) : LazyOptional.empty();
                int color = (Boolean)opt.map(creature -> creature.getBlood() > 0 && !creature.hasPoisonousBlood()).orElse((Object)false) != false ? 0xFF0000 : ((Boolean)VampirePlayer.getOpt((PlayerEntity)this.mc.field_71439_g).map(VampirePlayer::getSpecialAttributes).map(s -> s.blood_vision_garlic).orElse((Object)false) != false && ((Boolean)opt.map(IExtendedCreatureVampirism::hasPoisonousBlood).orElse((Object)false) != false || Helper.isHunter((Entity)entity)) ? 524039 : 0xA0A0A0);
                EntityRendererManager renderManager = this.mc.func_175598_ae();
                if (this.bloodVisionBuffer == null) {
                    this.bloodVisionBuffer = new OutlineLayerBuffer(this.mc.func_228019_au_().func_228487_b_());
                }
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                int alpha = (int)((dist > 100.0 ? 50.0 : dist / 100.0 * 50.0) * (double)this.getBloodVisionProgress(event.getPartialRenderTick()));
                this.bloodVisionBuffer.func_228472_a_(r, g, b, alpha);
                float f = MathHelper.func_219799_g((float)event.getPartialRenderTick(), (float)entity.field_70126_B, (float)entity.field_70177_z);
                this.isInsideBloodVisionRendering = true;
                EntityRenderer entityrenderer = renderManager.func_78713_a((Entity)entity);
                entityrenderer.func_225623_a_((Entity)entity, f, event.getPartialRenderTick(), event.getMatrixStack(), (IRenderTypeBuffer)this.bloodVisionBuffer, renderManager.func_229085_a_((Entity)entity, event.getPartialRenderTick()));
                this.mc.func_147110_a().func_147610_a(false);
                this.isInsideBloodVisionRendering = false;
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.bloodVisionTicks = 0;
    }

    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre<PlayerEntity, PlayerModel<PlayerEntity>> event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof PlayerEntity && ((Boolean)HunterPlayer.getOpt((PlayerEntity)entity).map(HunterPlayer::getSpecialAttributes).map(HunterPlayerSpecialAttribute::isDisguised).orElse((Object)false)).booleanValue() && this.mc.field_71439_g != null && entity.func_70068_e((Entity)this.mc.field_71439_g) > 4.0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        PlayerEntity player = event.getPlayer();
        if (((Boolean)VampirePlayer.getOpt(player).map(VampirePlayer::getSpecialAttributes).map(s -> s.bat).orElse((Object)false)).booleanValue()) {
            event.setCanceled(true);
            if (this.entityBat == null) {
                this.entityBat = (BatEntity)EntityType.field_200791_e.func_200721_a(event.getEntity().func_130014_f_());
                this.entityBat.func_82236_f(false);
            }
            float partialTicks = event.getPartialRenderTick();
            this.entityBat.field_70760_ar = player.field_70760_ar;
            this.entityBat.field_70761_aq = player.field_70761_aq;
            this.entityBat.field_70173_aa = player.field_70173_aa;
            this.entityBat.field_70125_A = player.field_70125_A;
            this.entityBat.field_70177_z = player.field_70177_z;
            this.entityBat.field_70759_as = player.field_70759_as;
            this.entityBat.field_70126_B = player.field_70126_B;
            this.entityBat.field_70127_C = player.field_70127_C;
            this.entityBat.field_70758_at = player.field_70758_at;
            this.entityBat.func_82142_c(player.func_82150_aj());
            double d0 = MathHelper.func_219803_d((double)partialTicks, (double)this.entityBat.field_70142_S, (double)this.entityBat.func_226277_ct_());
            double d1 = MathHelper.func_219803_d((double)partialTicks, (double)this.entityBat.field_70137_T, (double)this.entityBat.func_226278_cu_());
            double d2 = MathHelper.func_219803_d((double)partialTicks, (double)this.entityBat.field_70136_U, (double)this.entityBat.func_226281_cx_());
            float f = MathHelper.func_219799_g((float)partialTicks, (float)this.entityBat.field_70126_B, (float)this.entityBat.field_70177_z);
            this.mc.func_175598_ae().func_229084_a_((Entity)this.entityBat, d0, d1, d2, f, partialTicks, event.getMatrixStack(), (IRenderTypeBuffer)this.mc.func_228019_au_().func_228487_b_(), this.mc.func_175598_ae().func_229085_a_((Entity)this.entityBat, partialTicks));
        } else if (((Boolean)HunterPlayer.getOpt(player).map(HunterPlayer::getSpecialAttributes).map(HunterPlayerSpecialAttribute::isDisguised).orElse((Object)false)).booleanValue() && !player.equals((Object)this.mc.field_71439_g)) {
            double distSq = player.func_70068_e((Entity)this.mc.field_71439_g);
            if (distSq > (double)((Integer)VampirismConfig.BALANCE.haDisguiseInvisibleSQ.get()).intValue()) {
                event.setCanceled(true);
            } else {
                this.hunterDisguiseEnabled = true;
                this.enableProfile(Profile.HUNTER_DISGUISE, MathHelper.func_76131_a((float)((float)(distSq / (double)((Integer)VampirismConfig.BALANCE.haDisguiseInvisibleSQ.get()).intValue() * 25.0)), (float)0.0f, (float)1.0f) * ((Float)HunterPlayer.getOpt(player).map(HunterPlayer::getSpecialAttributes).map(HunterPlayerSpecialAttribute::getDisguiseProgress).orElse((Object)Float.valueOf(0.0f))).floatValue());
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        if (this.hunterDisguiseEnabled) {
            this.disableProfile(Profile.HUNTER_DISGUISE);
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (this.mc.field_71441_e == null) {
            return;
        }
        float partialTicks = this.mc.func_184121_ak();
        if (this.displayHeight != this.mc.func_228018_at_().func_198091_l() || this.displayWidth != this.mc.func_228018_at_().func_198109_k()) {
            this.displayHeight = this.mc.func_228018_at_().func_198091_l();
            this.displayWidth = this.mc.func_228018_at_().func_198109_k();
            this.updateFramebufferSize(this.displayWidth, this.displayHeight);
        }
        if (this.shouldRenderBloodVision()) {
            this.adjustBloodVisionShaders(this.getBloodVisionProgress(partialTicks));
            this.blurShader.func_148018_a(partialTicks);
            if (this.bloodVisionBuffer != null) {
                this.bloodVisionBuffer.func_228471_a_();
            }
        }
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        this.reMakeBloodVisionShader();
    }

    private void adjustBloodVisionShaders(float progress) {
        if (this.blit0 == null || this.blur1 == null || this.blur2 == null) {
            return;
        }
        progress = MathHelper.func_76131_a((float)progress, (float)0.0f, (float)1.0f);
        this.blit0.func_217624_b().func_216538_b("ColorModulate").func_148081_a(1.0f - 0.4f * progress, 1.0f - 0.5f * progress, 1.0f - 0.3f * progress, 1.0f);
        this.blur1.func_217624_b().func_216538_b("Radius").func_148090_a((float)Math.round(15.0f * progress) / 1.0f);
        this.blur2.func_217624_b().func_216538_b("Radius").func_148090_a((float)Math.round(15.0f * progress) / 1.0f);
    }

    private void disableProfile(Profile profile) {
        profile.clean();
    }

    private void enableProfile(Profile profile, float progress) {
        progress = MathHelper.func_76131_a((float)progress, (float)0.0f, (float)1.0f);
        profile.apply(progress);
    }

    private void enableProfile(Profile profile) {
        profile.apply(1.0f);
    }

    private float getBloodVisionProgress(float partialTicks) {
        return ((float)this.bloodVisionTicks + (float)(this.bloodVisionTicks - this.lastBloodVisionTicks) * partialTicks) / 80.0f;
    }

    private void reMakeBloodVisionShader() {
        if (this.blurShader != null) {
            this.blurShader.close();
        }
        ResourceLocation resourcelocationBlur = new ResourceLocation("vampirism", "shaders/blank.json");
        try {
            this.blurShader = new ShaderGroup(this.mc.func_110434_K(), this.mc.func_195551_G(), this.mc.func_147110_a(), resourcelocationBlur);
            Framebuffer swap = this.blurShader.func_177066_a("swap");
            this.blit0 = this.blurShader.func_148023_a("blit", swap, this.mc.func_147110_a());
            this.blur1 = this.blurShader.func_148023_a("blur", this.mc.func_147110_a(), swap);
            this.blur1.func_217624_b().func_216538_b("BlurDir").func_148087_a(1.0f, 0.0f);
            this.blur2 = this.blurShader.func_148023_a("blur", swap, this.mc.func_147110_a());
            this.blur2.func_217624_b().func_216538_b("BlurDir").func_148087_a(0.0f, 1.0f);
            this.blurShader.func_148026_a(this.mc.func_228018_at_().func_198109_k(), this.mc.func_228018_at_().func_198091_l());
        }
        catch (Exception e) {
            this.LOGGER.warn("Failed to load blood vision blur shader", (Throwable)e);
            this.blurShader = null;
        }
    }

    private boolean shouldRenderBloodVision() {
        return this.bloodVisionTicks > 0 && this.blurShader != null && this.mc.field_71439_g != null;
    }

    private void updateFramebufferSize(int width, int height) {
        if (this.blurShader != null) {
            this.blurShader.func_148026_a(width, height);
        }
    }

    private static enum Profile {
        HUNTER_DISGUISE{

            @Override
            public void apply(float progress) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - progress * 0.8f));
                if (progress >= 1.0f) {
                    RenderSystem.depthMask((boolean)false);
                }
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                RenderSystem.alphaFunc((int)516, (float)0.003921569f);
            }

            @Override
            public void clean() {
                RenderSystem.disableBlend();
                RenderSystem.alphaFunc((int)516, (float)0.1f);
                RenderSystem.depthMask((boolean)true);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        };


        public abstract void apply(float var1);

        public abstract void clean();
    }
}

