/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.particle;

import de.teamlapen.vampirism.particle.FlyingBloodParticleData;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FlyingBloodParticle
extends SpriteTexturedParticle {
    private final String TAG = "FlyingBloodParticle";
    private final double destX;
    private final double destY;
    private final double destZ;
    private final boolean direct;

    public FlyingBloodParticle(ClientWorld world, double posX, double posY, double posZ, double destX, double destY, double destZ, int maxage, boolean direct, ResourceLocation particleId) {
        super(world, posX, posY, posZ);
        this.field_70547_e = maxage;
        this.destX = destX;
        this.destY = destY;
        this.destZ = destZ;
        this.direct = direct;
        this.field_70552_h = 0.95f;
        this.field_70553_i = 0.05f;
        this.field_70551_j = 0.05f;
        double wayX = destX - this.field_187126_f;
        double wayZ = destZ - this.field_187128_h;
        double wayY = destY - this.field_187127_g;
        if (direct) {
            this.field_187129_i = wayX / (double)maxage;
            this.field_187130_j = wayY / (double)maxage;
            this.field_187131_k = wayZ / (double)maxage;
        } else {
            this.field_187129_i = this.field_187122_b.field_73012_v.nextDouble() / 10.0 - 0.05 + wayX / (double)this.field_70547_e;
            this.field_187130_j = this.field_187122_b.field_73012_v.nextDouble() / 10.0 - 0.01 + wayY / (double)this.field_70547_e;
            this.field_187131_k = this.field_187122_b.field_73012_v.nextDouble() / 10.0 - 0.05 + wayZ / (double)this.field_70547_e;
        }
        this.func_217567_a(Minecraft.func_71410_x().field_71452_i.field_215243_j.func_195424_a(new ResourceLocation(particleId.func_110624_b(), "particle/" + particleId.func_110623_a())));
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        double wayX = this.destX - this.field_187126_f;
        double wayY = this.destY - this.field_187127_g;
        double wayZ = this.destZ - this.field_187128_h;
        int tleft = this.field_70547_e - this.field_70546_d;
        if (this.direct || (double)tleft < (double)this.field_70547_e / 1.2) {
            this.field_187129_i = wayX / (double)tleft;
            this.field_187130_j = wayY / (double)tleft;
            this.field_187131_k = wayZ / (double)tleft;
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (++this.field_70546_d >= this.field_70547_e) {
            this.func_187112_i();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<FlyingBloodParticleData> {
        @Nullable
        public Particle makeParticle(FlyingBloodParticleData typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FlyingBloodParticle(worldIn, x, y, z, typeIn.getTargetX(), typeIn.getTargetY(), typeIn.getTargetZ(), typeIn.getMaxAge(), typeIn.isDirect(), typeIn.getTexturePos());
        }
    }
}

