/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.config;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.config.BalanceConfig;
import de.teamlapen.vampirism.entity.SundamageRegistry;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.LogMarkers;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

public class VampirismConfig {
    public static final Client CLIENT;
    public static final Server SERVER;
    public static final Common COMMON;
    public static final BalanceConfig BALANCE;
    private static final ForgeConfigSpec clientSpec;
    private static final ForgeConfigSpec serverSpec;
    private static final ForgeConfigSpec commonSpec;
    private static final ForgeConfigSpec balanceSpec;

    public static void registerConfigs() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, serverSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, balanceSpec, "vampirism-balance.toml");
        FMLJavaModLoadingContext.get().getModEventBus().register(VampirismConfig.class);
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        LogManager.getLogger().debug(LogMarkers.FORGEMOD, "Loaded forge config file {}", (Object)configEvent.getConfig().getFileName());
        if (configEvent.getConfig().getType() == ModConfig.Type.SERVER) {
            ((SundamageRegistry)VampirismAPI.sundamageRegistry()).reloadConfiguration();
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfig.Reloading configEvent) {
        LogManager.getLogger().fatal(Logging.CORE, "Forge config just got changed on the file system!");
        if (configEvent.getConfig().getType() == ModConfig.Type.SERVER) {
            ((SundamageRegistry)VampirismAPI.sundamageRegistry()).reloadConfiguration();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(BalanceConfig::new);
        balanceSpec = (ForgeConfigSpec)specPair.getRight();
        BALANCE = (BalanceConfig)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue versionCheck;
        public final ForgeConfigSpec.BooleanValue collectStats;
        public final ForgeConfigSpec.ConfigValue<String> integrationsNotifier;
        public final ForgeConfigSpec.BooleanValue useVanillaCampfire;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common configuration settings").push("common");
            this.versionCheck = builder.comment("Check for new versions of Vampirism on startup").define("versionCheck", true);
            this.collectStats = builder.comment("Send mod version, MC version and mod count to mod author").define("collectStats", true);
            this.useVanillaCampfire = builder.comment("Use the vanilla campfire block instead of Vampirism's much cooler one").define("useVanillaCampfire", false);
            this.integrationsNotifier = builder.comment("INTERNAL - Set to 'never' if you don't want to be notified about integration mods").define("integrationsNotifier", (Object)"");
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.IntValue guiLevelOffsetX;
        public final ForgeConfigSpec.IntValue guiLevelOffsetY;
        public final ForgeConfigSpec.BooleanValue guiSkillButton;
        public final ForgeConfigSpec.BooleanValue renderAdvancedMobPlayerFaces;
        public final ForgeConfigSpec.BooleanValue renderVampireEyes;
        public final ForgeConfigSpec.BooleanValue renderVampireForestFog;
        public final ForgeConfigSpec.BooleanValue renderScreenOverlay;
        public final ForgeConfigSpec.ConfigValue<String> actionOrder;
        public final ForgeConfigSpec.BooleanValue disableFovChange;
        public final ForgeConfigSpec.BooleanValue disableBloodVisionRendering;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client configuration settings").push("client");
            builder.comment("Configure rendering").push("render");
            this.renderAdvancedMobPlayerFaces = builder.comment("Render player faces on advanced hunter or vampires").define("advancedMobPlayerFaces", true);
            this.renderVampireEyes = builder.comment("Render vampire eye/fang face overlay").define("vampireEyes", true);
            this.renderVampireForestFog = builder.comment("Render fog in vampire biome. Might be enforced server side").define("vampireForestFog", true);
            this.renderScreenOverlay = builder.comment("Render screen overlay. Don't disable").define("screenOverlay", true);
            builder.pop();
            builder.comment("Configure GUI").push("gui");
            this.guiLevelOffsetX = builder.comment("X-Offset of the level indicator from the center in pixels").defineInRange("levelOffsetX", 0, -250, 250);
            this.guiLevelOffsetY = builder.comment("Y-Offset of the level indicator from the bottom in pixels").defineInRange("levelOffsetY", 47, 0, 270);
            this.guiSkillButton = builder.comment("Render skill menu button in inventory").define("skillButtonEnable", true);
            this.actionOrder = builder.comment("Action Order in Select Action Screen (reset with \"\"), unnamed actions will appended").define("actionOrder", (Object)"");
            this.disableFovChange = builder.comment("Disable the FOV change caused by the speed buf for vampire players").define("disableFovChange", false);
            this.disableBloodVisionRendering = builder.comment("Disable the effect of blood vision. It can still be unlocked and activated but does not have any effect").define("disableBloodVisionRendering", false);
            builder.pop();
            builder.pop();
        }
    }

    public static class Server {
        public final ForgeConfigSpec.BooleanValue enforceRenderForestFog;
        public final ForgeConfigSpec.IntValue coffinSleepPercentage;
        public final ForgeConfigSpec.BooleanValue batModeInEnd;
        public final ForgeConfigSpec.BooleanValue unlockAllSkills;
        public final ForgeConfigSpec.BooleanValue pvpOnlyBetweenFactions;
        public final ForgeConfigSpec.IntValue sunscreenBeaconDistance;
        public final ForgeConfigSpec.BooleanValue sunscreenBeaconMineable;
        public final ForgeConfigSpec.BooleanValue autoCalculateEntityBlood;
        public final ForgeConfigSpec.BooleanValue autoConvertGlassBottles;
        public final ForgeConfigSpec.BooleanValue playerCanTurnPlayer;
        public final ForgeConfigSpec.BooleanValue factionColorInChat;
        public final ForgeConfigSpec.EnumValue<IMobOptions> entityIMob;
        public final ForgeConfigSpec.BooleanValue umbrella;
        public final ForgeConfigSpec.BooleanValue sundamageUnknownDimension;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> sundamageDimensionsOverridePositive;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> sundamageDimensionsOverrideNegative;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> sundamageDisabledBiomes;
        public final ForgeConfigSpec.IntValue villageDistance;
        public final ForgeConfigSpec.IntValue villageSeparation;
        public final ForgeConfigSpec.BooleanValue villageModify;
        public final ForgeConfigSpec.BooleanValue disableFangInfection;
        public final ForgeConfigSpec.BooleanValue disableMobBiteInfection;
        public final ForgeConfigSpec.BooleanValue disableHalloweenSpecial;
        public final ForgeConfigSpec.BooleanValue disableVampireForest;
        public final ForgeConfigSpec.BooleanValue disableHunterTentGen;
        public final ForgeConfigSpec.BooleanValue infoAboutGuideAPI;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server configuration settings").push("server");
            this.enforceRenderForestFog = builder.comment("Prevent clients from disabling the vampire forest fog").define("enforceForestFog", true);
            this.coffinSleepPercentage = builder.comment("Percentage of players that have to lay in a coffin to make it night.  Be careful with values below 51 if e.g. Morpheus is installed").defineInRange("coffinSleepPercentage", 100, 1, 100);
            this.batModeInEnd = builder.comment("If vampires can convert to a bat in the End").define("batModeInEnd", false);
            this.pvpOnlyBetweenFactions = builder.comment("If PVP should only be allowed between factions. PVP has to be enabled in the server properties for this. Not guaranteed to always protect player from teammates").define("pvpOnlyBetweenFactions", false);
            this.sunscreenBeaconDistance = builder.comment("Block radius the sunscreen beacon affects").defineInRange("sunscreenBeaconDistance", 32, 1, 40000);
            this.sunscreenBeaconMineable = builder.comment("Whether the suncreen beacon can be mined in survival").define("sunscreenBeaconMineable", false);
            this.autoCalculateEntityBlood = builder.comment("Calculate the blood level for unknown creatures based on their size").define("autoCalculateEntityBlood", true);
            this.autoConvertGlassBottles = builder.comment("Whether glass bottles should be automatically be converted to blood bottles when needed").define("autoConvertGlassBottles", true);
            this.playerCanTurnPlayer = builder.comment("Whether players can infect other players").define("playersCanTurnPlayers", true);
            this.factionColorInChat = builder.comment("Whether to color player names in chat based on their current faction").define("factionColorInChat", true);
            this.entityIMob = builder.comment("Changes if entities are recognized as hostile by other mods. See https://github.com/TeamLapen/Vampirism/issues/199. Smart falls back to Never on servers ").defineEnum("entitiesIMob", (Enum)IMobOptions.SMART);
            this.umbrella = builder.comment("If enabled adds a craftable umbrella that can be used to slowly walk though sunlight without taking damage").define("umbrella", false);
            builder.push("sundamage");
            this.sundamageUnknownDimension = builder.comment("Whether vampires should receive sundamage in unknown dimensions").define("sundamageUnknownDimension", false);
            this.sundamageDimensionsOverridePositive = builder.comment("Add the string id in quotes of any dimension (/vampirism currentDimension) you want to enforce sundamage for to this comma-separated list. Overrides defaults and values added by other mods").defineList("sundamageDimensionsOverridePositive", Collections.emptyList(), o -> {
                if (o instanceof String) {
                    try {
                        new ResourceLocation((String)o);
                        return true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            });
            this.sundamageDimensionsOverrideNegative = builder.comment("Add the string id in quotes of any dimension (/vampirism currentDimension) you want to disable sundamage for to this comma-separated list. Overrides defaults and values added by other mods").defineList("sundamageDimensionsOverrideNegative", Collections.emptyList(), object -> {
                if (object instanceof String) {
                    try {
                        new ResourceLocation((String)object);
                        return true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            });
            this.sundamageDisabledBiomes = builder.comment("Additional biomes the player should not get sundamage in. Use biome ids e.g. 'minecraft:mesa'").defineList("sundamageDisabledBiomes", Collections.emptyList(), object -> {
                if (object instanceof String) {
                    try {
                        new ResourceLocation((String)object);
                        return true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            });
            builder.pop();
            builder.push("village");
            this.villageModify = builder.comment("Whether to modify the village world gen (size and frequency)").define("villageModify", true);
            this.villageDistance = builder.comment("Village distance").defineInRange("villageDistance", 32, 1, 100);
            this.villageSeparation = builder.comment("Village centers will be at least N chunks apart. Must be smaller than distance").defineInRange("villageSeparation", 8, 1, 100);
            builder.pop();
            builder.push("cheats");
            this.unlockAllSkills = builder.comment("CHEAT: If enabled, you will be able to unlock all skills at max level").define("allSkillsAtMaxLevel", false);
            builder.pop();
            builder.comment("Disabling these things might reduce fun or interfere with gameplay");
            builder.push("disable");
            this.disableFangInfection = builder.comment("Disable vampire fangs being usable to infect yourself").define("disableFangInfection", false);
            this.disableHalloweenSpecial = builder.comment("Disable Halloween special event").define("disableHalloweenSpecialEvent", false);
            this.disableMobBiteInfection = builder.comment("Prevent vampire mobs from infecting players when attacking").define("disableMobBiteInfection", false);
            this.disableVampireForest = builder.comment("Disable vampire forest generation").define("disableVampireForest", false);
            this.disableHunterTentGen = builder.comment("Disable hunter camp generation").define("disableHunterTentGen", false);
            builder.pop();
            builder.push("internal");
            this.infoAboutGuideAPI = builder.comment("Send message about Guide-API once").define("infoAboutGuideAPI", true);
            builder.pop();
            builder.pop();
        }

        public static enum IMobOptions {
            ALWAYS_IMOB,
            NEVER_IMOB,
            SMART;

        }
    }
}

