/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.potion.PotionFreeze;
import de.teamlapen.vampirism.potion.PotionPoison;
import de.teamlapen.vampirism.potion.PotionSanguinare;
import de.teamlapen.vampirism.potion.PotionThirst;
import de.teamlapen.vampirism.potion.VampirismNightVisionPotion;
import de.teamlapen.vampirism.potion.VampirismPotion;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potions;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ObjectHolder(value="vampirism")
public class ModEffects {
    public static final Effect sanguinare = (Effect)UtilLib.getNull();
    public static final Effect thirst = (Effect)UtilLib.getNull();
    public static final Effect saturation = (Effect)UtilLib.getNull();
    public static final Effect sunscreen = (Effect)UtilLib.getNull();
    public static final Effect disguise_as_vampire = (Effect)UtilLib.getNull();
    public static final Effect fire_protection = (Effect)UtilLib.getNull();
    public static final Effect garlic = (Effect)UtilLib.getNull();
    public static final Effect poison = (Effect)UtilLib.getNull();
    public static final Effect freeze = (Effect)UtilLib.getNull();
    private static final Logger LOGGER = LogManager.getLogger(ModEffects.class);
    private static Effect modded_night_vision;
    private static Effect vanilla_night_vision;

    static void registerEffects(IForgeRegistry<Effect> registry) {
        vanilla_night_vision = Effects.field_76439_r;
        registry.register((IForgeRegistryEntry)new VampirismNightVisionPotion());
        registry.register((IForgeRegistryEntry)new PotionThirst("thirst", EffectType.HARMFUL, 859494));
        registry.register((IForgeRegistryEntry)new PotionSanguinare("sanguinare", EffectType.NEUTRAL, 6949000));
        registry.register((IForgeRegistryEntry)new VampirismPotion("saturation", EffectType.BENEFICIAL, 14483200));
        registry.register((IForgeRegistryEntry)new VampirismPotion("sunscreen", EffectType.BENEFICIAL, 0xFFF100).func_220304_a((Attribute)ModAttributes.sundamage, "9dc9420c-3e5e-41c7-9ba4-ff70e9dc69fc", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
        registry.register((IForgeRegistryEntry)new VampirismPotion("fire_protection", EffectType.BENEFICIAL, 14981690));
        registry.register((IForgeRegistryEntry)new VampirismPotion("disguise_as_vampire", EffectType.NEUTRAL, 0x999900));
        registry.register((IForgeRegistryEntry)new VampirismPotion("garlic", EffectType.HARMFUL, 0xFFFFFF));
        registry.register((IForgeRegistryEntry)new PotionPoison("poison", 5149489));
        registry.register((IForgeRegistryEntry)new PotionFreeze("freeze"));
    }

    static void fixNightVisionEffecTypes() {
        LOGGER.info("Fixing vanilla night vision potion types");
        try {
            for (EffectInstance effect : Potions.field_185234_f.func_185170_a()) {
                if (!effect.func_188419_a().equals(vanilla_night_vision)) continue;
                ObfuscationReflectionHelper.setPrivateValue(EffectInstance.class, (Object)effect, (Object)modded_night_vision, (String)"field_188420_b");
            }
            for (EffectInstance effect : Potions.field_185235_g.func_185170_a()) {
                if (!effect.func_188419_a().equals(vanilla_night_vision)) continue;
                ObfuscationReflectionHelper.setPrivateValue(EffectInstance.class, (Object)effect, (Object)modded_night_vision, (String)"field_188420_b");
            }
        }
        catch (ObfuscationReflectionHelper.UnableToAccessFieldException e) {
            LOGGER.error("Unable to modify vanilla night vision types. Potion tileInventory and more might not work", (Throwable)e);
        }
    }

    static boolean checkNightVision() {
        if (!(Effects.field_76439_r instanceof VampirismNightVisionPotion)) {
            LOGGER.warn("Vampirism was not able to register it's night vision potion");
            return false;
        }
        return true;
    }
}

