/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.util.ASMHooks;
import de.teamlapen.vampirism.world.gen.util.BiomeTopBlockProcessor;
import de.teamlapen.vampirism.world.gen.util.RandomBlockState;
import de.teamlapen.vampirism.world.gen.util.RandomStructureProcessor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;
import net.minecraft.world.gen.feature.template.AlwaysTrueRuleTest;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.BlockStateMatchRuleTest;
import net.minecraft.world.gen.feature.template.RandomBlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleEntry;
import net.minecraft.world.gen.feature.template.RuleStructureProcessor;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModWorld {
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean debug = false;

    public static void addVillageStructures() {
        ModWorld.setupSingleJigsawPieceGeneration();
        PlainsVillagePools.func_214744_a();
        SnowyVillagePools.func_214746_a();
        SavannaVillagePools.func_214745_a();
        DesertVillagePools.func_222739_a();
        TaigaVillagePools.func_214806_a();
        HashMap<String, JigsawPattern> patterns = new HashMap<String, JigsawPattern>(){
            {
                this.put("plains", JigsawManager.field_214891_a.func_214933_a(new ResourceLocation("village/plains/houses")));
                this.put("desert", JigsawManager.field_214891_a.func_214933_a(new ResourceLocation("village/desert/houses")));
                this.put("savanna", JigsawManager.field_214891_a.func_214933_a(new ResourceLocation("village/savanna/houses")));
                this.put("taiga", JigsawManager.field_214891_a.func_214933_a(new ResourceLocation("village/taiga/houses")));
                this.put("snowy", JigsawManager.field_214891_a.func_214933_a(new ResourceLocation("village/snowy/houses")));
                this.put("plains_zombie", JigsawManager.field_214891_a.func_214933_a(new ResourceLocation("village/plains/zombie/houses")));
                this.put("desert_zombie", JigsawManager.field_214891_a.func_214933_a(new ResourceLocation("village/desert/zombie/houses")));
                this.put("savanna_zombie", JigsawManager.field_214891_a.func_214933_a(new ResourceLocation("village/savanna/zombie/houses")));
                this.put("taiga_zombie", JigsawManager.field_214891_a.func_214933_a(new ResourceLocation("village/taiga/zombie/houses")));
                this.put("snowy_zombie", JigsawManager.field_214891_a.func_214933_a(new ResourceLocation("village/snowy/zombie/houses")));
            }
        };
        HashMap buildings = Maps.newHashMapWithExpectedSize((int)patterns.size());
        patterns.forEach((biome, pattern) -> {
            List cfr_ignored_0 = buildings.put(biome, Lists.newArrayList((Iterable)pattern.field_214952_d));
        });
        ModWorld.replaceTemples(buildings);
        ModWorld.addHunterTrainerHouse(buildings);
        ModWorld.addTotem(buildings);
        ModWorld.saveChanges(buildings, (Map<String, JigsawPattern>)patterns);
    }

    private static void replaceTemples(Map<String, List<Pair<JigsawPiece, Integer>>> buildings) {
        final ImmutableList plainsProcessor = ImmutableList.of((Object)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150347_e, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150341_Y.func_176223_P()))));
        final ImmutableList taigaProcessor = ImmutableList.of((Object)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150347_e, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150341_Y.func_176223_P()))));
        final ImmutableList plainsZombieProcessor = ImmutableList.of((Object)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150347_e, 0.8f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150341_Y.func_176223_P()), (Object)new RuleEntry((RuleTest)new TagMatchRuleTest((ITag)BlockTags.field_200029_f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150478_aa), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196591_bQ), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150347_e, 0.07f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150341_Y, 0.07f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196777_fo, 0.07f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196617_K, 0.05f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196662_n, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150476_ad, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_203204_R, 0.02f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150410_aZ, 0.5f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object[])new RuleEntry[]{new RuleEntry((RuleTest)new BlockStateMatchRuleTest((BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)((BlockState)Blocks.field_196773_gL.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true))), new RuleEntry((RuleTest)new BlockStateMatchRuleTest((BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)((BlockState)Blocks.field_196773_gL.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true))), new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.3f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150459_bM.func_176223_P()), new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.2f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150469_bN.func_176223_P()), new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_185773_cZ.func_176223_P())})));
        final ImmutableList desertZombieProcessor = ImmutableList.of((Object)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new TagMatchRuleTest((ITag)BlockTags.field_200029_f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150478_aa), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196591_bQ), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196580_bH, 0.08f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196585_ak, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150405_ch, 0.08f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_222439_lc, 0.08f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_222452_lp, 0.08f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.2f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_185773_cZ.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150394_bc.func_176223_P()))));
        final ImmutableList savannaZombieProcessor = ImmutableList.of((Object)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new TagMatchRuleTest((ITag)BlockTags.field_200029_f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150478_aa), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196591_bQ), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196670_r, 0.2f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150400_ck, 0.2f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196621_O, 0.05f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196637_U, 0.05f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196778_fp, 0.05f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196783_fs, 0.05f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196721_fC, 0.05f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150410_aZ, 0.5f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockStateMatchRuleTest((BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)((BlockState)Blocks.field_196773_gL.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true))), (Object[])new RuleEntry[]{new RuleEntry((RuleTest)new BlockStateMatchRuleTest((BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)((BlockState)Blocks.field_196773_gL.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true))), new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150394_bc.func_176223_P())})));
        final ImmutableList taigaZombieProcessor = ImmutableList.of((Object)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150347_e, 0.8f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150341_Y.func_176223_P()), (Object)new RuleEntry((RuleTest)new TagMatchRuleTest((ITag)BlockTags.field_200029_f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150478_aa), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196591_bQ), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_222433_lV), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)Blocks.field_222433_lV.func_176223_P().func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false))), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150347_e, 0.08f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196618_L, 0.08f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150410_aZ, 0.5f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockStateMatchRuleTest((BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)((BlockState)Blocks.field_196773_gL.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true))), (Object)new RuleEntry((RuleTest)new BlockStateMatchRuleTest((BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)((BlockState)Blocks.field_196773_gL.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true))), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.3f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150393_bb.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.2f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150469_bN.func_176223_P()), (Object[])new RuleEntry[0])));
        final ImmutableList snowyZombieProcessor = ImmutableList.of((Object)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new TagMatchRuleTest((ITag)BlockTags.field_200029_f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150478_aa), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196591_bQ), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_222432_lU), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196664_o, 0.2f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196624_br, 0.4f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_203205_S, 0.05f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_209390_ac, 0.05f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150410_aZ, 0.5f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockStateMatchRuleTest((BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)((BlockState)Blocks.field_196773_gL.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true))), (Object)new RuleEntry((RuleTest)new BlockStateMatchRuleTest((BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)((BlockState)Blocks.field_196773_gL.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true))), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150459_bM.func_176223_P()), (Object[])new RuleEntry[]{new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.8f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150469_bN.func_176223_P())})));
        HashMap<String, Map<String, JigsawPiece>> temples = new HashMap<String, Map<String, JigsawPiece>>(){
            {
                this.put("plains", ImmutableMap.of((Object)ModWorld.singleJigsawString("minecraft:village/plains/houses/plains_temple_3"), (Object)ModWorld.singleJigsawPiece("village/plains/houses/plains_temple_3", (List)plainsProcessor), (Object)ModWorld.singleJigsawString("minecraft:village/plains/houses/plains_temple_4"), (Object)ModWorld.singleJigsawPiece("village/plains/houses/plains_temple_4", (List)plainsProcessor)));
                this.put("desert", ImmutableMap.of((Object)ModWorld.singleJigsawString("minecraft:village/desert/houses/desert_temple_1"), (Object)ModWorld.singleJigsawPiece("village/desert/houses/desert_temple_1"), (Object)ModWorld.singleJigsawString("minecraft:village/desert/houses/desert_temple_2"), (Object)ModWorld.singleJigsawPiece("village/desert/houses/desert_temple_2")));
                this.put("savanna", ImmutableMap.of((Object)ModWorld.singleJigsawString("minecraft:village/savanna/houses/savanna_temple_1"), (Object)ModWorld.singleJigsawPiece("village/savanna/houses/savanna_temple_1"), (Object)ModWorld.singleJigsawString("minecraft:village/savanna/houses/savanna_temple_2"), (Object)ModWorld.singleJigsawPiece("village/savanna/houses/savanna_temple_2")));
                this.put("taiga", ImmutableMap.of((Object)ModWorld.singleJigsawString("minecraft:village/taiga/houses/taiga_temple_1"), (Object)ModWorld.singleJigsawPiece("village/taiga/houses/taiga_temple_1", (List)taigaProcessor)));
                this.put("snowy", ImmutableMap.of((Object)ModWorld.singleJigsawString("minecraft:village/snowy/houses/snowy_temple_1"), (Object)ModWorld.singleJigsawPiece("village/snowy/houses/snowy_temple_1")));
                this.put("plains_zombie", ImmutableMap.of((Object)ModWorld.singleJigsawString("minecraft:village/plains/houses/plains_temple_3"), (Object)ModWorld.singleJigsawPiece("village/plains/houses/plains_temple_3", (List)plainsZombieProcessor), (Object)ModWorld.singleJigsawString("minecraft:village/plains/houses/plains_temple_4"), (Object)ModWorld.singleJigsawPiece("village/plains/houses/plains_temple_4", (List)plainsZombieProcessor)));
                this.put("desert_zombie", ImmutableMap.of((Object)ModWorld.singleJigsawString("minecraft:village/desert/houses/desert_temple_1"), (Object)ModWorld.singleJigsawPiece("village/desert/houses/desert_temple_1", (List)desertZombieProcessor), (Object)ModWorld.singleJigsawString("minecraft:village/desert/houses/desert_temple_2"), (Object)ModWorld.singleJigsawPiece("village/desert/houses/desert_temple_2", (List)desertZombieProcessor)));
                this.put("savanna_zombie", ImmutableMap.of((Object)ModWorld.singleJigsawString("minecraft:village/savanna/houses/savanna_temple_1"), (Object)ModWorld.singleJigsawPiece("village/savanna/houses/savanna_temple_1", (List)savannaZombieProcessor), (Object)ModWorld.singleJigsawString("minecraft:village/savanna/houses/savanna_temple_2"), (Object)ModWorld.singleJigsawPiece("village/savanna/houses/savanna_temple_2", (List)savannaZombieProcessor)));
                this.put("taiga_zombie", ImmutableMap.of((Object)ModWorld.singleJigsawString("minecraft:village/taiga/zombie/houses/taiga_temple_1"), (Object)ModWorld.singleJigsawPiece("village/taiga/houses/taiga_temple_1", (List)taigaZombieProcessor)));
                this.put("snowy_zombie", ImmutableMap.of((Object)ModWorld.singleJigsawString("minecraft:village/snowy/houses/snowy_temple_1"), (Object)ModWorld.singleJigsawPiece("village/snowy/houses/snowy_temple_1", (List)snowyZombieProcessor)));
            }
        };
        HashMap allPieces = Maps.newHashMapWithExpectedSize((int)temples.size());
        temples.forEach((biome, replacer) -> ((List)buildings.get(biome)).removeIf(house -> {
            if (replacer.containsKey(((JigsawPiece)house.getFirst()).toString())) {
                allPieces.computeIfAbsent(biome, key -> Lists.newArrayList()).add(Pair.of(replacer.get(((JigsawPiece)house.getFirst()).toString()), (Object)house));
                return true;
            }
            return false;
        }));
        if (allPieces.size() > temples.size()) {
            LOGGER.error("Could not find all temples to replace");
        }
        temples.forEach((biome, replacer) -> replacer.values().forEach(piece -> {
            if (allPieces.containsKey(biome)) {
                ((List)allPieces.get(biome)).forEach(pair -> {
                    if (pair.getFirst() == piece) {
                        int weight = Math.max((int)((double)((Integer)((Pair)pair.getSecond()).getSecond()).intValue() * 0.6), 1);
                        ((List)buildings.get(biome)).add(Pair.of((Object)piece, (Object)weight));
                        ((List)buildings.get(biome)).add(Pair.of((Object)((Pair)pair.getSecond()).getFirst(), (Object)weight));
                    }
                });
            }
        }));
    }

    private static void addHunterTrainerHouse(Map<String, List<Pair<JigsawPiece, Integer>>> buildings) {
        ImmutableList plainsZombieProcessor = ImmutableList.of((Object)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150347_e, 0.8f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150341_Y.func_176223_P()), (Object)new RuleEntry((RuleTest)new TagMatchRuleTest((ITag)BlockTags.field_200029_f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150478_aa), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196591_bQ), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150347_e, 0.07f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150341_Y, 0.07f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196777_fo, 0.07f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196617_K, 0.05f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196662_n, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150476_ad, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_203204_R, 0.02f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150410_aZ, 0.5f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object[])new RuleEntry[]{new RuleEntry((RuleTest)new BlockStateMatchRuleTest((BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)((BlockState)Blocks.field_196773_gL.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true))), new RuleEntry((RuleTest)new BlockStateMatchRuleTest((BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)((BlockState)Blocks.field_196773_gL.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true))), new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.3f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150459_bM.func_176223_P()), new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.2f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150469_bN.func_176223_P()), new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_185773_cZ.func_176223_P())})));
        ImmutableList desertZombieProcessor = ImmutableList.of((Object)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new TagMatchRuleTest((ITag)BlockTags.field_200029_f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150478_aa), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196591_bQ), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196580_bH, 0.08f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196585_ak, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150405_ch, 0.08f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_222439_lc, 0.08f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_222452_lp, 0.08f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.2f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_185773_cZ.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150394_bc.func_176223_P()))));
        ImmutableList savannaZombieProcessor = ImmutableList.of((Object)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new TagMatchRuleTest((ITag)BlockTags.field_200029_f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150478_aa), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196591_bQ), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196670_r, 0.2f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150400_ck, 0.2f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196621_O, 0.05f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196637_U, 0.05f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196778_fp, 0.05f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196783_fs, 0.05f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196721_fC, 0.05f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150410_aZ, 0.5f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockStateMatchRuleTest((BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)((BlockState)Blocks.field_196773_gL.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true))), (Object[])new RuleEntry[]{new RuleEntry((RuleTest)new BlockStateMatchRuleTest((BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)((BlockState)Blocks.field_196773_gL.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true))), new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150394_bc.func_176223_P())})));
        ImmutableList taigaZombieProcessor = ImmutableList.of((Object)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150347_e, 0.8f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150341_Y.func_176223_P()), (Object)new RuleEntry((RuleTest)new TagMatchRuleTest((ITag)BlockTags.field_200029_f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150478_aa), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196591_bQ), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_222433_lV), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)Blocks.field_222433_lV.func_176223_P().func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false))), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150347_e, 0.08f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196618_L, 0.08f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150410_aZ, 0.5f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockStateMatchRuleTest((BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)((BlockState)Blocks.field_196773_gL.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true))), (Object)new RuleEntry((RuleTest)new BlockStateMatchRuleTest((BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)((BlockState)Blocks.field_196773_gL.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true))), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.3f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150393_bb.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.2f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150469_bN.func_176223_P()), (Object[])new RuleEntry[0])));
        ImmutableList snowyZombieProcessor = ImmutableList.of((Object)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new TagMatchRuleTest((ITag)BlockTags.field_200029_f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150478_aa), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196591_bQ), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_222432_lU), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150350_a.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196664_o, 0.2f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_196624_br, 0.4f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_203205_S, 0.05f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_209390_ac, 0.05f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150410_aZ, 0.5f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196553_aF.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockStateMatchRuleTest((BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)((BlockState)Blocks.field_196773_gL.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true))), (Object)new RuleEntry((RuleTest)new BlockStateMatchRuleTest((BlockState)((BlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true))), (RuleTest)AlwaysTrueRuleTest.field_215190_a, (BlockState)((BlockState)Blocks.field_196773_gL.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true))), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150459_bM.func_176223_P()), (Object[])new RuleEntry[]{new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_150464_aj, 0.8f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_150469_bN.func_176223_P())})));
        JigsawManager.field_214891_a.func_214932_a(new JigsawPattern(new ResourceLocation("vampirism", "village/entities/hunter_trainer"), new ResourceLocation("empty"), (List)Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)ModWorld.singleJigsawPiece("village/entities/hunter_trainer"), (Object)1)}), JigsawPattern.PlacementBehaviour.RIGID));
        buildings.get("desert").add((Pair<JigsawPiece, Integer>)Pair.of((Object)ModWorld.singleJigsawPiece("village/desert/houses/hunter_trainer"), (Object)VampirismConfig.BALANCE.viHunterTrainerWeight.get()));
        buildings.get("plains").add((Pair<JigsawPiece, Integer>)Pair.of((Object)ModWorld.singleJigsawPiece("village/plains/houses/hunter_trainer"), (Object)VampirismConfig.BALANCE.viHunterTrainerWeight.get()));
        buildings.get("savanna").add((Pair<JigsawPiece, Integer>)Pair.of((Object)ModWorld.singleJigsawPiece("village/savanna/houses/hunter_trainer"), (Object)VampirismConfig.BALANCE.viHunterTrainerWeight.get()));
        buildings.get("snowy").add((Pair<JigsawPiece, Integer>)Pair.of((Object)ModWorld.singleJigsawPiece("village/snowy/houses/hunter_trainer"), (Object)VampirismConfig.BALANCE.viHunterTrainerWeight.get()));
        buildings.get("taiga").add((Pair<JigsawPiece, Integer>)Pair.of((Object)ModWorld.singleJigsawPiece("village/taiga/houses/hunter_trainer"), (Object)VampirismConfig.BALANCE.viHunterTrainerWeight.get()));
        buildings.get("desert_zombie").add((Pair<JigsawPiece, Integer>)Pair.of((Object)ModWorld.singleJigsawPiece("village/desert/houses/hunter_trainer", (List<StructureProcessor>)desertZombieProcessor), (Object)VampirismConfig.BALANCE.viHunterTrainerWeight.get()));
        buildings.get("plains_zombie").add((Pair<JigsawPiece, Integer>)Pair.of((Object)ModWorld.singleJigsawPiece("village/plains/houses/hunter_trainer", (List<StructureProcessor>)plainsZombieProcessor), (Object)VampirismConfig.BALANCE.viHunterTrainerWeight.get()));
        buildings.get("savanna_zombie").add((Pair<JigsawPiece, Integer>)Pair.of((Object)ModWorld.singleJigsawPiece("village/savanna/houses/hunter_trainer", (List<StructureProcessor>)savannaZombieProcessor), (Object)VampirismConfig.BALANCE.viHunterTrainerWeight.get()));
        buildings.get("snowy_zombie").add((Pair<JigsawPiece, Integer>)Pair.of((Object)ModWorld.singleJigsawPiece("village/snowy/houses/hunter_trainer", (List<StructureProcessor>)snowyZombieProcessor), (Object)VampirismConfig.BALANCE.viHunterTrainerWeight.get()));
        buildings.get("taiga_zombie").add((Pair<JigsawPiece, Integer>)Pair.of((Object)ModWorld.singleJigsawPiece("village/taiga/houses/hunter_trainer", (List<StructureProcessor>)taigaZombieProcessor), (Object)VampirismConfig.BALANCE.viHunterTrainerWeight.get()));
    }

    private static void addTotem(Map<String, List<Pair<JigsawPiece, Integer>>> buildings) {
        RandomStructureProcessor totemProcessor = new RandomStructureProcessor((List<RandomBlockState>)ImmutableList.of((Object)((Object)new RandomBlockState((RuleTest)new RandomBlockMatchRuleTest((Block)ModBlocks.totem_top, ((Double)VampirismConfig.BALANCE.viTotemPreSetPercentage.get()).floatValue()), (RuleTest)AlwaysTrueRuleTest.field_215190_a, ModBlocks.totem_top_vampirism_hunter.func_176223_P(), ModBlocks.totem_top_vampirism_vampire.func_176223_P()))));
        BiomeTopBlockProcessor totemTopBlock = new BiomeTopBlockProcessor(Blocks.field_222459_lw.func_176223_P());
        SingleJigsawPiece totem = ModWorld.singleJigsawPiece("village/totem", Lists.newArrayList((Object[])new StructureProcessor[]{totemProcessor, totemTopBlock}));
        buildings.values().forEach(arg_0 -> ModWorld.lambda$addTotem$7((JigsawPiece)totem, arg_0));
    }

    private static void setupSingleJigsawPieceGeneration() {
        ASMHooks.addSingleInstanceStructure(Lists.newArrayList((Object[])new String[]{ModWorld.singleJigsawString("vampirism:village/totem"), ModWorld.singleJigsawString("vampirism:village/desert/houses/hunter_trainer"), ModWorld.singleJigsawString("vampirism:village/plains/houses/hunter_trainer"), ModWorld.singleJigsawString("vampirism:village/snowy/houses/hunter_trainer"), ModWorld.singleJigsawString("vampirism:village/savanna/houses/hunter_trainer"), ModWorld.singleJigsawString("vampirism:village/taiga/houses/hunter_trainer")}));
    }

    private static void saveChanges(Map<String, List<Pair<JigsawPiece, Integer>>> buildings, Map<String, JigsawPattern> patterns) {
        buildings.forEach((biome, list) -> {
            ((JigsawPattern)patterns.get((Object)biome)).field_214952_d = ImmutableList.copyOf((Collection)list);
        });
        patterns.values().forEach(pattern -> {
            pattern.field_214953_e.clear();
            pattern.field_214952_d.forEach(pair -> {
                for (int i = 0; i < (Integer)pair.getSecond(); ++i) {
                    pattern.field_214953_e.add(pair.getFirst());
                }
            });
        });
    }

    private static SingleJigsawPiece singleJigsawPiece(@Nonnull String path) {
        return ModWorld.singleJigsawPiece(path, (List<StructureProcessor>)ImmutableList.of());
    }

    private static SingleJigsawPiece singleJigsawPiece(@Nonnull String path, @Nonnull List<StructureProcessor> processors) {
        return new SingleJigsawPiece("vampirism:" + path, processors);
    }

    private static String singleJigsawString(String resourceLocation) {
        return "Single[Left[" + resourceLocation + "]]";
    }

    private static /* synthetic */ void lambda$addTotem$7(JigsawPiece totem, List list) {
        list.add(Pair.of((Object)totem, (Object)VampirismConfig.BALANCE.viTotemWeight.get()));
    }
}

