/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.hunter.IHunter;
import de.teamlapen.vampirism.api.items.IFactionSlayerItem;
import de.teamlapen.vampirism.blocks.CastleBricksBlock;
import de.teamlapen.vampirism.blocks.CastleSlabBlock;
import de.teamlapen.vampirism.blocks.CastleStairsBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.goals.GolemTargetVampireGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.inventory.container.BloodPotionTableContainer;
import de.teamlapen.vampirism.items.VampirismVampireSword;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.tileentity.TotemTileEntity;
import de.teamlapen.vampirism.util.DifficultyCalculator;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.REFERENCE;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModEntityEventHandler {
    private static final Logger LOGGER = LogManager.getLogger(ModEntityEventHandler.class);
    private boolean skipAttackDamageOnceServer = false;
    private boolean skipAttackDamageOnceClient = false;
    private boolean warnAboutCreeper = true;
    private boolean warnAboutZombie = true;
    private boolean warnAboutGolem = true;

    @SubscribeEvent
    public void onAttachCapabilityEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof CreatureEntity) {
            event.addCapability(REFERENCE.EXTENDED_CREATURE_KEY, ExtendedCreature.createNewCapability((CreatureEntity)event.getObject()));
        }
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        boolean client = EffectiveSide.get().isClient();
        if (!(!client ? this.skipAttackDamageOnceServer : this.skipAttackDamageOnceClient)) {
            ItemStack stack;
            if ("player".equals(event.getSource().func_76355_l()) && event.getSource().func_76346_g() instanceof PlayerEntity && !(stack = ((PlayerEntity)event.getSource().func_76346_g()).func_184614_ca()).func_190926_b() && stack.func_77973_b() instanceof IFactionSlayerItem) {
                IFactionSlayerItem item = (IFactionSlayerItem)stack.func_77973_b();
                IFaction faction = VampirismAPI.factionRegistry().getFaction(event.getEntity());
                if (faction != null && faction.equals(item.getSlayedFaction())) {
                    float amt = event.getAmount() * item.getDamageMultiplierForFaction(stack);
                    if (client) {
                        this.skipAttackDamageOnceClient = true;
                    } else {
                        this.skipAttackDamageOnceServer = true;
                    }
                    boolean result = event.getEntityLiving().func_70097_a(event.getSource(), amt);
                    if (client) {
                        this.skipAttackDamageOnceClient = false;
                    } else {
                        this.skipAttackDamageOnceServer = false;
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        BlockPos pos = new BlockPos(event.getX() - (double)0.4f, event.getY(), event.getZ() - (double)0.4f).func_177977_b();
        if (!event.getWorld().func_175667_e(pos)) {
            return;
        }
        BlockState blockState = event.getWorld().func_180495_p(pos);
        Block b = blockState.func_177230_c();
        boolean deny = false;
        CastleBricksBlock.EnumVariant v = null;
        if (b instanceof CastleBricksBlock) {
            deny = true;
            v = ((CastleBricksBlock)b).getVariant();
        } else if (b instanceof CastleSlabBlock) {
            deny = true;
            v = ((CastleSlabBlock)b).getVariant();
        } else if (b instanceof CastleStairsBlock) {
            deny = true;
            v = ((CastleStairsBlock)b).getVariant();
        }
        if (deny && (v == CastleBricksBlock.EnumVariant.DARK_STONE || event.getEntity().getClassification(false) != VReference.VAMPIRE_CREATURE_TYPE)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().func_201670_d()) {
            TileEntity tileEntity;
            BlockPos pos;
            StructureStart<?> structure;
            Goal target;
            IAdjustableLevel entity2;
            if (event.getEntity() instanceof IAdjustableLevel && (entity2 = (IAdjustableLevel)event.getEntity()).getLevel() == -1) {
                Difficulty d = DifficultyCalculator.findDifficultyForPos(event.getWorld(), event.getEntity().func_233580_cy_(), 30);
                int l = entity2.suggestLevel(d);
                if (l > entity2.getMaxLevel()) {
                    l = entity2.getMaxLevel();
                } else if (l < 0) {
                    event.setCanceled(true);
                }
                entity2.setLevel(l);
                if (entity2 instanceof CreatureEntity) {
                    ((CreatureEntity)entity2).func_70606_j(((CreatureEntity)entity2).func_110138_aP());
                }
            }
            if (!((Boolean)VampirismConfig.BALANCE.vsDisableAvoidedByCreepers.get()).booleanValue() && event.getEntity() instanceof CreeperEntity) {
                ((CreeperEntity)event.getEntity()).field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)((CreeperEntity)event.getEntity()), PlayerEntity.class, 20.0f, 1.1, 1.3, input -> input != null && (Boolean)VampirePlayer.getOpt((PlayerEntity)input).map(VampirePlayer::getSpecialAttributes).map(s -> s.avoided_by_creepers).orElse((Object)false) != false));
                target = null;
                for (PrioritizedGoal t : ((CreeperEntity)event.getEntity()).field_70715_bh.field_220892_d) {
                    if (!(t.func_220772_j() instanceof NearestAttackableTargetGoal) || t.func_220770_h() != 1) continue;
                    target = t.func_220772_j();
                }
                if (target != null) {
                    ((CreeperEntity)event.getEntity()).field_70715_bh.func_85156_a(target);
                    ((CreeperEntity)event.getEntity()).field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)((CreeperEntity)event.getEntity()), PlayerEntity.class, 10, true, false, input -> input != null && (Boolean)VampirePlayer.getOpt((PlayerEntity)input).map(VampirePlayer::getSpecialAttributes).map(s -> s.avoided_by_creepers).orElse((Object)false) == false));
                } else if (this.warnAboutCreeper) {
                    LOGGER.warn("Could not replace creeper target task");
                    this.warnAboutCreeper = false;
                }
            }
            if (((Boolean)VampirismConfig.BALANCE.zombieIgnoreVampire.get()).booleanValue() && event.getEntity() instanceof ZombieEntity) {
                target = null;
                for (PrioritizedGoal t : ((ZombieEntity)event.getEntity()).field_70715_bh.field_220892_d) {
                    Goal g = t.func_220772_j();
                    if (!(g instanceof NearestAttackableTargetGoal) || !NearestAttackableTargetGoal.class.equals(g.getClass()) || t.func_220770_h() != 2 || !PlayerEntity.class.equals((Object)((NearestAttackableTargetGoal)g).field_75307_b)) continue;
                    target = g;
                    break;
                }
                if (target != null) {
                    ((ZombieEntity)event.getEntity()).field_70715_bh.func_85156_a(target);
                    ((ZombieEntity)event.getEntity()).field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((ZombieEntity)event.getEntity()), PlayerEntity.class, 10, true, false, entity -> !Helper.isVampire((Entity)entity)));
                } else if (this.warnAboutZombie) {
                    LOGGER.warn("Could not replace zombie target task");
                    this.warnAboutZombie = false;
                }
                Goal villagerTarget = null;
                for (PrioritizedGoal t : ((ZombieEntity)event.getEntity()).field_70715_bh.field_220892_d) {
                    if (!(t.func_220772_j() instanceof NearestAttackableTargetGoal) || t.func_220770_h() != 3 || !AbstractVillagerEntity.class.equals((Object)((NearestAttackableTargetGoal)t.func_220772_j()).field_75307_b)) continue;
                    villagerTarget = t.func_220772_j();
                    break;
                }
                if (villagerTarget != null) {
                    ((ZombieEntity)event.getEntity()).field_70715_bh.func_85156_a(villagerTarget);
                    ((ZombieEntity)event.getEntity()).field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((ZombieEntity)event.getEntity()), AbstractVillagerEntity.class, 10, false, false, entity -> !Helper.isVampire((Entity)entity)));
                } else if (this.warnAboutZombie) {
                    LOGGER.warn("Could not replace villager zombie target task");
                    this.warnAboutZombie = false;
                }
            }
            if (event.getEntity() instanceof IronGolemEntity) {
                if (((Boolean)VampirismConfig.BALANCE.golemAttackVampire.get()).booleanValue()) {
                    ((IronGolemEntity)event.getEntity()).field_70715_bh.func_75776_a(4, (Goal)new GolemTargetVampireGoal((IronGolemEntity)event.getEntity()));
                }
                Goal mobTarget = null;
                for (PrioritizedGoal t : ((IronGolemEntity)event.getEntity()).field_70715_bh.field_220892_d) {
                    if (!(t.func_220772_j() instanceof NearestAttackableTargetGoal) || t.func_220770_h() != 3 || !MobEntity.class.equals((Object)((NearestAttackableTargetGoal)t.func_220772_j()).field_75307_b)) continue;
                    mobTarget = t.func_220772_j();
                    break;
                }
                if (mobTarget != null) {
                    ((IronGolemEntity)event.getEntity()).field_70715_bh.func_85156_a(mobTarget);
                    ((IronGolemEntity)event.getEntity()).field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((IronGolemEntity)event.getEntity()), MobEntity.class, 5, false, false, entity -> entity instanceof IMob && !(entity instanceof IHunter) && !(entity instanceof CreeperEntity)));
                } else if (this.warnAboutGolem) {
                    LOGGER.warn("Could not replace villager iron golem target task");
                    this.warnAboutGolem = false;
                }
            }
            if (event.getEntity() instanceof VillagerEntity && (structure = UtilLib.getStructureStartAt(event.getEntity(), Structure.field_236381_q_)) != null && structure.func_75069_d() && structure != StructureStart.field_214630_a && (pos = TotemTileEntity.getTotemPosition(structure)) != null && (tileEntity = event.getWorld().func_175625_s(pos)) instanceof TotemTileEntity && VReference.HUNTER_FACTION.equals(((TotemTileEntity)tileEntity).getControllingFaction())) {
                ExtendedCreature.getSafe(event.getEntity()).ifPresent(e -> e.setPoisonousBlood(true));
            }
        }
    }

    @SubscribeEvent
    public void onEyeHeightSet(EntityEvent.EyeHeight event) {
        if (event.getEntity() instanceof VampireBaseEntity || event.getEntity() instanceof HunterBaseEntity) {
            event.setNewHeight(event.getOldHeight() * 0.875f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getTo().func_77973_b() instanceof VampirismVampireSword) {
            ((VampirismVampireSword)event.getTo().func_77973_b()).updateTrainedCached(event.getTo(), event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof CreatureEntity) {
            event.getEntity().func_130014_f_().func_217381_Z().func_76320_a("vampirism_extended_creature");
            ExtendedCreature.getSafe(event.getEntity()).ifPresent(IExtendedCreatureVampirism::tick);
            event.getEntity().func_130014_f_().func_217381_Z().func_76319_b();
        } else if (!event.getEntity().func_130014_f_().field_72995_K && event.getEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            if (player.field_71070_bA instanceof BloodPotionTableContainer) {
                ((BloodPotionTableContainer)player.field_71070_bA).tick();
            }
        }
    }
}

