/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModVillage;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.VampirismVillagerEntity;
import de.teamlapen.vampirism.entity.villager.Trades;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.SharedMonsterAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.task.VillagerTasks;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ConvertedVillagerEntity
extends VampirismVillagerEntity
implements IConvertedCreature<VillagerEntity> {
    private EnumStrength garlicCache = EnumStrength.NONE;
    private boolean sundamageCache;
    private int bloodTimer = 0;

    public ConvertedVillagerEntity(EntityType<? extends ConvertedVillagerEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (!this.field_70170_p.field_72995_K && this.wantsBlood() && entity instanceof PlayerEntity && !Helper.isHunter(entity) && !UtilLib.canReallySee((LivingEntity)entity, (LivingEntity)this, true)) {
            int amt = (Integer)VampirePlayer.getOpt((PlayerEntity)entity).map(vampire -> vampire.onBite(this)).orElse((Object)0);
            this.drinkBlood(amt, 0.7f);
            return true;
        }
        return super.func_70652_k(entity);
    }

    public ITextComponent func_145748_c_() {
        Team team = this.func_96124_cp();
        if (this.func_200201_e() != null) {
            return super.func_145748_c_();
        }
        VillagerProfession villagerprofession = this.func_213700_eh().func_221130_b();
        IFormattableTextComponent itextcomponent1 = new TranslationTextComponent(EntityType.field_200756_av.func_210760_d() + '.' + (!"minecraft".equals(villagerprofession.getRegistryName().func_110624_b()) ? villagerprofession.getRegistryName().func_110624_b() + '.' : "") + villagerprofession.getRegistryName().func_110623_a()).func_240700_a_(p_211516_1_ -> p_211516_1_.func_240716_a_(this.func_174823_aP()).func_240714_a_(this.func_189512_bd()));
        if (team != null) {
            itextcomponent1.func_240699_a_(team.func_178775_l());
        }
        return itextcomponent1;
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return false;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        this.func_195064_c(new EffectInstance(Effects.field_76428_l, amt * 20));
        this.bloodTimer = -1200 - this.field_70146_Z.nextInt(1200);
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    @Override
    @Nonnull
    public EnumStrength isGettingGarlicDamage(IWorld iWorld, boolean forceRefresh) {
        if (forceRefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this, iWorld);
        }
        return this.garlicCache;
    }

    @Override
    public boolean isGettingSundamage(IWorld iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((LivingEntity)this, iWorld, this.field_70170_p.func_217381_Z());
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return false;
    }

    @Override
    public void func_70636_d() {
        if (this.field_70173_aa % 40 == 1) {
            this.isGettingGarlicDamage((IWorld)this.field_70170_p, true);
        }
        if (this.field_70173_aa % 8 == 2) {
            this.isGettingSundamage((IWorld)this.field_70170_p, true);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isGettingSundamage((IWorld)this.field_70170_p) && this.field_70173_aa % 40 == 11) {
                this.func_195064_c(new EffectInstance(Effects.field_76437_t, 42));
            }
            if (this.isGettingGarlicDamage((IWorld)this.field_70170_p) != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((IWorld)this.field_70170_p), this.field_70173_aa);
            }
        }
        ++this.bloodTimer;
        super.func_70636_d();
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        this.func_195064_c(new EffectInstance(Effects.field_76437_t, amt * 20));
        this.bloodTimer = 0;
        return true;
    }

    @Override
    public boolean wantsBlood() {
        return this.bloodTimer > 0;
    }

    public void func_213744_a(Brain<VillagerEntity> brain) {
        VillagerProfession villagerprofession = this.func_213700_eh().func_221130_b();
        float f = (float)this.func_110148_a(SharedMonsterAttributes.MOVEMENT_SPEED).func_111126_e();
        if (this.func_70631_g_()) {
            brain.func_218203_a(Schedule.field_221385_c);
            brain.func_218208_a(Activity.field_221368_d, VillagerTasks.func_220645_a((float)f));
        } else {
            brain.func_218203_a(ModVillage.converted_default);
            brain.func_233700_a_(Activity.field_221367_c, VillagerTasks.func_220639_b((VillagerProfession)villagerprofession, (float)0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.field_220942_c, (Object)MemoryModuleStatus.VALUE_PRESENT)));
        }
        brain.func_218208_a(Activity.field_221365_a, VillagerTasks.func_220638_a((VillagerProfession)villagerprofession, (float)f));
        brain.func_233700_a_(Activity.field_221370_f, VillagerTasks.func_220637_d((VillagerProfession)villagerprofession, (float)0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.field_220943_d, (Object)MemoryModuleStatus.VALUE_PRESENT)));
        brain.func_218208_a(Activity.field_221369_e, VillagerTasks.func_220635_c((VillagerProfession)villagerprofession, (float)f));
        brain.func_218208_a(Activity.field_221366_b, VillagerTasks.func_220641_e((VillagerProfession)villagerprofession, (float)f));
        brain.func_218208_a(Activity.field_221371_g, VillagerTasks.func_220636_f((VillagerProfession)villagerprofession, (float)f));
        brain.func_218208_a(Activity.field_221373_i, VillagerTasks.func_220642_g((VillagerProfession)villagerprofession, (float)f));
        brain.func_218208_a(Activity.field_221372_h, VillagerTasks.func_220640_h((VillagerProfession)villagerprofession, (float)f));
        brain.func_218208_a(Activity.field_221374_j, VillagerTasks.func_220644_i((VillagerProfession)villagerprofession, (float)f));
        brain.func_218199_a((Set)ImmutableSet.of((Object)Activity.field_221365_a));
        brain.func_218200_b(Activity.field_221366_b);
        brain.func_218202_a(Activity.field_221366_b);
        brain.func_218211_a(this.field_70170_p.func_72820_D(), this.field_70170_p.func_82737_E());
    }

    private void addAdditionalRecipes(MerchantOffers offers) {
        if (offers.size() > 0) {
            offers.remove(this.field_70146_Z.nextInt(offers.size()));
        }
        ArrayList trades = Lists.newArrayList();
        this.addRecipe((List)trades, new ItemStack((IItemProvider)ModItems.human_heart, 9), 2, this.func_70681_au(), 0.5f);
        this.addRecipe((List)trades, 3, new ItemStack((IItemProvider)ModItems.human_heart, 9), this.func_70681_au(), 0.5f);
        ItemStack bottle = new ItemStack((IItemProvider)ModItems.blood_bottle, 3);
        bottle.func_196085_b(9);
        this.addRecipe((List)trades, 1, bottle, this.field_70146_Z, 0.9f);
        offers.addAll((Collection)trades);
    }

    protected void func_213712_ef() {
        super.func_213712_ef();
        if (!this.func_213706_dY().isEmpty() && this.func_70681_au().nextInt(3) == 0) {
            this.func_213717_a(this.func_213706_dY(), Trades.converted_trades, 1);
        }
    }

    private void addRecipe(List list, int emeralds, ItemStack stack, Random rnd, float prop) {
        if (rnd.nextFloat() < prop) {
            list.add(new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, emeralds), stack, 8, 2, 0.2f));
        }
    }

    private void addRecipe(List list, ItemStack stack, int emeralds, Random rnd, float prop) {
        if (rnd.nextFloat() < prop) {
            list.add(new MerchantOffer(stack, new ItemStack((IItemProvider)Items.field_151166_bC, emeralds), 8, 2, 0.2f));
        }
    }

    public static class ConvertingHandler
    implements IConvertingHandler<VillagerEntity> {
        @Override
        public IConvertedCreature<VillagerEntity> createFrom(VillagerEntity entity) {
            CompoundNBT nbt = new CompoundNBT();
            entity.func_189511_e(nbt);
            ConvertedVillagerEntity converted = (ConvertedVillagerEntity)ModEntities.villager_converted.func_200721_a(entity.field_70170_p);
            converted.func_70020_e(nbt);
            converted.func_184221_a(MathHelper.func_180182_a((Random)converted.field_70146_Z));
            return converted;
        }
    }
}

