/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.converted.ConvertedCreatureEntity;
import de.teamlapen.vampirism.util.SharedMonsterAttributes;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;

public class DefaultConvertingHandler<T extends CreatureEntity>
implements IConvertingHandler<T> {
    private static final IConvertingHandler.IDefaultHelper defaultHelper = new IConvertingHandler.IDefaultHelper(){

        @Override
        public double getConvertedDMG(EntityType<? extends CreatureEntity> entityType) {
            AttributeModifierMap map = GlobalEntityTypeAttributes.func_233835_a_(entityType);
            if (map.func_233809_c_(SharedMonsterAttributes.ATTACK_DAMAGE)) {
                return map.func_233807_b_(SharedMonsterAttributes.ATTACK_DAMAGE) * 1.3;
            }
            return BalanceMobProps.mobProps.VAMPIRE_ATTACK_DAMAGE_PL;
        }

        @Override
        public double getConvertedKnockbackResistance(EntityType<? extends CreatureEntity> entityType) {
            AttributeModifierMap map = GlobalEntityTypeAttributes.func_233835_a_(entityType);
            return map.func_233807_b_(SharedMonsterAttributes.KNOCKBACK_RESISTANCE) * 1.3;
        }

        @Override
        public double getConvertedMaxHealth(EntityType<? extends CreatureEntity> entityType) {
            AttributeModifierMap map = GlobalEntityTypeAttributes.func_233835_a_(entityType);
            return map.func_233807_b_(SharedMonsterAttributes.MAX_HEALTH) * 1.5;
        }

        @Override
        public double getConvertedSpeed(EntityType<? extends CreatureEntity> entityType) {
            AttributeModifierMap map = GlobalEntityTypeAttributes.func_233835_a_(entityType);
            return Math.min(map.func_233807_b_(SharedMonsterAttributes.MOVEMENT_SPEED) * 1.2, 2.9);
        }
    };
    protected final IConvertingHandler.IDefaultHelper helper;

    public DefaultConvertingHandler(@Nullable IConvertingHandler.IDefaultHelper helper) {
        this.helper = helper == null ? defaultHelper : helper;
    }

    @Override
    public IConvertedCreature<T> createFrom(T entity) {
        ConvertedCreatureEntity convertedCreature = (ConvertedCreatureEntity)ModEntities.converted_creature.func_200721_a(entity.func_130014_f_());
        this.copyImportantStuff(convertedCreature, entity);
        convertedCreature.func_195064_c(new EffectInstance(Effects.field_76437_t, 200, 2));
        return convertedCreature;
    }

    public IConvertingHandler.IDefaultHelper getHelper() {
        return this.helper;
    }

    protected void copyImportantStuff(ConvertedCreatureEntity<T> converted, T entity) {
        converted.func_82149_j((Entity)entity);
        converted.setEntityCreature(entity);
        converted.updateEntityAttributes();
        converted.func_70606_j(converted.func_110138_aP() / 3.0f * 2.0f);
    }
}

