/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.container;

import de.teamlapen.lib.lib.inventory.InventoryContainer;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class HunterBasicContainer
extends InventoryContainer {
    private static final InventoryContainer.SelectorInfo[] SELECTOR_INFOS = new InventoryContainer.SelectorInfo[]{new InventoryContainer.SelectorInfo(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.vampire_blood_bottle}), 27, 32)};
    private final IHunterPlayer player;
    @Nullable
    private final BasicHunterEntity entity;

    @Deprecated
    public HunterBasicContainer(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, null);
    }

    public HunterBasicContainer(int id, PlayerInventory playerInventory, @Nullable BasicHunterEntity hunter) {
        super(ModContainer.hunter_basic, id, playerInventory, hunter == null ? IWorldPosCallable.field_221489_a : IWorldPosCallable.func_221488_a((World)hunter.field_70170_p, (BlockPos)hunter.func_233580_cy_()), (IInventory)new Inventory(SELECTOR_INFOS.length), SELECTOR_INFOS);
        this.player = HunterPlayer.get(playerInventory.field_70458_d);
        this.addPlayerSlots(playerInventory);
        this.entity = hunter;
    }

    @Override
    public boolean func_75145_c(PlayerEntity playerIn) {
        if (this.entity == null) {
            return false;
        }
        return new Vector3d(playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_()).func_72438_d(new Vector3d(this.entity.func_226277_ct_(), this.entity.func_226278_cu_(), this.entity.func_226281_cx_())) < 5.0;
    }

    public boolean canLevelUp() {
        return this.getMissingCount() == 0;
    }

    public int getMissingCount() {
        int targetLevel = this.player.getLevel() + 1;
        ItemStack blood = this.inventory.func_70301_a(0);
        HunterLevelingConf conf = HunterLevelingConf.instance();
        if (!conf.isLevelValidForBasicHunter(targetLevel)) {
            return -1;
        }
        int required = conf.getVampireBloodCountForBasicHunter(targetLevel);
        return blood.func_190926_b() || !blood.func_77973_b().equals((Object)ModItems.vampire_blood_bottle) ? required : Math.max(0, required - blood.func_190916_E());
    }

    @Override
    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (!playerIn.func_130014_f_().field_72995_K) {
            this.func_193327_a(playerIn, playerIn.func_130014_f_(), this.inventory);
        }
    }

    public void onLevelUpClicked() {
        if (!this.canLevelUp()) {
            return;
        }
        int target = this.player.getLevel() + 1;
        this.inventory.func_70298_a(0, HunterLevelingConf.instance().getVampireBloodCountForBasicHunter(target));
        FactionPlayerHandler.getOpt(this.player.getRepresentingPlayer()).ifPresent(h -> h.setFactionLevel(VReference.HUNTER_FACTION, target));
        this.player.getRepresentingPlayer().func_146105_b((ITextComponent)new TranslationTextComponent("container.vampirism.basic_hunter.levelup"), false);
        this.player.getRepresentingPlayer().func_71053_j();
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity playerEntity, int index) {
        ItemStack result = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            result = slotStack.func_77946_l();
            if (index >= 1) {
                if (index < 27) {
                    if (!this.func_75135_a(slotStack, 0, 1, false)) {
                        return ItemStack.field_190927_a;
                    }
                    if (this.func_75135_a(slotStack, 27, 36, false)) {
                        return ItemStack.field_190927_a;
                    }
                } else if (!this.func_75135_a(slotStack, 0, 27, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (!this.func_75135_a(slotStack, 1, 36, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == result.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerEntity, slotStack);
        }
        return result;
    }
}

