/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory.inventory;

import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.blocks.WeaponTableBlock;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeHooks;

public class WeaponTableCraftingSlot
extends Slot {
    private final PlayerEntity player;
    private final IWorldPosCallable worldPos;
    private final CraftingInventory craftMatrix;
    private int amountCrafted = 0;

    public WeaponTableCraftingSlot(PlayerEntity player, CraftingInventory craftingInventory, IInventory inventoryIn, int index, int xPosition, int yPosition, IWorldPosCallable worldPosCallable) {
        super(inventoryIn, index, xPosition, yPosition);
        this.player = player;
        this.craftMatrix = craftingInventory;
        this.worldPos = worldPosCallable;
    }

    public ItemStack func_75209_a(int amount) {
        if (this.func_75216_d()) {
            this.amountCrafted += Math.min(amount, this.func_75211_c().func_190916_E());
        }
        return super.func_75209_a(amount);
    }

    public boolean func_75214_a(@Nullable ItemStack stack) {
        return false;
    }

    public ItemStack func_190901_a(PlayerEntity playerIn, ItemStack stack) {
        this.func_75208_c(stack);
        int lava = (Integer)this.worldPos.func_221485_a((world, blockPos) -> {
            if (world.func_180495_p(blockPos).func_177230_c() instanceof WeaponTableBlock) {
                return (Integer)world.func_180495_p(blockPos).func_177229_b((Property)WeaponTableBlock.LAVA);
            }
            return 0;
        }, (Object)0);
        HunterPlayer hunterPlayer = HunterPlayer.get(playerIn);
        IWeaponTableRecipe recipe = this.findMatchingRecipe(playerIn, hunterPlayer, lava);
        if (recipe != null && recipe.getRequiredLavaUnits() > 0) {
            this.worldPos.func_221486_a((world, pos) -> {
                int remainingLava = Math.max(0, lava - recipe.getRequiredLavaUnits());
                if (world.func_180495_p(pos).func_177230_c() instanceof WeaponTableBlock) {
                    world.func_175656_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)WeaponTableBlock.LAVA, (Comparable)Integer.valueOf(remainingLava)));
                }
            });
        }
        ForgeHooks.setCraftingPlayer((PlayerEntity)playerIn);
        NonNullList remaining = playerIn.field_70170_p.func_199532_z().func_215369_c(ModRecipes.WEAPONTABLE_CRAFTING_TYPE, (IInventory)this.craftMatrix, playerIn.field_70170_p);
        ForgeHooks.setCraftingPlayer(null);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack itemstack = this.craftMatrix.func_70301_a(i);
            ItemStack itemstack1 = (ItemStack)remaining.get(i);
            if (!itemstack.func_190926_b()) {
                this.craftMatrix.func_70298_a(i, 1);
                itemstack = this.craftMatrix.func_70301_a(i);
            }
            if (itemstack1.func_190926_b()) continue;
            if (itemstack.func_190926_b()) {
                this.craftMatrix.func_70299_a(i, itemstack1);
                continue;
            }
            if (ItemStack.func_179545_c((ItemStack)itemstack, (ItemStack)itemstack1) && ItemStack.func_77970_a((ItemStack)itemstack, (ItemStack)itemstack1)) {
                itemstack1.func_190917_f(itemstack.func_190916_E());
                this.craftMatrix.func_70299_a(i, itemstack1);
                continue;
            }
            if (this.player.field_71071_by.func_70441_a(itemstack1)) continue;
            this.player.func_71019_a(itemstack1, false);
        }
        this.worldPos.func_221486_a((world, pos) -> {
            if (recipe != null && !world.field_72995_K) {
                world.func_217379_c(1030, pos, 0);
            }
        });
        playerIn.func_195066_a(ModStats.weapon_table);
        return stack;
    }

    protected IWeaponTableRecipe findMatchingRecipe(PlayerEntity playerIn, IFactionPlayer<?> factionPlayer, int lava) {
        Optional optional = playerIn.func_130014_f_().func_199532_z().func_215371_a(ModRecipes.WEAPONTABLE_CRAFTING_TYPE, (IInventory)this.craftMatrix, playerIn.func_130014_f_());
        if (optional.isPresent()) {
            IWeaponTableRecipe recipe = (IWeaponTableRecipe)optional.get();
            if (factionPlayer.getLevel() >= recipe.getRequiredLevel() && lava >= recipe.getRequiredLavaUnits() && Helper.areSkillsEnabled(factionPlayer.getSkillHandler(), recipe.getRequiredSkills())) {
                return recipe;
            }
        }
        return null;
    }

    protected void func_75208_c(ItemStack stack) {
        if (this.amountCrafted > 0) {
            stack.func_77980_a(this.player.func_130014_f_(), this.player, this.amountCrafted);
        }
        this.amountCrafted = 0;
    }

    protected void func_75210_a(ItemStack stack, int amount) {
        this.amountCrafted += amount;
        this.func_75208_c(stack);
    }
}

