/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.VampirismItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HunterIntelItem
extends VampirismItem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String name = "hunter_intel";
    private final int level;
    private ITextComponent tooltip;

    public static HunterIntelItem getIntelForExactlyLevel(int level) {
        return HunterIntelItem.getIntelForLevel(level - 5);
    }

    public static HunterIntelItem getIntelForLevel(int level) {
        switch (level) {
            case 0: {
                return ModItems.hunter_intel_0;
            }
            case 1: {
                return ModItems.hunter_intel_1;
            }
            case 2: {
                return ModItems.hunter_intel_2;
            }
            case 3: {
                return ModItems.hunter_intel_3;
            }
            case 4: {
                return ModItems.hunter_intel_4;
            }
            case 5: {
                return ModItems.hunter_intel_5;
            }
            case 6: {
                return ModItems.hunter_intel_6;
            }
            case 7: {
                return ModItems.hunter_intel_7;
            }
            case 8: {
                return ModItems.hunter_intel_8;
            }
            case 9: {
                return ModItems.hunter_intel_9;
            }
        }
        LOGGER.warn("HunterIntel of level {} does not exist", (Object)level);
        return ModItems.hunter_intel_9;
    }

    public HunterIntelItem(int level) {
        super("hunter_intel_" + level, new Item.Properties().func_200916_a(VampirismMod.creativeTab));
        this.level = level;
        this.setTranslation_key(name);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltips, ITooltipFlag flagIn) {
        if (this.tooltip == null) {
            this.tooltip = new TranslationTextComponent("item.vampirism.hunter_intel.for_level").func_230529_a_((ITextComponent)new StringTextComponent(": " + (this.level + 5))).func_240699_a_(TextFormatting.RED);
        }
        tooltips.add(this.tooltip);
    }

    public ITextComponent getCustomName() {
        return new TranslationTextComponent(this.func_195935_o()).func_230529_a_((ITextComponent)new StringTextComponent(" ")).func_230529_a_((ITextComponent)new TranslationTextComponent("item.vampirism.hunter_intel.for_level").func_230529_a_((ITextComponent)new StringTextComponent(" " + (this.level + 5))));
    }

    public int getLevel() {
        return this.level;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }
}

