/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import com.google.common.collect.Multimap;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.VampirismHunterArmor;
import de.teamlapen.vampirism.util.SharedMonsterAttributes;
import de.teamlapen.vampirism.util.VampirismArmorMaterials;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ObsidianArmorItem
extends VampirismHunterArmor
implements IItemWithTier {
    private static final String baseRegName = "obsidian_armor";
    private final IItemWithTier.TIER tier;
    private final int[] DAMAGE_REDUCTION_ULTIMATE = new int[]{5, 10, 11, 5};
    private final int[] DAMAGE_REDUCTION_ENHANCED = new int[]{4, 8, 10, 4};
    private final int[] DAMAGE_REDUCTION_NORMAL = new int[]{3, 7, 9, 3};
    private final float[] SPEED_REDUCTION = new float[]{-0.025f, -0.1f, -0.05f, -0.025f};

    public static boolean isFullyEquipped(PlayerEntity player) {
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ObsidianArmorItem) continue;
            return false;
        }
        return true;
    }

    public ObsidianArmorItem(EquipmentSlotType equipmentSlotIn, IItemWithTier.TIER tier) {
        super(baseRegName, tier.getName(), VampirismArmorMaterials.OBSIDIAN, equipmentSlotIn, new Item.Properties().func_200916_a(VampirismMod.creativeTab));
        this.tier = tier;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        this.addTierInformation(tooltip);
    }

    @Override
    public String getBaseRegName() {
        return baseRegName;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        switch (this.getVampirismTier()) {
            case ENHANCED: {
                return this.getTextureLocation("obsidian_armor_of_hell_enhanced", slot, type);
            }
            case ULTIMATE: {
                return this.getTextureLocation("obsidian_armor_of_hell_ultimate", slot, type);
            }
        }
        return this.getTextureLocation("obsidian_armor_of_hell", slot, type);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap<Attribute, AttributeModifier> map = super.getAttributeModifiers(slot, stack);
        if (slot == this.func_185083_B_()) {
            map.put((Object)SharedMonsterAttributes.MOVEMENT_SPEED, (Object)new AttributeModifier(VAMPIRISM_ARMOR_MODIFIER[slot.func_188454_b()], "Speed modifier", (double)this.getSpeedReduction(slot.func_188454_b()), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        return map;
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    @Override
    protected int getDamageReduction(int slot, ItemStack stack) {
        IItemWithTier.TIER tier = this.getVampirismTier();
        switch (tier) {
            case ULTIMATE: {
                return this.DAMAGE_REDUCTION_ULTIMATE[slot];
            }
            case ENHANCED: {
                return this.DAMAGE_REDUCTION_ENHANCED[slot];
            }
        }
        return this.DAMAGE_REDUCTION_NORMAL[slot];
    }

    private float getSpeedReduction(int slot) {
        return this.SPEED_REDUCTION[slot];
    }
}

