/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.SimpleCrossbowItem;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TechCrossbowItem
extends SimpleCrossbowItem {
    public static final int MAX_ARROW_COUNT = 12;

    private static int getArrowsLeft(@Nonnull ItemStack bowStack) {
        CompoundNBT nbt = bowStack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("arrows")) {
            return 0;
        }
        return nbt.func_74762_e("arrows");
    }

    private static ItemStack setArrowsLeft(@Nonnull ItemStack bowStack, int arrows) {
        int i = Math.max(-1, Math.min(12, arrows));
        CompoundNBT nbt = bowStack.func_77942_o() ? bowStack.func_77978_p() : new CompoundNBT();
        nbt.func_74768_a("arrows", i);
        bowStack.func_77982_d(nbt);
        return bowStack;
    }

    private static boolean reduceArrowCount(@Nonnull ItemStack bowStack, Random rnd) {
        CompoundNBT nbt = bowStack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("arrows")) {
            return false;
        }
        int count = nbt.func_74762_e("arrows");
        if (count == -1) {
            return true;
        }
        if (count == 0) {
            return false;
        }
        int frugal = TechCrossbowItem.isCrossbowFrugal(bowStack);
        if (frugal > 0 && rnd.nextInt(Math.max(2, 4 - frugal)) == 0) {
            return true;
        }
        nbt.func_74768_a("arrows", count - 1);
        bowStack.func_77982_d(nbt);
        return true;
    }

    public static ItemStack getLoadedItemStack(TechCrossbowItem crossbow) {
        return TechCrossbowItem.setArrowsLeft(new ItemStack((IItemProvider)crossbow, 1), 12);
    }

    public static ItemStack getUnLoadedItemStack(TechCrossbowItem crossbow) {
        return TechCrossbowItem.setArrowsLeft(new ItemStack((IItemProvider)crossbow, 1), 0);
    }

    public TechCrossbowItem(String regName, float speed, int cooldown, int maxDamage) {
        super(regName, speed, cooldown, maxDamage);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int arrows = TechCrossbowItem.getArrowsLeft(stack);
        if (arrows == -1) {
            tooltip.add((ITextComponent)new TranslationTextComponent(Enchantments.field_185312_x.func_77320_a()).func_240699_a_(TextFormatting.DARK_GRAY));
        } else if (arrows == 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("text.vampirism.crossbow.not_loaded").func_240699_a_(TextFormatting.DARK_GRAY));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("text.vampirism.crossbow.loaded_arrow_count", new Object[]{arrows}).func_240699_a_(TextFormatting.DARK_GRAY));
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)TechCrossbowItem.setArrowsLeft(new ItemStack((IItemProvider)this), 0));
            items.add((Object)TechCrossbowItem.setArrowsLeft(new ItemStack((IItemProvider)this), 12));
        }
    }

    @Override
    @Nullable
    public ISkill getRequiredSkill(@Nonnull ItemStack stack) {
        return HunterSkills.tech_weapons;
    }

    @Override
    @Nonnull
    protected ItemStack findAmmo(PlayerEntity player, ItemStack bowStack) {
        boolean arrow = TechCrossbowItem.reduceArrowCount(bowStack, player.func_70681_au());
        if (!arrow) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemstack = player.field_71071_by.func_70301_a(i);
                if (itemstack.func_190926_b() || !this.isArrowPackage(itemstack)) continue;
                TechCrossbowItem.setArrowsLeft(bowStack, 12);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70298_a(i, 1);
                }
                player.func_184811_cZ().func_185145_a(bowStack.func_77973_b(), this.getReloadCooldown(player, bowStack));
            }
            return ItemStack.field_190927_a;
        }
        return new ItemStack((IItemProvider)ModItems.crossbow_arrow_normal);
    }

    @Override
    protected float getArrowVelocity() {
        return 1.7f;
    }

    @Override
    protected int getCooldown(PlayerEntity player, ItemStack stack) {
        return 2;
    }

    @Override
    protected boolean isCrossbowInfinite(ItemStack stack, PlayerEntity player) {
        return false;
    }

    @Override
    protected boolean shouldConsumeArrow(Random rnd, ItemStack arrowStack, boolean playerCreative, boolean bowInfinite, int frugal) {
        return false;
    }

    private int getReloadCooldown(PlayerEntity player, ItemStack bowStack) {
        return 100;
    }

    private boolean isArrowPackage(@Nonnull ItemStack stack) {
        return ((Object)((Object)ModItems.tech_crossbow_ammo_package)).equals(stack.func_77973_b());
    }
}

