/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.SharedMonsterAttributes;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class VampirismHunterArmor
extends ArmorItem {
    protected static final UUID[] VAMPIRISM_ARMOR_MODIFIER = new UUID[]{UUID.fromString("f0b9a417-0cec-4629-8623-053cd0feec3c"), UUID.fromString("e54474a9-62a0-48ee-baaf-7efddca3d711"), UUID.fromString("ac0c33f4-ebbf-44fe-9be3-a729f7633329"), UUID.fromString("8839e157-d576-4cff-bf34-0a788131fe0f")};
    private final String translation_key;

    public VampirismHunterArmor(String baseRegName, @Nullable String suffix, IArmorMaterial materialIn, EquipmentSlotType equipmentSlotIn, Item.Properties props) {
        super(materialIn, equipmentSlotIn, props);
        String regName = baseRegName + "_" + equipmentSlotIn.func_188450_d();
        if (suffix != null) {
            regName = regName + "_" + suffix;
        }
        this.setRegistryName("vampirism", regName);
        this.translation_key = Util.func_200697_a((String)"item", (ResourceLocation)new ResourceLocation("vampirism", baseRegName + "_" + equipmentSlotIn.func_188450_d()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack p_77624_1_, @Nullable World p_77624_2_, List<ITextComponent> tooltip, ITooltipFlag p_77624_4_) {
        super.func_77624_a(p_77624_1_, p_77624_2_, tooltip, p_77624_4_);
        PlayerEntity player = VampirismMod.proxy.getClientPlayer();
        if (player != null && Helper.isVampire(player)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("text.vampirism.poisonous_to_vampires").func_240699_a_(TextFormatting.RED));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap map = HashMultimap.create();
        if (slot == this.func_185083_B_()) {
            map.put((Object)SharedMonsterAttributes.ARMOR, (Object)new AttributeModifier(VAMPIRISM_ARMOR_MODIFIER[slot.func_188454_b()], "Armor modifier", (double)this.getDamageReduction(slot.func_188454_b(), stack), AttributeModifier.Operation.ADDITION));
            map.put((Object)SharedMonsterAttributes.ARMOR_TOUGHNESS, (Object)new AttributeModifier(VAMPIRISM_ARMOR_MODIFIER[slot.func_188454_b()], "Armor toughness", this.getToughness(slot.func_188454_b(), stack), AttributeModifier.Operation.ADDITION));
        }
        return map;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (player.field_70173_aa % 16 == 8 && Helper.isVampire(player)) {
            player.func_195064_c(new EffectInstance(ModEffects.poison, 20, 1));
        }
    }

    protected abstract int getDamageReduction(int var1, ItemStack var2);

    protected String func_195935_o() {
        return this.translation_key;
    }

    protected String getTextureLocation(String name, EquipmentSlotType slot, String type) {
        return String.format("vampirism:textures/models/armor/%s_layer_%d%s.png", name, slot == EquipmentSlotType.LEGS ? 2 : 1, type == null ? "" : "_overlay");
    }

    protected double getToughness(int slot, ItemStack stack) {
        return this.func_234657_f_();
    }
}

