/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.items.IBloodChargeable;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.items.VampirismItemWeapon;
import de.teamlapen.vampirism.particle.FlyingBloodParticleData;
import de.teamlapen.vampirism.particle.GenericParticleData;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.skills.VampireSkills;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class VampirismVampireSword
extends VampirismItemWeapon
implements IBloodChargeable {
    public static final String DO_NOT_NAME_STRING = "DO_NOT_NAME";
    private final float minStrength = 0.2f;
    private final float trainedAttackSpeed;
    private final float untrainedAttackSpeed;

    public VampirismVampireSword(String regName, ItemTier material, int attackDamage, float untrainedAttackSpeed, float trainedAttackSpeed, Item.Properties prop) {
        super(regName, (IItemTier)material, attackDamage, untrainedAttackSpeed, prop);
        this.trainedAttackSpeed = trainedAttackSpeed;
        this.untrainedAttackSpeed = untrainedAttackSpeed;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        float charged = this.getCharged(stack);
        float trained = this.getTrained(stack, (LivingEntity)VampirismMod.proxy.getClientPlayer());
        tooltip.add((ITextComponent)new TranslationTextComponent("text.vampirism.sword_charged").func_230529_a_((ITextComponent)new StringTextComponent(" " + (int)Math.ceil(charged * 100.0f) + "%")));
        tooltip.add((ITextComponent)new TranslationTextComponent("text.vampirism.sword_trained").func_230529_a_((ITextComponent)new StringTextComponent(" " + (int)Math.ceil(trained * 100.0f) + "%")));
        if (Minecraft.func_71410_x().field_71439_g != null && !Helper.isVampire((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("text.vampirism.can_only_be_used_by", new Object[]{VReference.VAMPIRE_FACTION.getNamePlural()}));
        }
    }

    @Override
    public boolean canBeCharged(ItemStack stack) {
        return this.getCharged(stack) < 1.0f;
    }

    @Override
    public int charge(ItemStack stack, int amount) {
        float factor = this.getChargingFactor(stack);
        float charge = this.getCharged(stack);
        float actual = Math.min(factor * (float)amount, 1.0f - charge);
        this.setCharged(stack, charge + actual);
        return (int)(actual / factor);
    }

    public void doNotName(ItemStack stack) {
        stack.func_77983_a("dont_name", (INBT)ByteNBT.func_229671_a_((byte)127));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (!super.canApplyAtEnchantingTable(stack, enchantment)) {
            return false;
        }
        return Enchantments.field_77334_n.equals(enchantment) || Enchantments.field_185304_p.equals(enchantment) || Enchantments.field_180313_o.equals(enchantment) || Enchantments.field_185307_s.equals(enchantment);
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof PlayerEntity && (double)target.func_110143_aJ() <= (double)target.func_110138_aP() * (Double)VampirismConfig.BALANCE.vsSwordFinisherMaxHealth.get() && !Helper.isVampire((Entity)target) && ((Boolean)VampirePlayer.getOpt((PlayerEntity)attacker).map(VampirePlayer::getSkillHandler).map(h -> h.isSkillEnabled(VampireSkills.sword_finisher)).orElse((Object)false)).booleanValue()) {
            DamageSource dmg = DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)).func_76348_h();
            target.func_70097_a(dmg, 10000.0f);
            Vector3d center = Vector3d.func_237491_b_((Vector3i)target.func_233580_cy_());
            center.func_72441_c(0.0, (double)target.func_213302_cg() / 2.0, 0.0);
            ModParticles.spawnParticlesServer(target.field_70170_p, new GenericParticleData(ModParticles.generic, new ResourceLocation("minecraft", "effect_4"), 12, 0xE02020), center.field_72450_a, center.field_72448_b, center.field_72449_c, 15, 0.5, 0.5, 0.5, 0.0);
        }
        return super.func_77644_a(stack, target, attacker);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        float charged;
        if (worldIn.field_72995_K && (isSelected || itemSlot == 0) && (charged = this.getCharged(stack)) > 0.0f && entityIn.field_70173_aa % (int)(20.0f + 100.0f * (1.0f - charged)) == 0 && entityIn instanceof LivingEntity) {
            boolean secondHand;
            boolean bl = secondHand = !isSelected && ((LivingEntity)entityIn).func_184586_b(Hand.OFF_HAND).equals(stack);
            if (isSelected || secondHand) {
                this.spawnChargedParticle((LivingEntity)entityIn, isSelected);
            }
        }
    }

    public boolean isFullyCharged(ItemStack stack) {
        return this.getCharged(stack) == 1.0f;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_70089_S()) {
            VampirePlayer vampire = VampirePlayer.get(playerIn);
            if (vampire.getLevel() == 0) {
                return new ActionResult(ActionResultType.PASS, (Object)stack);
            }
            if (this.canBeCharged(stack) && playerIn.func_225608_bj_() && (playerIn.func_184812_l_() || vampire.getBloodLevel() >= 2) && vampire.getSkillHandler().isSkillEnabled(VampireSkills.blood_charge)) {
                playerIn.func_184598_c(handIn);
                return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return stack;
        }
        VReference.VAMPIRE_FACTION.getPlayerCapability((PlayerEntity)entityLiving).ifPresent(vampire -> {
            if (((PlayerEntity)entityLiving).func_184812_l_() || vampire.useBlood(2, false)) {
                this.charge(stack, 200);
            }
        });
        if (this.getCharged(stack) == 1.0f) {
            this.tryName(stack, (PlayerEntity)entityLiving);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player.func_130014_f_().field_72995_K && count % 3 == 0) {
            this.spawnChargingParticle(player, player.func_184614_ca().equals(stack));
        }
    }

    public void setCharged(@Nonnull ItemStack stack, float value) {
        stack.func_77983_a("charged", (INBT)FloatNBT.func_229689_a_((float)MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f)));
    }

    public void setTrained(@Nonnull ItemStack stack, @Nonnull LivingEntity player, float value) {
        CompoundNBT nbt = stack.func_190925_c("trained");
        nbt.func_74776_a(player.func_110124_au().toString(), MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f));
    }

    public void tryName(ItemStack stack, PlayerEntity player) {
        if (!(stack.func_82837_s() || !(player instanceof ServerPlayerEntity) || stack.func_77942_o() && stack.func_77978_p().func_74767_n("dont_name"))) {
            VampirismMod.proxy.displayNameSwordScreen(stack);
            player.field_70170_p.func_184134_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        }
    }

    public boolean updateTrainedCached(@Nonnull ItemStack stack, @Nonnull LivingEntity player) {
        float trained;
        float cached = this.getTrained(stack);
        if (cached != (trained = this.getTrained(stack, player))) {
            stack.func_77983_a("trained-cache", (INBT)FloatNBT.func_229689_a_((float)trained));
            return true;
        }
        return false;
    }

    @Override
    protected final float getAttackDamage(ItemStack stack) {
        return super.getAttackDamage(stack) * this.getAttackDamageModifier(stack);
    }

    protected float getAttackDamageModifier(ItemStack stack) {
        return this.getCharged(stack) > 0.0f ? 1.0f : 0.2f;
    }

    protected float getCharged(@Nonnull ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74760_g("charged");
        }
        return 0.0f;
    }

    protected abstract float getChargingFactor(ItemStack var1);

    protected float getTrained(@Nonnull ItemStack stack, @Nullable LivingEntity player) {
        if (player == null) {
            return this.getTrained(stack);
        }
        UUID id = player.func_110124_au();
        CompoundNBT nbt = stack.func_179543_a("trained");
        if (nbt != null && nbt.func_74764_b(id.toString())) {
            return nbt.func_74760_g(id.toString());
        }
        return 0.0f;
    }

    protected float getTrained(@Nonnull ItemStack stack) {
        CompoundNBT nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("trained-cache")) {
            return nbt.func_74760_g("trained-cache");
        }
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnChargedParticle(LivingEntity player, boolean mainHand) {
        Vector3d mainPos = UtilLib.getItemPosition(player, mainHand);
        for (int j = 0; j < 3; ++j) {
            Vector3d pos = mainPos.func_72441_c((double)((player.func_70681_au().nextFloat() - 0.5f) * 0.1f), (double)((player.func_70681_au().nextFloat() - 0.3f) * 0.9f), (double)((player.func_70681_au().nextFloat() - 0.5f) * 0.1f));
            ModParticles.spawnParticleClient(player.func_130014_f_(), new FlyingBloodParticleData(ModParticles.flying_blood, (int)(4.0f / (player.func_70681_au().nextFloat() * 0.9f + 0.1f)), true, pos.field_72450_a + ((double)player.func_70681_au().nextFloat() - 0.5) * 0.1, pos.field_72448_b + ((double)player.func_70681_au().nextFloat() - 0.5) * 0.1, pos.field_72449_c + ((double)player.func_70681_au().nextFloat() - 0.5) * 0.1, new ResourceLocation("minecraft", "glitter_1")), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnChargingParticle(LivingEntity player, boolean mainHand) {
        Vector3d pos = UtilLib.getItemPosition(player, mainHand);
        if (player.func_70678_g(1.0f) > 0.0f) {
            return;
        }
        pos = pos.func_72441_c((double)((player.func_70681_au().nextFloat() - 0.5f) * 0.1f), (double)((player.func_70681_au().nextFloat() - 0.3f) * 0.9f), (double)((player.func_70681_au().nextFloat() - 0.5f) * 0.1f));
        Vector3d playerPos = new Vector3d(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e() - (double)0.2f, player.func_226281_cx_());
        ModParticles.spawnParticleClient(player.func_130014_f_(), new FlyingBloodParticleData(ModParticles.flying_blood, (int)(4.0f / (player.func_70681_au().nextFloat() * 0.6f + 0.1f)), true, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c), playerPos.field_72450_a, playerPos.field_72448_b, playerPos.field_72449_c);
    }

    @Override
    protected final float getAttackSpeed(ItemStack stack) {
        return this.untrainedAttackSpeed + (this.trainedAttackSpeed - this.untrainedAttackSpeed) * this.getTrained(stack);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return !Helper.isVampire((Entity)entity);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        return !Helper.isVampire(player);
    }
}

